/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.AbstractSceneController;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.view.OrbitView;
import javax.media.opengl.GL;

public class AnaglyphSceneController
extends AbstractSceneController {
    public static String DISPLAY_MODE_MONO = "AnaglyphSceneController_DISPLAY_MODE_MONO";
    public static String DISPLAY_MODE_STEREO = "AnaglyphSceneController_DISPLAY_MODE_STEREO";
    private String displayMode = DISPLAY_MODE_STEREO;
    private Angle focusAngle = Angle.fromDegrees(1.6);
    private Angle viewMinPitch = Angle.fromDegrees(20.0);

    public void setDisplayMode(String string) {
        this.displayMode = string;
    }

    public String getDisplayMode() {
        return this.displayMode;
    }

    public void setFocusAngle(Angle angle) {
        this.focusAngle = angle;
    }

    public Angle getFocusAngle() {
        return this.focusAngle;
    }

    public void setViewMinPitch(Angle angle) {
        this.viewMinPitch = angle;
    }

    public Angle getViewMinPitch() {
        return this.viewMinPitch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRepaint(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        this.initializeFrame(drawContext);
        try {
            this.applyView(drawContext);
            this.createTerrain(drawContext);
            this.preRender(drawContext);
            this.clearFrame(drawContext);
            this.pick(drawContext);
            this.clearFrame(drawContext);
            OrbitView orbitView = (OrbitView)drawContext.getView();
            if (this.displayMode.equals(DISPLAY_MODE_STEREO) && orbitView.getPitch().degrees > this.viewMinPitch.degrees) {
                gL.glColorMask(true, false, false, true);
            }
            this.draw(drawContext);
            if (this.displayMode.equals(DISPLAY_MODE_STEREO) && orbitView.getPitch().degrees > this.viewMinPitch.degrees) {
                Angle angle = orbitView.getHeading();
                orbitView.setHeading(orbitView.getHeading().subtract(this.focusAngle));
                orbitView.apply(drawContext);
                gL.glClear(256);
                gL.glDisable(2912);
                gL.glColorMask(false, true, true, true);
                this.draw(drawContext);
                orbitView.setHeading(angle);
                orbitView.apply(drawContext);
                gL.glColorMask(true, true, true, true);
            }
        }
        finally {
            this.finalizeFrame(drawContext);
        }
    }
}

