/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Factory;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.exception.WWUnrecognizedException;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.terrain.BasicElevationModelFactory;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwind.wms.Capabilities;
import java.io.File;

public class BasicFactory
implements Factory {
    public Object createFromKeys(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            String string = Logging.getMessage("nullValue.KeyListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (String string : stringArray) {
            try {
                Object object = this.doCreateFromKey(string);
                if (object != null) {
                    return 0;
                }
                if (string.endsWith("ClassName")) {
                    if (Configuration.getStringValue(string) == null) continue;
                    return this.createFromClassName(Configuration.getStringValue(string));
                }
                if (string.endsWith("ConfigFile")) {
                    if (Configuration.getStringValue(string) == null) continue;
                    return this.createFromConfigFile(Configuration.getStringValue(string));
                }
                if (string.endsWith("Capabilities")) {
                    if (Configuration.getStringValue(string) == null) continue;
                    return this.createFromCapabilities(Configuration.getStringValue(string), null);
                }
                return this.createFromClassName(Configuration.getStringValue(string));
            }
            catch (WWRuntimeException wWRuntimeException) {
                String string2 = Logging.getMessage("BasicFactory.ConfigurationFailed", string);
                throw new WWRuntimeException(string2, wWRuntimeException);
            }
        }
        throw new WWUnrecognizedException(Logging.getMessage("BasicFactory.UnrecognizedConfigurationKeys"));
    }

    protected Object doCreateFromKey(String string) {
        return null;
    }

    public Object createFromClassName(String string) {
        return WorldWind.createComponent(string);
    }

    public Object createFromConfigFile(String string) {
        return null;
    }

    public ElevationModel createFromCapabilities(String string, AVList aVList) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        File file = new File(string);
        if (!file.exists()) {
            String string3 = Logging.getMessage("generic.FileNotFound", file.getPath());
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        Capabilities capabilities = Capabilities.parse(WWXML.openDocumentFile(string, BasicElevationModelFactory.class));
        return this.doCreateFromCapabilities(capabilities, aVList);
    }

    protected ElevationModel doCreateFromCapabilities(Capabilities capabilities, AVList aVList) {
        return null;
    }
}

