/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.BasicModel;
import gov.nasa.worldwind.BasicSceneController;
import gov.nasa.worldwind.WorldWindowGLAutoDrawable;
import gov.nasa.worldwind.awt.AWTInputHandler;
import gov.nasa.worldwind.cache.BasicDataFileStore;
import gov.nasa.worldwind.cache.BasicMemoryCacheSet;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.globes.Earth;
import gov.nasa.worldwind.layers.CompassLayer;
import gov.nasa.worldwind.layers.Earth.BMNGSurfaceLayer;
import gov.nasa.worldwind.layers.Earth.EarthNASAPlaceNameLayer;
import gov.nasa.worldwind.layers.Earth.LandsatI3;
import gov.nasa.worldwind.layers.Earth.USGSUrbanAreaOrtho;
import gov.nasa.worldwind.layers.StarsLayer;
import gov.nasa.worldwind.retrieve.BasicRetrievalService;
import gov.nasa.worldwind.terrain.BasicElevationModelFactory;
import gov.nasa.worldwind.terrain.RectangularTessellator;
import gov.nasa.worldwind.util.BasicNetworkStatus;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.ThreadedTaskService;
import gov.nasa.worldwind.view.BasicOrbitView;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;

public class Configuration {
    private static final String DEFAULT_LOGGER_NAME = "gov.nasa.worldwind";
    private static final String CONFIG_FILE_NAME = "config/worldwind.properties";
    private static final String CONFIG_FILE_PROPERTY_KEY = "gov.nasa.worldwind.config.file";
    private static Configuration ourInstance = new Configuration();
    private final Properties properties = new Properties(this.initializeDefaults());

    private static Configuration getInstance() {
        return ourInstance;
    }

    private Configuration() {
        this.initializeCustom();
    }

    private Properties initializeDefaults() {
        Properties properties = new Properties();
        properties.setProperty("gov.nasa.worldwind.avkey.LoggerName", DEFAULT_LOGGER_NAME);
        properties.setProperty("gov.nasa.worldwind.avkey.DataFileStoreConfigurationFileName", "config/DataFileStore.xml");
        properties.setProperty("gov.nasa.worldwind.avkey.DataFileStoreClassName", BasicDataFileStore.class.getName());
        properties.setProperty("gov.nasa.worldwind.avkey.GlobeClassName", Earth.class.getName());
        properties.setProperty("gov.nasa.worldwind.avkey.EarthElevationModelConfigFile", "config/LegacyEarthElevationModel.xml");
        properties.setProperty("gov.nasa.worldwind.avkey.ElevationModelFactory", BasicElevationModelFactory.class.getName());
        properties.setProperty("gov.nasa.worldwind.avkey.TessellatorClassName", RectangularTessellator.class.getName());
        properties.setProperty("gov.nasa.worldwind.avkey.InputHandlerClassName", AWTInputHandler.class.getName());
        properties.setProperty("gov.nasa.worldwind.avkey.MemoryCacheSetClassName", BasicMemoryCacheSet.class.getName());
        properties.setProperty("gov.nasa.worldwind.avkey.WorldWindowClassName", WorldWindowGLAutoDrawable.class.getName());
        properties.setProperty("gov.nasa.worldwind.avkey.ModelClassName", BasicModel.class.getName());
        properties.setProperty("gov.nasa.worldwind.avkey.RetrievalServiceClassName", BasicRetrievalService.class.getName());
        properties.setProperty("gov.nasa.worldwind.avkey.SceneControllerClassName", BasicSceneController.class.getName());
        properties.setProperty("gov.nasa.worldwind.avkey.TaskServiceClassName", ThreadedTaskService.class.getName());
        properties.setProperty("gov.nasa.worldwind.avkey.ViewClassName", BasicOrbitView.class.getName());
        properties.setProperty("gov.nasa.worldwind.avkey.NetworkStatusClassName", BasicNetworkStatus.class.getName());
        properties.setProperty("gov.nasa.worldwind.avkey.LayerClassNames", StarsLayer.class.getName() + "," + BMNGSurfaceLayer.class.getName() + "," + LandsatI3.class.getName() + "," + USGSUrbanAreaOrtho.class.getName() + "," + EarthNASAPlaceNameLayer.class.getName() + "," + CompassLayer.class.getName());
        properties.setProperty("gov.nasa.worldwind.avkey.BMNGOneImagePath", "images/BMNG_world.topo.bathy.200405.3.2048x1024.jpg");
        properties.setProperty("gov.nasa.worldwind.avkey.WorldMapImagePath", "images/earth-map-512x256.png");
        TimeZone timeZone = Calendar.getInstance().getTimeZone();
        if (timeZone != null) {
            properties.setProperty("gov.nasa.worldwind.avkey.InitialLongitude", Double.toString(Angle.fromDegrees((double)(180.0 * (double)timeZone.getOffset((long)System.currentTimeMillis()) / 4.32E7)).degrees));
        }
        properties.setProperty("gov.nasa.worldwind.avkey.InitialAltitude", Double.toString(1.9134411E7));
        return properties;
    }

    private void initializeCustom() {
        String string = System.getProperty(CONFIG_FILE_PROPERTY_KEY, CONFIG_FILE_NAME);
        try {
            InputStream inputStream = null;
            File file = new File(string);
            if (file.exists()) {
                try {
                    inputStream = new FileInputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    String string2 = Logging.getMessage("Configuration.LocalConfigFileNotFound", string);
                    Logging.logger().finest(string2);
                }
            }
            if (inputStream == null) {
                inputStream = this.getClass().getResourceAsStream("/" + string);
            }
            if (inputStream == null) {
                Logging.logger().log(Level.WARNING, "Configuration.UnavailablePropsFile", string);
            }
            if (inputStream != null) {
                this.properties.load(inputStream);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logging.logger(DEFAULT_LOGGER_NAME).log(Level.WARNING, "Configuration.UnavailablePropsFile", string);
        }
        catch (IOException iOException) {
            Logging.logger(DEFAULT_LOGGER_NAME).log(Level.SEVERE, "Configuration.ExceptionReadingPropsFile", iOException);
        }
        catch (Exception exception) {
            Logging.logger(DEFAULT_LOGGER_NAME).log(Level.SEVERE, "Configuration.ExceptionReadingPropsFile", exception);
        }
    }

    public static synchronized String getStringValue(String string, String string2) {
        String string3 = Configuration.getStringValue(string);
        return string3 != null ? string3 : string2;
    }

    public static synchronized String getStringValue(String string) {
        return Configuration.getInstance().properties.getProperty(string);
    }

    public static synchronized Integer getIntegerValue(String string, Integer n) {
        Integer n2 = Configuration.getIntegerValue(string);
        return n2 != null ? n2 : n;
    }

    public static synchronized Integer getIntegerValue(String string) {
        String string2 = Configuration.getStringValue(string);
        if (string2 == null) {
            return null;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.logger().log(Level.SEVERE, "Configuration.ConversionError", string2);
            return null;
        }
    }

    public static synchronized Long getLongValue(String string, Long l) {
        Long l2 = Configuration.getLongValue(string);
        return l2 != null ? l2 : l;
    }

    public static synchronized Long getLongValue(String string) {
        String string2 = Configuration.getStringValue(string);
        if (string2 == null) {
            return null;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.logger().log(Level.SEVERE, "Configuration.ConversionError", string2);
            return null;
        }
    }

    public static synchronized Double getDoubleValue(String string, Double d) {
        Double d2 = Configuration.getDoubleValue(string);
        return d2 != null ? d2 : d;
    }

    public static synchronized Double getDoubleValue(String string) {
        String string2 = Configuration.getStringValue(string);
        if (string2 == null) {
            return null;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.logger().log(Level.SEVERE, "Configuration.ConversionError", string2);
            return null;
        }
    }

    public static synchronized boolean hasKey(String string) {
        return Configuration.getInstance().properties.contains(string);
    }

    public static synchronized void removeKey(String string) {
        Configuration.getInstance().properties.remove(string);
    }

    public static synchronized void setValue(String string, Object object) {
        Configuration.getInstance().properties.put(string, object.toString());
    }

    public static String getCurrentWorkingDirectory() {
        String string = System.getProperty("user.dir");
        return string != null ? string : ".";
    }

    public static String getUserHomeDirectory() {
        String string = System.getProperty("user.home");
        return string != null ? string : ".";
    }

    public static String getSystemTempDirectory() {
        String string = System.getProperty("java.io.tmpdir");
        return string != null ? string : ".";
    }

    public static boolean isMacOS() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().contains("mac");
    }

    public static boolean isWindowsOS() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().contains("windows");
    }

    public static boolean isLinuxOS() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().contains("linux");
    }

    public static boolean isUnixOS() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().contains("unix");
    }

    public static boolean isSolarisOS() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().contains("solaris");
    }

    public static float getJavaVersion() {
        float f = 0.0f;
        String string = System.getProperty("java.specification.version");
        if (null == string || string.length() == 0) {
            string = System.getProperty("java.version");
        }
        try {
            f = Float.parseFloat(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return f;
    }
}

