/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.SceneController;
import gov.nasa.worldwind.WorldWindowGLDrawable;
import gov.nasa.worldwind.WorldWindowImpl;
import gov.nasa.worldwind.cache.TextureCache;
import gov.nasa.worldwind.event.PositionEvent;
import gov.nasa.worldwind.event.RenderingEvent;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.exception.WWAbsentRequirementException;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.util.Logging;
import java.beans.PropertyChangeEvent;
import java.util.logging.Level;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;

public class WorldWindowGLAutoDrawable
extends WorldWindowImpl
implements WorldWindowGLDrawable,
GLEventListener {
    private GLAutoDrawable drawable;
    private boolean shuttingDown = false;

    public WorldWindowGLAutoDrawable() {
        SceneController sceneController = this.getSceneController();
        if (sceneController != null) {
            sceneController.addPropertyChangeListener(this);
        }
    }

    public void initDrawable(GLAutoDrawable gLAutoDrawable) {
        if (gLAutoDrawable == null) {
            String string = Logging.getMessage("nullValue.DrawableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.drawable = gLAutoDrawable;
        this.drawable.setAutoSwapBufferMode(false);
        this.drawable.addGLEventListener(this);
    }

    public void initTextureCache(TextureCache textureCache) {
        if (textureCache == null) {
            String string = Logging.getMessage("nullValue.TextureCacheIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setTextureCache(textureCache);
    }

    public void shutdown() {
        this.shuttingDown = true;
        this.drawable.display();
    }

    protected void doShutdown() {
        super.shutdown();
        this.drawable.removeGLEventListener(this);
        this.shuttingDown = false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            String string = Logging.getMessage("nullValue.PropertyChangeEventIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.drawable != null) {
            this.drawable.repaint();
        }
    }

    protected String[] getRequiredOglFunctions() {
        return new String[]{"glActiveTexture", "glClientActiveTexture"};
    }

    protected String[] getRequiredOglExtensions() {
        return new String[0];
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        for (String string : this.getRequiredOglFunctions()) {
            if (gLAutoDrawable.getGL().isFunctionAvailable(string)) continue;
            this.callRenderingExceptionListeners(new WWAbsentRequirementException(string + " not available"));
        }
        for (String string : this.getRequiredOglExtensions()) {
            if (gLAutoDrawable.getGL().isExtensionAvailable(string)) continue;
            this.callRenderingExceptionListeners(new WWAbsentRequirementException(string + " not available"));
        }
        if (this.getTextureCache() != null) {
            this.getTextureCache().clear();
        }
        this.getSceneController().reinitialize();
        if (this.getModel() != null && this.getModel().getLayers() != null) {
            for (Layer layer : this.getModel().getLayers()) {
                layer.dispose();
            }
        }
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        if (this.shuttingDown) {
            try {
                this.doShutdown();
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, Logging.getMessage("WorldWindowGLCanvas.ExceptionWhileShuttingDownWorldWindow"), exception);
            }
            return;
        }
        try {
            Double d;
            SceneController sceneController = this.getSceneController();
            if (sceneController == null) {
                Logging.logger().severe("WorldWindowGLCanvas.ScnCntrllerNullOnRepaint");
                throw new IllegalStateException(Logging.getMessage("WorldWindowGLCanvas.ScnCntrllerNullOnRepaint"));
            }
            Position position = this.getCurrentPosition();
            PickedObject pickedObject = this.getCurrentSelection();
            try {
                this.callRenderingListeners(new RenderingEvent(this.drawable, "gov.nasa.worldwind.RenderingEvent.BeforeRendering"));
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, Logging.getMessage("WorldWindowGLAutoDrawable.ExceptionDuringGLEventListenerDisplay"), exception);
            }
            this.doDisplay();
            try {
                this.callRenderingListeners(new RenderingEvent(this.drawable, "gov.nasa.worldwind.RenderingEvent.BeforeBufferSwap"));
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, Logging.getMessage("WorldWindowGLAutoDrawable.ExceptionDuringGLEventListenerDisplay"), exception);
            }
            this.doSwapBuffers(this.drawable);
            Double d2 = sceneController.getFrameTime();
            if (d2 != null) {
                this.setValue("gov.nasa.worldwind.perfstat.FrameTime", d2);
            }
            if ((d = Double.valueOf(sceneController.getFramesPerSecond())) != null) {
                this.setValue("gov.nasa.worldwind.perfstat.FrameRate", d);
            }
            this.callRenderingListeners(new RenderingEvent(this.drawable, "gov.nasa.worldwind.RenderingEvent.AfterBufferSwap"));
            Position position2 = this.getCurrentPosition();
            if ((position != null || position2 != null) && position != position2) {
                this.callPositionListeners(new PositionEvent(this.drawable, sceneController.getPickPoint(), position, position2));
            }
            PickedObject pickedObject2 = this.getCurrentSelection();
            if ((pickedObject != null || pickedObject2 != null) && pickedObject != pickedObject2) {
                this.callSelectListeners(new SelectEvent((Object)this.drawable, "gov.nasa.worldwind.SelectEvent.Rollover", sceneController.getPickPoint(), sceneController.getPickedObjectList()));
            }
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("WorldWindowGLCanvas.ExceptionAttemptingRepaintWorldWindow"), exception);
        }
    }

    protected void doDisplay() {
        this.getSceneController().repaint();
    }

    protected void doSwapBuffers(GLAutoDrawable gLAutoDrawable) {
        gLAutoDrawable.swapBuffers();
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        Logging.logger().finest("WorldWindowGLCanvas.DisplayEventListenersDisplayChangedMethodCalled");
    }

    public void redrawNow() {
        if (this.drawable != null) {
            this.drawable.display();
        }
    }
}

