/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.awt;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.ViewInputHandler;
import gov.nasa.worldwind.event.DragSelectEvent;
import gov.nasa.worldwind.event.InputHandler;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.util.Logging;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;

public class AWTInputHandler
extends WWObjectImpl
implements KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
FocusListener,
InputHandler,
Disposable {
    private WorldWindow wwd = null;
    private EventListenerList eventListeners = new EventListenerList();
    private Point mousePoint = new Point();
    private PickedObjectList hoverObjects;
    private PickedObjectList objectsAtButtonPress;
    private boolean isHovering = false;
    private boolean isDragging = false;
    private Timer hoverTimer = new Timer(600, new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (AWTInputHandler.this.pickMatches(AWTInputHandler.this.hoverObjects)) {
                AWTInputHandler.this.isHovering = true;
                AWTInputHandler.this.callSelectListeners(new SelectEvent((Object)AWTInputHandler.this.wwd, "gov.nasa.worldwind.SelectEvent.Hover", AWTInputHandler.this.mousePoint, AWTInputHandler.this.hoverObjects));
                AWTInputHandler.this.hoverTimer.stop();
            }
        }
    });
    private final ViewInputHandler viewInputHandler = new ViewInputHandler();
    private SelectListener selectListener;

    public void dispose() {
        this.hoverTimer.stop();
        this.hoverTimer = null;
        this.setEventSource(null);
        if (this.hoverObjects != null) {
            this.hoverObjects.clear();
        }
        this.hoverObjects = null;
        if (this.objectsAtButtonPress != null) {
            this.objectsAtButtonPress.clear();
        }
        this.objectsAtButtonPress = null;
    }

    public void setEventSource(WorldWindow worldWindow) {
        Component component;
        if (worldWindow != null && !(worldWindow instanceof Component)) {
            String string = Logging.getMessage("Awt.AWTInputHandler.EventSourceNotAComponent");
            Logging.logger().finer(string);
            throw new IllegalArgumentException(string);
        }
        if (worldWindow == this.wwd) {
            return;
        }
        this.eventListeners = new EventListenerList();
        if (this.wwd != null) {
            component = (Component)((Object)this.wwd);
            component.removeKeyListener(this);
            component.removeMouseMotionListener(this);
            component.removeMouseListener(this);
            component.removeMouseWheelListener(this);
            component.removeFocusListener(this);
            if (this.selectListener != null) {
                this.wwd.removeSelectListener(this.selectListener);
            }
        }
        this.wwd = worldWindow;
        this.viewInputHandler.setWorldWindow(this.wwd);
        if (this.wwd == null) {
            return;
        }
        component = (Component)((Object)this.wwd);
        component.addKeyListener(this);
        component.addMouseMotionListener(this);
        component.addMouseListener(this);
        component.addMouseWheelListener(this);
        component.addFocusListener(this);
        this.selectListener = new SelectListener(){

            public void selected(SelectEvent selectEvent) {
                if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover")) {
                    AWTInputHandler.this.doHover(true);
                }
            }
        };
        this.wwd.addSelectListener(this.selectListener);
    }

    public void removeHoverSelectListener() {
        this.hoverTimer.stop();
        this.hoverTimer = null;
        this.wwd.removeSelectListener(this.selectListener);
    }

    public WorldWindow getEventSource() {
        return this.wwd;
    }

    public void setHoverDelay(int n) {
        this.hoverTimer.setDelay(n);
    }

    public int getHoverDelay() {
        return this.hoverTimer.getDelay();
    }

    public boolean isSmoothViewChanges() {
        return this.viewInputHandler.isEnableSmoothing();
    }

    public void setSmoothViewChanges(boolean bl) {
        this.viewInputHandler.setEnableSmoothing(bl);
    }

    public boolean isLockViewHeading() {
        return this.viewInputHandler.isLockHeading();
    }

    public void setLockViewHeading(boolean bl) {
        this.viewInputHandler.setLockHeading(bl);
    }

    public boolean isStopViewOnFocusLost() {
        return this.viewInputHandler.isStopOnFocusLost();
    }

    public void setStopViewOnFocusLost(boolean bl) {
        this.viewInputHandler.setStopOnFocusLost(bl);
    }

    protected WorldWindow getWorldWindow() {
        return this.wwd;
    }

    protected Point getMousePoint() {
        return this.mousePoint;
    }

    protected void setMousePoint(Point point) {
        this.mousePoint = point;
    }

    protected boolean isHovering() {
        return this.isHovering;
    }

    protected void setHovering(boolean bl) {
        this.isHovering = bl;
    }

    protected boolean isDragging() {
        return this.isDragging;
    }

    protected void setDragging(boolean bl) {
        this.isDragging = bl;
    }

    protected PickedObjectList getHoverObjects() {
        return this.hoverObjects;
    }

    protected void setHoverObjects(PickedObjectList pickedObjectList) {
        this.hoverObjects = pickedObjectList;
    }

    protected PickedObjectList getObjectsAtButtonPress() {
        return this.objectsAtButtonPress;
    }

    protected void setObjectsAtButtonPress(PickedObjectList pickedObjectList) {
        this.objectsAtButtonPress = pickedObjectList;
    }

    protected ViewInputHandler getViewInputHandler() {
        return this.viewInputHandler;
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.wwd == null) {
            return;
        }
        if (keyEvent == null) {
            return;
        }
        this.callKeyTypedListeners(keyEvent);
        if (!keyEvent.isConsumed()) {
            this.viewInputHandler.keyTyped(keyEvent);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.wwd == null) {
            return;
        }
        if (keyEvent == null) {
            return;
        }
        this.callKeyPressedListeners(keyEvent);
        if (!keyEvent.isConsumed()) {
            this.viewInputHandler.keyPressed(keyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.wwd == null) {
            return;
        }
        if (keyEvent == null) {
            return;
        }
        this.callKeyReleasedListeners(keyEvent);
        if (!keyEvent.isConsumed()) {
            this.viewInputHandler.keyReleased(keyEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (this.wwd.getView() == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        PickedObjectList pickedObjectList = this.wwd.getObjectsAtCurrentPosition();
        this.callMouseClickedListeners(mouseEvent);
        if (pickedObjectList != null && pickedObjectList.getTopPickedObject() != null && !pickedObjectList.getTopPickedObject().isTerrain()) {
            if (1 == mouseEvent.getButton()) {
                if (mouseEvent.getClickCount() % 2 == 1) {
                    this.callSelectListeners(new SelectEvent((Object)this.wwd, "gov.nasa.worldwind.SelectEvent.LeftClick", mouseEvent, pickedObjectList));
                } else {
                    this.callSelectListeners(new SelectEvent((Object)this.wwd, "gov.nasa.worldwind.SelectEvent.LeftDoubleClick", mouseEvent, pickedObjectList));
                }
            } else if (3 == mouseEvent.getButton()) {
                this.callSelectListeners(new SelectEvent((Object)this.wwd, "gov.nasa.worldwind.SelectEvent.RightClick", mouseEvent, pickedObjectList));
            }
            this.wwd.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.wwd.getView());
        } else if (!mouseEvent.isConsumed()) {
            this.viewInputHandler.mouseClicked(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        this.mousePoint = mouseEvent.getPoint();
        this.cancelHover();
        this.cancelDrag();
        this.objectsAtButtonPress = this.wwd.getObjectsAtCurrentPosition();
        this.callMousePressedListeners(mouseEvent);
        if (this.objectsAtButtonPress != null && this.objectsAtButtonPress.getTopPickedObject() != null && !this.objectsAtButtonPress.getTopPickedObject().isTerrain()) {
            if (1 == mouseEvent.getButton()) {
                this.callSelectListeners(new SelectEvent((Object)this.wwd, "gov.nasa.worldwind.SelectEvent.LeftPress", mouseEvent, this.objectsAtButtonPress));
            } else if (3 == mouseEvent.getButton()) {
                this.callSelectListeners(new SelectEvent((Object)this.wwd, "gov.nasa.worldwind.SelectEvent.RightPress", mouseEvent, this.objectsAtButtonPress));
            }
            this.wwd.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.wwd.getView());
        } else if (!mouseEvent.isConsumed()) {
            this.viewInputHandler.mousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        this.mousePoint = mouseEvent.getPoint();
        this.callMouseReleasedListeners(mouseEvent);
        if (!mouseEvent.isConsumed()) {
            this.viewInputHandler.mouseReleased(mouseEvent);
        }
        this.doHover(true);
        this.cancelDrag();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        this.viewInputHandler.mouseEntered(mouseEvent);
        this.cancelHover();
        this.cancelDrag();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        this.viewInputHandler.mouseExited(mouseEvent);
        this.cancelHover();
        this.cancelDrag();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        Point point = this.mousePoint;
        this.mousePoint = mouseEvent.getPoint();
        this.callMouseDraggedListeners(mouseEvent);
        if (1024 == mouseEvent.getModifiersEx()) {
            PickedObjectList pickedObjectList = this.objectsAtButtonPress;
            if (this.isDragging || pickedObjectList != null && pickedObjectList.getTopPickedObject() != null && !pickedObjectList.getTopPickedObject().isTerrain()) {
                this.isDragging = true;
                this.callSelectListeners(new DragSelectEvent(this.wwd, "gov.nasa.worldwind.SelectEvent.Drag", mouseEvent, pickedObjectList, point));
            }
        }
        if (!this.isDragging && !mouseEvent.isConsumed()) {
            this.viewInputHandler.mouseDragged(mouseEvent);
        }
        if (this.wwd.getSceneController() != null) {
            this.wwd.getSceneController().setPickPoint(mouseEvent.getPoint());
            this.wwd.redraw();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        this.mousePoint = mouseEvent.getPoint();
        this.callMouseMovedListeners(mouseEvent);
        if (!mouseEvent.isConsumed()) {
            this.viewInputHandler.mouseMoved(mouseEvent);
        }
        if (this.wwd.getSceneController() != null) {
            this.wwd.getSceneController().setPickPoint(mouseEvent.getPoint());
            this.wwd.redraw();
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseWheelEvent == null) {
            return;
        }
        this.viewInputHandler.mouseWheelMoved(mouseWheelEvent);
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.wwd == null) {
            return;
        }
        if (focusEvent == null) {
            return;
        }
        this.viewInputHandler.focusGained(focusEvent);
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.wwd == null) {
            return;
        }
        if (focusEvent == null) {
            return;
        }
        this.viewInputHandler.focusLost(focusEvent);
    }

    protected boolean isPickListEmpty(PickedObjectList pickedObjectList) {
        return pickedObjectList == null || pickedObjectList.size() < 1;
    }

    protected void doHover(boolean bl) {
        PickedObjectList pickedObjectList = this.wwd.getObjectsAtCurrentPosition();
        if (!this.isPickListEmpty(this.hoverObjects) && !this.isPickListEmpty(pickedObjectList)) {
            Object object;
            Object object2;
            PickedObject pickedObject = this.hoverObjects.getTopPickedObject();
            PickedObject pickedObject2 = pickedObjectList.getTopPickedObject();
            Object object3 = pickedObject == null ? null : (pickedObject.getObject() != null ? pickedObject.getObject() : (object2 = pickedObject.getParentLayer() != null ? pickedObject.getParentLayer() : null));
            Object object4 = pickedObject2 == null ? null : (pickedObject2.getObject() != null ? pickedObject2.getObject() : (object = pickedObject2.getParentLayer() != null ? pickedObject2.getParentLayer() : null));
            if (object2 != null && object != null && object2.equals(object)) {
                return;
            }
        }
        this.cancelHover();
        if (!bl) {
            return;
        }
        if (pickedObjectList != null && pickedObjectList.getTopObject() != null && pickedObjectList.getTopPickedObject().isTerrain()) {
            return;
        }
        this.hoverObjects = pickedObjectList;
        this.hoverTimer.restart();
    }

    private void cancelHover() {
        if (this.isHovering) {
            this.callSelectListeners(new SelectEvent((Object)this.wwd, "gov.nasa.worldwind.SelectEvent.Hover", this.mousePoint, null));
        }
        this.isHovering = false;
        this.hoverObjects = null;
        this.hoverTimer.stop();
    }

    protected boolean pickMatches(PickedObjectList pickedObjectList) {
        if (this.isPickListEmpty(this.wwd.getObjectsAtCurrentPosition()) || this.isPickListEmpty(pickedObjectList)) {
            return false;
        }
        PickedObject pickedObject = this.wwd.getObjectsAtCurrentPosition().getTopPickedObject();
        if (null != pickedObject && pickedObject.isTerrain()) {
            return false;
        }
        PickedObject pickedObject2 = pickedObjectList.getTopPickedObject();
        if (pickedObject == null || pickedObject2 == null || pickedObject.getObject() == null || pickedObject2.getObject() == null) {
            return false;
        }
        return pickedObject.getObject().equals(pickedObject2.getObject());
    }

    protected void cancelDrag() {
        if (this.isDragging) {
            this.callSelectListeners(new DragSelectEvent(this.wwd, "gov.nasa.worldwind.SelectEvent.DragEnd", null, this.objectsAtButtonPress, this.mousePoint));
        }
        this.isDragging = false;
    }

    public void addSelectListener(SelectListener selectListener) {
        this.eventListeners.add(SelectListener.class, selectListener);
    }

    public void removeSelectListener(SelectListener selectListener) {
        this.eventListeners.remove(SelectListener.class, selectListener);
    }

    protected void callSelectListeners(SelectEvent selectEvent) {
        for (SelectListener selectListener : (SelectListener[])this.eventListeners.getListeners(SelectListener.class)) {
            selectListener.selected(selectEvent);
        }
    }

    public void addKeyListener(KeyListener keyListener) {
        this.eventListeners.add(KeyListener.class, keyListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.eventListeners.remove(KeyListener.class, keyListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.eventListeners.add(MouseListener.class, mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.eventListeners.remove(MouseListener.class, mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.eventListeners.add(MouseMotionListener.class, mouseMotionListener);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.eventListeners.remove(MouseMotionListener.class, mouseMotionListener);
    }

    public void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.eventListeners.add(MouseWheelListener.class, mouseWheelListener);
    }

    public void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.eventListeners.remove(MouseWheelListener.class, mouseWheelListener);
    }

    protected void callKeyPressedListeners(KeyEvent keyEvent) {
        for (KeyListener keyListener : (KeyListener[])this.eventListeners.getListeners(KeyListener.class)) {
            keyListener.keyPressed(keyEvent);
        }
    }

    protected void callKeyReleasedListeners(KeyEvent keyEvent) {
        for (KeyListener keyListener : (KeyListener[])this.eventListeners.getListeners(KeyListener.class)) {
            keyListener.keyReleased(keyEvent);
        }
    }

    protected void callKeyTypedListeners(KeyEvent keyEvent) {
        for (KeyListener keyListener : (KeyListener[])this.eventListeners.getListeners(KeyListener.class)) {
            keyListener.keyTyped(keyEvent);
        }
    }

    protected void callMousePressedListeners(MouseEvent mouseEvent) {
        for (MouseListener mouseListener : (MouseListener[])this.eventListeners.getListeners(MouseListener.class)) {
            mouseListener.mousePressed(mouseEvent);
        }
    }

    protected void callMouseReleasedListeners(MouseEvent mouseEvent) {
        for (MouseListener mouseListener : (MouseListener[])this.eventListeners.getListeners(MouseListener.class)) {
            mouseListener.mouseReleased(mouseEvent);
        }
    }

    protected void callMouseClickedListeners(MouseEvent mouseEvent) {
        for (MouseListener mouseListener : (MouseListener[])this.eventListeners.getListeners(MouseListener.class)) {
            mouseListener.mouseClicked(mouseEvent);
        }
    }

    protected void callMouseDraggedListeners(MouseEvent mouseEvent) {
        for (MouseMotionListener mouseMotionListener : (MouseMotionListener[])this.eventListeners.getListeners(MouseMotionListener.class)) {
            mouseMotionListener.mouseDragged(mouseEvent);
        }
    }

    protected void callMouseMovedListeners(MouseEvent mouseEvent) {
        for (MouseMotionListener mouseMotionListener : (MouseMotionListener[])this.eventListeners.getListeners(MouseMotionListener.class)) {
            mouseMotionListener.mouseMoved(mouseEvent);
        }
    }
}

