/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.awt;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.BasicOrbitView;
import gov.nasa.worldwind.view.BasicOrbitViewLimits;
import gov.nasa.worldwind.view.OrbitView;
import gov.nasa.worldwind.view.OrbitViewLimits;
import java.util.logging.Level;

class OrbitViewInputSupport {
    private boolean viewChanged;
    private boolean viewOutOfFocus;
    private boolean targetStopped;
    private Position centerTarget;
    private Angle headingTarget;
    private Angle pitchTarget;
    private double zoomTarget = -1.0;
    private double centerMinEpsilon;
    private double headingMinEpsilon;
    private double pitchMinEpsilon;
    private double zoomMinEpsilon;
    private double centerSmoothing;
    private double headingSmoothing;
    private double pitchSmoothing;
    private double zoomSmoothing;

    OrbitViewInputSupport() {
        this.loadConfigurationValues();
        this.setViewOutOfFocus(true);
    }

    private void loadConfigurationValues() {
        this.setCenterMinEpsilon(1.0E-9);
        this.setHeadingMinEpsilon(1.0E-4);
        this.setPitchMinEpsilon(1.0E-4);
        this.setZoomMinEpsilon(0.001);
        this.setCenterSmoothing(0.4);
        this.setHeadingSmoothing(0.7);
        this.setPitchSmoothing(0.7);
        this.setZoomSmoothing(0.9);
    }

    public void onViewStopped() {
        this.clearTargets();
    }

    public void onViewCenterStopped() {
        this.centerTarget = null;
        this.setViewOutOfFocus(false);
    }

    private boolean isViewChanged() {
        boolean bl = this.viewChanged;
        this.viewChanged = false;
        return bl;
    }

    private void flagViewChanged() {
        this.viewChanged = true;
    }

    private void refreshView(OrbitView orbitView) {
        if (this.isViewChanged()) {
            orbitView.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this);
        }
    }

    private boolean isViewOutOfFocus() {
        return this.viewOutOfFocus;
    }

    private void setViewOutOfFocus(boolean bl) {
        this.viewOutOfFocus = bl;
    }

    private void focusView(OrbitView orbitView) {
        if (orbitView == null) {
            return;
        }
        try {
            if (orbitView.canFocusOnViewportCenter()) {
                orbitView.focusOnViewportCenter();
                this.setViewOutOfFocus(false);
                this.flagViewChanged();
            }
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionWhileChangingView");
            Logging.logger().log(Level.SEVERE, string, exception);
            this.setViewOutOfFocus(true);
        }
    }

    private boolean isTargetStopped() {
        boolean bl = this.targetStopped;
        this.targetStopped = false;
        return bl;
    }

    private void flagTargetStopped() {
        this.targetStopped = true;
    }

    public Position getCenterTarget() {
        return this.centerTarget;
    }

    public void setCenterTarget(OrbitView orbitView, Position position) {
        OrbitViewLimits orbitViewLimits = orbitView != null ? orbitView.getOrbitViewLimits() : null;
        Position position2 = OrbitViewInputSupport.limitCenterPosition(position, orbitViewLimits);
        if (this.centerSmoothing == 0.0 && position2 != null && orbitView != null) {
            this.centerTarget = null;
            orbitView.setCenterPosition(position2);
            this.flagViewChanged();
            this.setViewOutOfFocus(true);
        } else {
            this.centerTarget = position2;
        }
        if (position2 != null) {
            this.headingTarget = null;
            this.pitchTarget = null;
            this.zoomTarget = -1.0;
        }
        this.refreshView(orbitView);
    }

    public Angle getHeadingTarget() {
        return this.headingTarget;
    }

    public void setHeadingTarget(OrbitView orbitView, Angle angle) {
        OrbitViewLimits orbitViewLimits = orbitView != null ? orbitView.getOrbitViewLimits() : null;
        Angle angle2 = OrbitViewInputSupport.limitHeading(angle, orbitViewLimits);
        if (this.isViewOutOfFocus()) {
            this.focusView(orbitView);
        }
        if (this.headingSmoothing == 0.0 && angle2 != null && orbitView != null) {
            this.headingTarget = null;
            orbitView.setHeading(angle2);
            this.flagViewChanged();
        } else {
            this.headingTarget = angle2;
        }
        if (angle2 != null) {
            this.centerTarget = null;
            this.zoomTarget = -1.0;
        }
        this.refreshView(orbitView);
    }

    public Angle getPitchTarget() {
        return this.pitchTarget;
    }

    public void setPitchTarget(OrbitView orbitView, Angle angle) {
        OrbitViewLimits orbitViewLimits = orbitView != null ? orbitView.getOrbitViewLimits() : null;
        Angle angle2 = OrbitViewInputSupport.limitPitch(angle, orbitViewLimits);
        if (this.isViewOutOfFocus()) {
            this.focusView(orbitView);
        }
        if (this.pitchSmoothing == 0.0 && angle2 != null && orbitView != null) {
            this.pitchTarget = null;
            orbitView.setPitch(angle2);
            this.flagViewChanged();
        } else {
            this.pitchTarget = angle2;
        }
        if (angle2 != null) {
            this.centerTarget = null;
            this.zoomTarget = -1.0;
        }
        this.refreshView(orbitView);
    }

    public double getZoomTarget() {
        return this.zoomTarget;
    }

    public void setZoomTarget(OrbitView orbitView, double d) {
        OrbitViewLimits orbitViewLimits = orbitView != null ? orbitView.getOrbitViewLimits() : null;
        double d2 = OrbitViewInputSupport.limitZoom(d, orbitViewLimits);
        if (this.isViewOutOfFocus() && orbitView != null) {
            double d3 = orbitView.getZoom();
            this.focusView(orbitView);
            double d4 = orbitView.getZoom();
            d2 = OrbitViewInputSupport.limitZoom(d2 + (d4 - d3), orbitViewLimits);
        }
        if (this.zoomSmoothing == 0.0 && d2 >= 0.0 && orbitView != null) {
            this.zoomTarget = -1.0;
            orbitView.setZoom(d2);
            this.flagViewChanged();
        } else {
            this.zoomTarget = d2;
        }
        if (d2 >= 0.0) {
            this.centerTarget = null;
            this.headingTarget = null;
            this.pitchTarget = null;
        }
        this.refreshView(orbitView);
    }

    public boolean hasTargets() {
        return this.centerTarget != null || this.headingTarget != null || this.pitchTarget != null || this.zoomTarget >= 0.0;
    }

    public void clearTargets() {
        this.centerTarget = null;
        this.headingTarget = null;
        this.pitchTarget = null;
        this.zoomTarget = -1.0;
        this.viewChanged = false;
        this.setViewOutOfFocus(false);
        this.targetStopped = false;
    }

    private static Position limitCenterPosition(Position position, OrbitViewLimits orbitViewLimits) {
        if (position == null) {
            return null;
        }
        position = BasicOrbitView.normalizedCenterPosition(position);
        position = BasicOrbitViewLimits.limitCenterPosition(position, orbitViewLimits);
        return position;
    }

    private static Angle limitHeading(Angle angle, OrbitViewLimits orbitViewLimits) {
        if (angle == null) {
            return null;
        }
        angle = BasicOrbitView.normalizedHeading(angle);
        angle = BasicOrbitViewLimits.limitHeading(angle, orbitViewLimits);
        return angle;
    }

    private static Angle limitPitch(Angle angle, OrbitViewLimits orbitViewLimits) {
        if (angle == null) {
            return null;
        }
        angle = BasicOrbitView.normalizedPitch(angle);
        angle = BasicOrbitViewLimits.limitPitch(angle, orbitViewLimits);
        return angle;
    }

    private static double limitZoom(double d, OrbitViewLimits orbitViewLimits) {
        d = OrbitViewInputSupport.normalizedZoom(d);
        d = BasicOrbitViewLimits.limitZoom(d, orbitViewLimits);
        return d;
    }

    private static double normalizedZoom(double d) {
        return d < 0.0 ? -1.0 : d;
    }

    public double getCenterMinEpsilon() {
        return this.centerMinEpsilon;
    }

    public void setCenterMinEpsilon(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.centerMinEpsilon = d;
    }

    public double getHeadingMinEpsilon() {
        return this.headingMinEpsilon;
    }

    public void setHeadingMinEpsilon(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.headingMinEpsilon = d;
    }

    public double getPitchMinEpsilon() {
        return this.pitchMinEpsilon;
    }

    public void setPitchMinEpsilon(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pitchMinEpsilon = d;
    }

    public double getZoomMinEpsilon() {
        return this.zoomMinEpsilon;
    }

    public void setZoomMinEpsilon(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.zoomMinEpsilon = d;
    }

    public double getCenterSmoothing() {
        return this.centerSmoothing;
    }

    public void setCenterSmoothing(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.centerSmoothing = d;
    }

    public double getHeadingSmoothing() {
        return this.headingSmoothing;
    }

    public void setHeadingSmoothing(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.headingSmoothing = d;
    }

    public double getPitchSmoothing() {
        return this.pitchSmoothing;
    }

    public void setPitchSmoothing(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pitchSmoothing = d;
    }

    public double getZoomSmoothing() {
        return this.zoomSmoothing;
    }

    public void setZoomSmoothing(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.zoomSmoothing = d;
    }

    public void moveViewTowardTargets(OrbitView orbitView) {
        if (orbitView == null) {
            return;
        }
        this.isViewChanged();
        this.isTargetStopped();
        if (this.centerTarget != null) {
            this.moveTowardCenterTarget(orbitView);
        }
        if (this.headingTarget != null) {
            this.moveTowardHeadingTarget(orbitView);
        }
        if (this.pitchTarget != null) {
            this.moveTowardPitchTarget(orbitView);
        }
        if (this.zoomTarget >= 0.0) {
            this.moveTowardZoomTarget(orbitView);
        }
        this.refreshView(orbitView);
        if (this.isTargetStopped() && !this.hasTargets()) {
            if (this.isViewOutOfFocus()) {
                this.focusView(orbitView);
            }
            this.clearTargets();
            orbitView.firePropertyChange("gov.nasa.worldwind.avkey.ViewQuiet", null, orbitView);
        }
    }

    private void moveTowardCenterTarget(OrbitView orbitView) {
        boolean bl;
        Position position = this.centerTarget;
        Position position2 = orbitView.getCenterPosition();
        double d = LatLon.greatCircleDistance((LatLon)position, (LatLon)position2).degrees;
        double d2 = Math.abs(position.getElevation() - position2.getElevation());
        boolean bl2 = bl = Math.max(d, d2) < this.centerMinEpsilon;
        if (!bl) {
            double d3 = 1.0 - this.centerSmoothing;
            position = new Position(Angle.mix(d3, position2.getLatitude(), this.centerTarget.getLatitude()), Angle.mix(d3, position2.getLongitude(), this.centerTarget.getLongitude()), (1.0 - d3) * position2.getElevation() + d3 * this.centerTarget.getElevation());
        }
        try {
            orbitView.hadCollisions();
            orbitView.setCenterPosition(position);
            if (orbitView.hadCollisions()) {
                this.centerTarget = new Position(this.centerTarget, orbitView.getCenterPosition().getElevation());
            }
            this.flagViewChanged();
            this.setViewOutOfFocus(true);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionWhileChangingView");
            Logging.logger().log(Level.SEVERE, string, exception);
            bl = true;
        }
        if (bl) {
            this.centerTarget = null;
            this.flagTargetStopped();
        }
    }

    private void moveTowardHeadingTarget(OrbitView orbitView) {
        boolean bl;
        Angle angle = this.headingTarget;
        Angle angle2 = orbitView.getHeading();
        double d = Math.abs(angle.subtract((Angle)angle2).degrees);
        boolean bl2 = bl = d < this.headingMinEpsilon;
        if (!bl) {
            double d2 = 1.0 - this.headingSmoothing;
            angle = Angle.mix(d2, angle2, this.headingTarget);
        }
        try {
            orbitView.setHeading(angle);
            this.flagViewChanged();
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionWhileChangingView");
            Logging.logger().log(Level.SEVERE, string, exception);
            bl = true;
        }
        if (bl) {
            this.headingTarget = null;
            this.flagTargetStopped();
        }
    }

    private void moveTowardPitchTarget(OrbitView orbitView) {
        boolean bl;
        Angle angle = this.pitchTarget;
        Angle angle2 = orbitView.getPitch();
        double d = Math.abs(angle.subtract((Angle)angle2).degrees);
        boolean bl2 = bl = d < this.pitchMinEpsilon;
        if (!bl) {
            double d2 = 1.0 - this.pitchSmoothing;
            angle = Angle.mix(d2, angle2, this.pitchTarget);
        }
        try {
            orbitView.hadCollisions();
            orbitView.setPitch(angle);
            if (orbitView.hadCollisions()) {
                bl = true;
            }
            this.flagViewChanged();
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionWhileChangingView");
            Logging.logger().log(Level.SEVERE, string, exception);
            bl = true;
        }
        if (bl) {
            this.pitchTarget = null;
            this.flagTargetStopped();
        }
    }

    private void moveTowardZoomTarget(OrbitView orbitView) {
        boolean bl;
        double d = this.zoomTarget;
        double d2 = orbitView.getZoom();
        double d3 = Math.abs(d - d2);
        boolean bl2 = bl = d3 < this.zoomMinEpsilon;
        if (!bl) {
            double d4 = 1.0 - this.zoomSmoothing;
            d = (1.0 - d4) * d2 + d4 * this.zoomTarget;
        }
        try {
            orbitView.setZoom(d);
            this.flagViewChanged();
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionWhileChangingView");
            Logging.logger().log(Level.SEVERE, string, exception);
            bl = true;
        }
        if (bl) {
            this.zoomTarget = -1.0;
            this.flagTargetStopped();
        }
    }
}

