/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.cache;

import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStoreDataSet {
    public static final String HOUR = "gov.nasa.worldwind.examples.util.cachecleaner.HOUR";
    public static final String DAY = "gov.nasa.worldwind.examples.util.cachecleaner.DAY";
    public static final String WEEK = "gov.nasa.worldwind.examples.util.cachecleaner.WEEK";
    public static final String MONTH = "gov.nasa.worldwind.examples.util.cachecleaner.MONTH";
    public static final String YEAR = "gov.nasa.worldwind.examples.util.cachecleaner.YEAR";
    private final File root;
    private final String cacheRootPath;
    private boolean fileGranularity = false;
    private ArrayList<File> exclusionList = new ArrayList();
    private ArrayList<LeafInfo> leafDirs = new ArrayList();
    private LeafInfo[] sortedLeafDirs;

    public FileStoreDataSet(File file, String string) {
        if (file == null) {
            String string2 = Logging.getMessage("nullValue.FileStorePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.root = file;
        this.cacheRootPath = string;
        this.update();
    }

    private void update() {
        this.leafDirs.clear();
        FileStoreDataSet.findLeaves(this.root, this.leafDirs);
        if (this.leafDirs.size() == 0) {
            return;
        }
        this.sortedLeafDirs = new LeafInfo[this.leafDirs.size()];
        this.sortedLeafDirs = this.leafDirs.toArray(this.sortedLeafDirs);
        Arrays.sort(this.sortedLeafDirs, new Comparator<LeafInfo>(){

            @Override
            public int compare(LeafInfo leafInfo, LeafInfo leafInfo2) {
                return leafInfo.lastUsed < leafInfo2.lastUsed ? -1 : (leafInfo.lastUsed == leafInfo2.lastUsed ? 0 : 1);
            }
        });
    }

    public boolean isFileGranularity() {
        return this.fileGranularity;
    }

    public void setFileGranularity(boolean bl) {
        this.fileGranularity = bl;
    }

    public String getPath() {
        return this.root.getPath();
    }

    public String getName() {
        String string = this.cacheRootPath == null ? this.getPath() : this.getPath().replace(this.cacheRootPath.subSequence(0, this.cacheRootPath.length()), "".subSequence(0, 0));
        return string.startsWith("/") ? string.substring(1) : string;
    }

    public List<File> getExclusions() {
        return Collections.unmodifiableList(this.exclusionList);
    }

    public void setExclusions(Iterable<? extends File> iterable) {
        this.exclusionList.clear();
        if (iterable != null) {
            for (File file : iterable) {
                this.exclusionList.add(file);
            }
        }
    }

    public long getSize() {
        long l = 0L;
        for (LeafInfo leafInfo : this.leafDirs) {
            l += leafInfo.size;
        }
        return l;
    }

    public long getOutOfScopeSize(String string, int n) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.TimeUnit");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        long l = FileStoreDataSet.computeTimeOffset(string, n);
        long l2 = 0L;
        for (LeafInfo leafInfo : this.sortedLeafDirs) {
            if (leafInfo.lastUsed > l) break;
            l2 += leafInfo.size;
        }
        return l2;
    }

    public long getLastModified() {
        return this.sortedLeafDirs[this.sortedLeafDirs.length - 1].lastUsed;
    }

    public void deleteOutOfScopeFiles(String string, int n, boolean bl) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.TimeUnit");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.deleteFiles(this.root, this.exclusionList, FileStoreDataSet.computeTimeOffset(string, n), bl);
        this.update();
    }

    private void deleteFiles(File file, List<File> list, long l, boolean bl) {
        File[] fileArray;
        if (!file.isDirectory()) {
            return;
        }
        boolean bl2 = file.lastModified() < l;
        for (File file2 : fileArray = file.listFiles()) {
            if (list.contains(file2)) continue;
            if (file2.isFile()) {
                if (this.isFileGranularity()) {
                    if (file2.lastModified() >= l) continue;
                    file2.delete();
                    if (!bl) continue;
                    System.out.println("Deleting FILE: " + file2.getPath());
                    continue;
                }
                if (!bl2) continue;
                file2.delete();
                if (!bl) continue;
                System.out.println("Deleting FILE: " + file2.getPath());
                continue;
            }
            if (!file2.isDirectory()) continue;
            this.deleteFiles(file2, list, l, bl);
            if (file2.list().length != 0) continue;
            file2.delete();
            if (!bl) continue;
            System.out.println("Deleting DIRECTORY: " + file2.getPath());
        }
    }

    public void delete(boolean bl) {
        this.deleteOutOfScopeFiles(HOUR, 0, bl);
        File[] fileArray = this.root.listFiles();
        if (fileArray.length == 0) {
            this.root.delete();
        }
    }

    private static long computeTimeOffset(String string, int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        if (n != 0) {
            if (string.equals(HOUR)) {
                gregorianCalendar.add(10, -n);
            } else if (string.equals(DAY)) {
                gregorianCalendar.add(6, -n);
            } else if (string.equals(WEEK)) {
                gregorianCalendar.add(3, -n);
            } else if (string.equals(MONTH)) {
                gregorianCalendar.add(2, -n);
            } else if (string.equals(YEAR)) {
                gregorianCalendar.add(1, -n);
            }
        }
        return gregorianCalendar.getTimeInMillis();
    }

    private static void findLeaves(File file, ArrayList<LeafInfo> arrayList) {
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (fileArray.length == 0) {
            LeafInfo leafInfo = new LeafInfo();
            leafInfo.lastUsed = file.lastModified();
            leafInfo.size = FileStoreDataSet.computeDirectorySize(file);
            arrayList.add(leafInfo);
        } else {
            for (File file2 : fileArray) {
                FileStoreDataSet.findLeaves(file2, arrayList);
            }
        }
    }

    private static long computeDirectorySize(File file) {
        File[] fileArray;
        long l = 0L;
        for (File file2 : fileArray = file.listFiles()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                l += (long)fileInputStream.available();
                fileInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return l;
    }

    public static List<FileStoreDataSet> getDataSets(File file) {
        File[] fileArray;
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileStorePathIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<FileStoreDataSet> arrayList = new ArrayList<FileStoreDataSet>();
        for (File file2 : fileArray = FileStoreDataSet.listDirs(file)) {
            if (file2.getName().equals("license")) continue;
            File[] fileArray2 = FileStoreDataSet.listDirs(file2);
            if (fileArray2.length == 0) {
                arrayList.add(new FileStoreDataSet(file2, file.getPath()));
                continue;
            }
            for (File file3 : fileArray2) {
                FileStoreDataSet fileStoreDataSet = new FileStoreDataSet(file3, file.getPath());
                arrayList.add(fileStoreDataSet);
            }
        }
        return arrayList;
    }

    private static File[] listDirs(File file) {
        return file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
    }

    private static class LeafInfo {
        long lastUsed;
        long size;

        private LeafInfo() {
        }
    }
}

