/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.DataRasterReader;
import gov.nasa.worldwind.data.DataSource;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;

public abstract class AbstractDataRasterReader
implements DataRasterReader {
    private final String description;
    private final String[] mimeTypes;
    private final String[] suffixes;

    public AbstractDataRasterReader(String string, String[] stringArray, String[] stringArray2) {
        this.description = string;
        this.mimeTypes = AbstractDataRasterReader.copyOf(stringArray);
        this.suffixes = AbstractDataRasterReader.copyOf(stringArray2);
    }

    public AbstractDataRasterReader(String[] stringArray, String[] stringArray2) {
        this.description = AbstractDataRasterReader.descriptionFromSuffixes(stringArray2);
        this.mimeTypes = AbstractDataRasterReader.copyOf(stringArray);
        this.suffixes = AbstractDataRasterReader.copyOf(stringArray2);
    }

    protected AbstractDataRasterReader(String string) {
        this.description = string;
        this.mimeTypes = new String[0];
        this.suffixes = new String[0];
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getMimeTypes() {
        String[] stringArray = new String[this.mimeTypes.length];
        System.arraycopy(this.mimeTypes, 0, stringArray, 0, this.mimeTypes.length);
        return stringArray;
    }

    public String[] getSuffixes() {
        String[] stringArray = new String[this.suffixes.length];
        System.arraycopy(this.suffixes, 0, stringArray, 0, this.suffixes.length);
        return stringArray;
    }

    public boolean canRead(DataSource dataSource) {
        if (dataSource == null || dataSource.getSource() == null) {
            return false;
        }
        if (!this.canReadSuffix(dataSource)) {
            return false;
        }
        return this.doCanRead(dataSource);
    }

    protected boolean canReadSuffix(DataSource dataSource) {
        String string = AbstractDataRasterReader.pathFor(dataSource);
        if (string == null) {
            return true;
        }
        String string2 = WWIO.getSuffix(string);
        boolean bl = false;
        for (String string3 : this.suffixes) {
            if (!string3.equalsIgnoreCase(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public DataRaster[] read(DataSource dataSource) throws IOException {
        if (!this.canRead(dataSource)) {
            String string = Logging.getMessage("DataRaster.CannotRead", dataSource);
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        return this.doRead(dataSource);
    }

    public void readMetadata(DataSource dataSource, AVList aVList) throws IOException {
        if (!this.canRead(dataSource)) {
            String string = Logging.getMessage("DataRaster.CannotRead", dataSource);
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.AVListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.doReadMetadata(dataSource, aVList);
        String string = this.validateMetadata(dataSource, aVList);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IOException(string);
        }
    }

    protected String validateMetadata(DataSource dataSource, AVList aVList) {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = aVList.getValue("gov.nasa.worldwind.avkey.Width");
        if (object == null || !(object instanceof Integer)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("WorldFile.NoSizeSpecified", dataSource));
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.Height")) == null || !(object instanceof Integer)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("WorldFile.NoSizeSpecified", dataSource));
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avKey.Sector")) == null || !(object instanceof Sector)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("WorldFile.NoSectorSpecified", dataSource));
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    protected abstract boolean doCanRead(DataSource var1);

    protected abstract DataRaster[] doRead(DataSource var1) throws IOException;

    protected abstract void doReadMetadata(DataSource var1, AVList var2) throws IOException;

    protected static String pathFor(DataSource dataSource) {
        if (dataSource.getSource() instanceof String) {
            return (String)dataSource.getSource();
        }
        if (dataSource.getSource() instanceof File) {
            return ((File)dataSource.getSource()).getPath();
        }
        if (dataSource.getSource() instanceof URI) {
            return dataSource.getSource().toString();
        }
        if (dataSource.getSource() instanceof URL) {
            return dataSource.getSource().toString();
        }
        return null;
    }

    private static String[] copyOf(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i].toLowerCase();
        }
        return stringArray2;
    }

    private static String descriptionFromSuffixes(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("*.").append(string.toLowerCase());
        }
        return stringBuilder.toString();
    }
}

