/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.data.DataSource;
import gov.nasa.worldwind.data.DataStoreProducer;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataStoreProducer
extends WWObjectImpl
implements DataStoreProducer {
    private AVList params;
    private List<DataSource> dataSourceList = new ArrayList<DataSource>();
    private List<Object> productionResults = new ArrayList<Object>();
    private boolean isStopped = false;

    @Override
    public AVList getStoreParameters() {
        return this.params;
    }

    @Override
    public void setStoreParameters(AVList aVList) {
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = this.validateProductionParameters(aVList);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.params = aVList;
    }

    @Override
    public Iterable<DataSource> getDataSources() {
        return Collections.unmodifiableList(this.dataSourceList);
    }

    @Override
    public boolean acceptsDataSource(DataSource dataSource) {
        if (dataSource == null) {
            return false;
        }
        String string = this.validateDataSource(dataSource);
        return string == null;
    }

    @Override
    public boolean containsDataSource(DataSource dataSource) {
        return this.dataSourceList.contains(dataSource);
    }

    @Override
    public void offerDataSource(DataSource dataSource) {
        if (dataSource == null) {
            String string = Logging.getMessage("nullValue.DataSourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = this.validateDataSource(dataSource);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.dataSourceList.add(dataSource);
    }

    @Override
    public void offerAllDataSources(Collection<? extends DataSource> collection) {
        if (collection == null) {
            String string = Logging.getMessage("nullValue.CollectionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (DataSource dataSource : collection) {
            this.offerDataSource(dataSource);
        }
    }

    @Override
    public void removeDataSource(DataSource dataSource) {
        if (dataSource == null) {
            String string = Logging.getMessage("nullValue.DataSourceIsNull");
            Logging.logger().warning(string);
            return;
        }
        if (this.dataSourceList.contains(dataSource)) {
            this.dataSourceList.remove(dataSource);
        }
    }

    @Override
    public void removeAllDataSources() {
        this.dataSourceList.clear();
    }

    @Override
    public void startProduction() throws Exception {
        if (this.isStopped()) {
            String string = Logging.getMessage("DataStoreProducer.Stopped");
            Logging.logger().warning(string);
            return;
        }
        String string = this.validateProductionParameters(this.params);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.doStartProduction(this.params);
    }

    @Override
    public synchronized void stopProduction() {
        this.isStopped = true;
    }

    protected synchronized boolean isStopped() {
        return this.isStopped;
    }

    @Override
    public Iterable<?> getProductionResults() {
        return Collections.unmodifiableList(this.productionResults);
    }

    @Override
    public void removeProductionState() {
    }

    protected List<DataSource> getDataSourceList() {
        return this.dataSourceList;
    }

    protected List<Object> getProductionResultsList() {
        return this.productionResults;
    }

    protected abstract void doStartProduction(AVList var1) throws Exception;

    protected abstract String validateProductionParameters(AVList var1);

    protected abstract String validateDataSource(DataSource var1);
}

