/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.AbstractDataRasterReader;
import gov.nasa.worldwind.data.ByteBufferRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.DataSource;
import gov.nasa.worldwind.formats.worldfile.WorldFile;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;

public class BILRasterReader
extends AbstractDataRasterReader {
    private static final String[] bilMimeTypes = new String[]{"image/bil"};
    private static final String[] bilSuffixes = new String[]{"bil"};
    private boolean mapLargeFiles = false;
    private long largeFileThreshold = 0x1000000L;

    public BILRasterReader() {
        super(bilMimeTypes, bilSuffixes);
    }

    public boolean isMapLargeFiles() {
        return this.mapLargeFiles;
    }

    public void setMapLargeFiles(boolean bl) {
        this.mapLargeFiles = bl;
    }

    public long getLargeFileThreshold() {
        return this.largeFileThreshold;
    }

    public void setLargeFileThreshold(long l) {
        if (l < 0L) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "largeFileThreshold < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.largeFileThreshold = l;
    }

    protected boolean doCanRead(DataSource dataSource) {
        if (!(dataSource.getSource() instanceof File)) {
            return false;
        }
        return this.validateMetadata(dataSource, dataSource) == null || this.canReadWorldFiles(dataSource);
    }

    protected DataRaster[] doRead(DataSource dataSource) throws IOException {
        ByteBuffer byteBuffer = this.readElevations(dataSource);
        AVList aVList = dataSource;
        if (this.validateMetadata(dataSource, aVList) != null) {
            aVList = new AVListImpl();
            this.readWorldFiles(dataSource, aVList);
        }
        int n = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Width");
        int n2 = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Height");
        Sector sector = (Sector)aVList.getValue("gov.nasa.worldwind.avKey.Sector");
        if (aVList.getValue("gov.nasa.worldwind.avkey.DataType") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.DataType", aVList.getValue("gov.nasa.worldwind.avkey.PixelType"));
        }
        ByteBufferRaster byteBufferRaster = new ByteBufferRaster(n, n2, sector, byteBuffer, aVList);
        Double d = (Double)aVList.getValue("gov.nasa.worldwind.avkey.MissingDataValue");
        if (d != null) {
            byteBufferRaster.setTransparentValue(d);
        }
        return new DataRaster[]{byteBufferRaster};
    }

    protected void doReadMetadata(DataSource dataSource, AVList aVList) throws IOException {
        if (this.validateMetadata(dataSource, aVList) != null) {
            this.readWorldFiles(dataSource, aVList);
        }
    }

    protected String validateMetadata(DataSource dataSource, AVList aVList) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        String string = super.validateMetadata(dataSource, aVList);
        if (string != null) {
            stringBuilder.append(string);
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.ByteOrder")) == null || !(object instanceof String)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("WorldFile.NoByteOrderSpecified", dataSource));
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.PixelFormat")) == null) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("WorldFile.NoPixelFormatSpecified", dataSource));
        } else if (!"gov.nasa.worldwind.avkey.Elevation".equals(object)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("WorldFile.InvalidPixelFormat", dataSource));
        }
        object = aVList.getValue("gov.nasa.worldwind.avkey.PixelType");
        if (object == null) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("WorldFile.NoPixelTypeSpecified", dataSource));
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    private boolean canReadWorldFiles(DataSource dataSource) {
        Object object = dataSource.getSource();
        if (!(object instanceof File)) {
            return false;
        }
        try {
            File[] fileArray = WorldFile.getWorldFiles((File)object);
            if (fileArray == null || fileArray.length == 0) {
                return false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private ByteBuffer readElevations(DataSource dataSource) throws IOException {
        if (!(dataSource.getSource() instanceof File)) {
            String string = Logging.getMessage("DataRaster.CannotRead", dataSource.getSource());
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        File file = (File)dataSource.getSource();
        if (!this.isMapLargeFiles() || this.getLargeFileThreshold() > file.length()) {
            return WWIO.readFileToBuffer(file);
        }
        return WWIO.mapFile(file);
    }

    private void readWorldFiles(DataSource dataSource, AVList aVList) throws IOException {
        Object object = dataSource.getSource();
        if (!(object instanceof File)) {
            String string = Logging.getMessage("DataRaster.CannotRead", object);
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        File[] fileArray = WorldFile.getWorldFiles((File)object);
        WorldFile.decodeWorldFiles(fileArray, aVList);
        Object object2 = aVList.getValue("gov.nasa.worldwind.worldFile.ImageSize");
        if (object2 != null && object2 instanceof int[]) {
            int[] nArray = (int[])object2;
            aVList.setValue("gov.nasa.worldwind.avkey.Width", nArray[0]);
            aVList.setValue("gov.nasa.worldwind.avkey.Height", nArray[1]);
        }
    }
}

