/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.data.DataIODescriptor;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicDataIODescriptor
implements DataIODescriptor {
    private final String description;
    private final String[] mimeTypes;
    private final String[] suffixes;

    public BasicDataIODescriptor(String string, String[] stringArray, String[] stringArray2) {
        this.description = string;
        this.mimeTypes = stringArray != null ? BasicDataIODescriptor.copyOf(stringArray) : new String[]{};
        this.suffixes = stringArray2 != null ? BasicDataIODescriptor.copyOf(stringArray2) : new String[]{};
    }

    public BasicDataIODescriptor(String[] stringArray, String[] stringArray2) {
        this(null, stringArray, stringArray2);
    }

    protected BasicDataIODescriptor(String string) {
        this(string, null, null);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String[] getMimeTypes() {
        String[] stringArray = new String[this.mimeTypes.length];
        System.arraycopy(this.mimeTypes, 0, stringArray, 0, this.mimeTypes.length);
        return stringArray;
    }

    @Override
    public String[] getSuffixes() {
        String[] stringArray = new String[this.suffixes.length];
        System.arraycopy(this.suffixes, 0, stringArray, 0, this.suffixes.length);
        return stringArray;
    }

    @Override
    public boolean matchesMimeType(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.MimeTypeIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        for (String string3 : this.mimeTypes) {
            if (!string.equalsIgnoreCase(string3)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchesFormatSuffix(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FormatS uffixIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        for (String string3 : this.suffixes) {
            if (!string.equalsIgnoreCase(string3)) continue;
            return true;
        }
        return false;
    }

    public static String getSuffixFor(Object object) {
        String string = BasicDataIODescriptor.pathFor(object);
        if (string == null) {
            return null;
        }
        return WWIO.getSuffix(string);
    }

    public static String createCombinedDescription(Iterable<? extends DataIODescriptor> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.DataIODescriptorsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        for (DataIODescriptor object : iterable) {
            String[] stringArray = object.getSuffixes();
            if (stringArray != null && stringArray.length > 0) {
                treeSet.addAll(Arrays.asList(stringArray));
                continue;
            }
            if (object.getDescription() == null) continue;
            treeSet2.add(object.getDescription());
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : treeSet) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("*.").append(string);
        }
        for (String string : treeSet2) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    protected static String pathFor(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof File) {
            return ((File)object).getPath();
        }
        if (object instanceof URI) {
            return object.toString();
        }
        if (object instanceof URL) {
            return object.toString();
        }
        return null;
    }

    protected static String[] copyOf(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i].toLowerCase();
        }
        return stringArray2;
    }
}

