/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.data.BufferedDataRaster;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.Logging;

public class BufferWrapperRaster
extends BufferedDataRaster
implements Cacheable,
Disposable {
    private BufferWrapper buffer;

    public BufferWrapperRaster(int n, int n2, Sector sector, BufferWrapper bufferWrapper) {
        super(n, n2, sector);
        if (bufferWrapper == null) {
            String string = Logging.getMessage("nullValue.BufferNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n3 = n * n2;
        if (bufferWrapper.length() < n3) {
            String string = Logging.getMessage("generic.BufferSize", "buffer.length() < " + n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.buffer = bufferWrapper;
    }

    public BufferWrapper getBuffer() {
        return this.buffer;
    }

    public long getSizeInBytes() {
        return this.buffer.getSizeInBytes();
    }

    public void dispose() {
    }

    protected void get(int n, int n2, int n3, double[] dArray, int n4) {
        int n5 = this.indexFor(n, n2);
        this.getBuffer().getDouble(n5, dArray, n4, n3);
    }

    protected void put(int n, int n2, double[] dArray, int n3, int n4) {
        int n5 = this.indexFor(n, n2);
        this.getBuffer().putDouble(n5, dArray, n3, n4);
    }

    protected final int indexFor(int n, int n2) {
        return n + n2 * this.getWidth();
    }
}

