/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Arrays;

public abstract class BufferedDataRaster
implements DataRaster {
    private int width;
    private int height;
    private Sector sector;
    private double transparentValue = Double.MAX_VALUE;

    public BufferedDataRaster(int n, int n2, Sector sector) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "width < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "height < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.width = n;
        this.height = n2;
        this.sector = sector;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Sector getSector() {
        return this.sector;
    }

    public double getTransparentValue() {
        return this.transparentValue;
    }

    public void setTransparentValue(double d) {
        this.transparentValue = d;
    }

    public void drawOnCanvas(DataRaster dataRaster) {
        if (dataRaster == null) {
            String string = Logging.getMessage("nullValue.DestinationIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!(dataRaster instanceof BufferedDataRaster)) {
            String string = Logging.getMessage("DataRaster.IncompatibleRaster", dataRaster);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.doDrawOnCanvas((BufferedDataRaster)dataRaster);
    }

    public void fill(double d) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        double[] dArray = new double[n];
        Arrays.fill(dArray, d);
        for (int i = 0; i < n2; ++i) {
            this.put(0, i, dArray, 0, n);
        }
    }

    protected abstract void get(int var1, int var2, int var3, double[] var4, int var5);

    protected abstract void put(int var1, int var2, double[] var3, int var4, int var5);

    protected void doDrawOnCanvas(BufferedDataRaster bufferedDataRaster) {
        if (!this.getSector().intersects(bufferedDataRaster.getSector())) {
            return;
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = bufferedDataRaster.getWidth();
        int n4 = bufferedDataRaster.getHeight();
        double d = this.getTransparentValue();
        AffineTransform affineTransform = this.computeDataTransform(n3, n4, bufferedDataRaster.getSector(), n, n2, this.getSector());
        InterpolantLookupTable interpolantLookupTable = this.createLookupTable(n3, n4, 0.0, n - 1, 0.0, n2 - 1, affineTransform);
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        interpolantLookupTable.computeRangeX(dArray);
        int n5 = (int)Math.floor(dArray[0]);
        int n6 = (int)Math.ceil(dArray[1]);
        int n7 = n6 - n5 + 1;
        double[] dArray3 = new double[2 * n7];
        double[] dArray4 = new double[n3];
        for (int i = 0; i < n4; ++i) {
            if (!interpolantLookupTable.getInterpolantY(i, dArray2)) continue;
            int n8 = (int)dArray2[0];
            int n9 = (int)dArray2[1];
            double d2 = dArray2[2];
            this.get(n5, n8, n7, dArray3, 0);
            this.get(n5, n9, n7, dArray3, n7);
            bufferedDataRaster.get(0, i, n3, dArray4, 0);
            for (int j = 0; j < n3; ++j) {
                if (!interpolantLookupTable.getInterpolantX(j, dArray)) continue;
                int n10 = (int)dArray[0] - n5;
                int n11 = (int)dArray[1] - n5;
                double d3 = dArray[2];
                BufferedDataRaster.sample(dArray3, n10, n11, d3, 0, 1, d2, n7, d, dArray4, j);
            }
            bufferedDataRaster.put(0, i, dArray4, 0, n3);
        }
    }

    protected AffineTransform computeDataTransform(int n, int n2, Sector sector, int n3, int n4, Sector sector2) {
        double d = (double)(n4 - 1) * -(sector.getMaxLatitude().degrees - sector2.getMaxLatitude().degrees) / sector2.getDeltaLatDegrees();
        double d2 = (double)(n3 - 1) * (sector.getMinLongitude().degrees - sector2.getMinLongitude().degrees) / sector2.getDeltaLonDegrees();
        double d3 = (double)(n4 - 1) / (double)(n2 - 1) * (sector.getDeltaLatDegrees() / sector2.getDeltaLatDegrees());
        double d4 = (double)(n3 - 1) / (double)(n - 1) * (sector.getDeltaLonDegrees() / sector2.getDeltaLonDegrees());
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(d2, d);
        affineTransform.scale(d4, d3);
        return affineTransform;
    }

    private static void sample(double[] dArray, int n, int n2, double d, int n3, int n4, double d2, int n5, double d3, double[] dArray2, int n6) {
        double d4 = dArray[n + n3 * n5];
        double d5 = dArray[n + n4 * n5];
        double d6 = dArray[n2 + n4 * n5];
        double d7 = dArray[n2 + n3 * n5];
        if (d4 != d3 && d7 != d3 && d6 != d3 && d5 != d3) {
            dArray2[n6] = (1.0 - d) * (1.0 - d2) * d4 + (1.0 - d) * d2 * d5 + d * d2 * d6 + d * (1.0 - d2) * d7;
        }
    }

    private InterpolantLookupTable createLookupTable(int n, int n2, double d, double d2, double d3, double d4, AffineTransform affineTransform) {
        int n3;
        int n4;
        InterpolantLookupTable interpolantLookupTable = new InterpolantLookupTable(n, n2);
        double d5 = -1.0E-6;
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        for (n4 = 0; n4 < n; ++n4) {
            ((Point2D)double_2).setLocation(n4, 0.0);
            affineTransform.transform(double_2, double_);
            double d6 = ((Point2D)double_).getX();
            if (!(d6 - d > d5) || !(d2 - d6 > d5)) continue;
            d6 = d6 < d ? d : (d6 > d2 ? d2 : d6);
            n3 = 3 * n4;
            ((InterpolantLookupTable)interpolantLookupTable).xParams[n3] = Math.floor(d6);
            ((InterpolantLookupTable)interpolantLookupTable).xParams[n3 + 1] = Math.ceil(d6);
            ((InterpolantLookupTable)interpolantLookupTable).xParams[n3 + 2] = d6 - interpolantLookupTable.xParams[n3];
        }
        for (n4 = 0; n4 < n2; ++n4) {
            ((Point2D)double_2).setLocation(0.0, n4);
            affineTransform.transform(double_2, double_);
            double d7 = ((Point2D)double_).getY();
            if (!(d7 - d3 > d5) || !(d4 - d7 > d5)) continue;
            d7 = d7 < d3 ? d3 : (d7 > d4 ? d4 : d7);
            n3 = 3 * n4;
            ((InterpolantLookupTable)interpolantLookupTable).yParams[n3] = Math.floor(d7);
            ((InterpolantLookupTable)interpolantLookupTable).yParams[n3 + 1] = Math.ceil(d7);
            ((InterpolantLookupTable)interpolantLookupTable).yParams[n3 + 2] = d7 - interpolantLookupTable.yParams[n3];
        }
        return interpolantLookupTable;
    }

    private static class InterpolantLookupTable {
        private int width;
        private int height;
        private double[] xParams;
        private double[] yParams;

        public InterpolantLookupTable(int n, int n2) {
            this.width = n;
            this.height = n2;
            this.xParams = new double[3 * n];
            this.yParams = new double[3 * n2];
            Arrays.fill(this.xParams, -1.0);
            Arrays.fill(this.yParams, -1.0);
        }

        public final boolean getInterpolantX(int n, double[] dArray) {
            dArray[0] = this.xParams[3 * n];
            dArray[1] = this.xParams[3 * n + 1];
            dArray[2] = this.xParams[3 * n + 2];
            return dArray[0] != -1.0;
        }

        public final boolean getInterpolantY(int n, double[] dArray) {
            dArray[0] = this.yParams[3 * n];
            dArray[1] = this.yParams[3 * n + 1];
            dArray[2] = this.yParams[3 * n + 2];
            return dArray[0] != -1.0;
        }

        public final void computeRangeX(double[] dArray) {
            InterpolantLookupTable.computeInterpolantRange(this.xParams, this.width, dArray);
        }

        public final void computeRangeY(double[] dArray) {
            InterpolantLookupTable.computeInterpolantRange(this.yParams, this.height, dArray);
        }

        private static void computeInterpolantRange(double[] dArray, int n, double[] dArray2) {
            double d = Double.MAX_VALUE;
            double d2 = -4.9E-324;
            for (int i = 0; i < n; ++i) {
                int n2 = 3 * i;
                if (dArray[n2] == -1.0) continue;
                if (dArray[n2] < d) {
                    d = dArray[n2];
                }
                if (!(dArray[n2 + 1] > d2)) continue;
                d2 = dArray[n2 + 1];
            }
            dArray2[0] = d;
            dArray2[1] = d2;
        }
    }
}

