/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.WritableRaster;

public class BufferedImageRaster
implements DataRaster,
Cacheable,
Disposable {
    private static final int MAX_IMAGE_SIZE_TO_CONVERT = 4096;
    private Sector sector;
    private BufferedImage bufferedImage;
    private Graphics2D g2d;

    public BufferedImageRaster(Sector sector, BufferedImage bufferedImage) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sector = sector;
        this.bufferedImage = bufferedImage;
    }

    public BufferedImageRaster(int n, int n2, int n3, Sector sector) {
        if (n < 1) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "width < 1");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 1) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "height < 1");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sector = sector;
        this.bufferedImage = BufferedImageRaster.createCompatibleImage(n, n2, n3);
    }

    public static BufferedImage toCompatibleImage(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!BufferedImageRaster.isCompatibleImage(bufferedImage) && bufferedImage.getWidth() <= 4096 && bufferedImage.getHeight() <= 4096) {
            BufferedImage bufferedImage2 = BufferedImageRaster.createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getTransparency());
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.dispose();
            return bufferedImage2;
        }
        return bufferedImage;
    }

    public static BufferedImage createCompatibleImage(int n, int n2, int n3) {
        if (n < 1) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "width < 1");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 1) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "height < 1");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GraphicsConfiguration graphicsConfiguration = BufferedImageRaster.getDefaultGraphicsConfiguration();
        return graphicsConfiguration.createCompatibleImage(n, n2, n3);
    }

    protected static boolean isCompatibleImage(BufferedImage bufferedImage) {
        GraphicsConfiguration graphicsConfiguration = BufferedImageRaster.getDefaultGraphicsConfiguration();
        ColorModel colorModel = graphicsConfiguration.getColorModel(bufferedImage.getTransparency());
        return bufferedImage.getColorModel().equals(colorModel);
    }

    protected static GraphicsConfiguration getDefaultGraphicsConfiguration() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        return graphicsDevice.getDefaultConfiguration();
    }

    public int getWidth() {
        return this.bufferedImage.getWidth();
    }

    public int getHeight() {
        return this.bufferedImage.getHeight();
    }

    public Sector getSector() {
        return this.sector;
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public Graphics2D getGraphics() {
        if (this.g2d == null) {
            this.g2d = this.bufferedImage.createGraphics();
            this.g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        }
        return this.g2d;
    }

    public void drawOnCanvas(DataRaster dataRaster) {
        if (dataRaster == null) {
            String string = Logging.getMessage("nullValue.DestinationIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!(dataRaster instanceof BufferedImageRaster)) {
            String string = Logging.getMessage("DataRaster.IncompatibleRaster", dataRaster);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.doDrawOnCanvas((BufferedImageRaster)dataRaster);
    }

    public long getSizeInBytes() {
        DataBuffer dataBuffer;
        long l = 0L;
        WritableRaster writableRaster = this.bufferedImage.getRaster();
        if (writableRaster != null && (dataBuffer = writableRaster.getDataBuffer()) != null) {
            l = BufferedImageRaster.sizeOfDataBuffer(dataBuffer);
        }
        return l;
    }

    public void dispose() {
        if (this.g2d != null) {
            this.g2d.dispose();
            this.g2d = null;
        }
    }

    protected void doDrawOnCanvas(BufferedImageRaster bufferedImageRaster) {
        if (!this.getSector().intersects(bufferedImageRaster.getSector())) {
            return;
        }
        Graphics2D graphics2D = bufferedImageRaster.getGraphics();
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = this.computeImageTransform(this.getWidth(), this.getHeight(), this.getSector(), bufferedImageRaster.getWidth(), bufferedImageRaster.getHeight(), bufferedImageRaster.getSector());
        graphics2D.setTransform(affineTransform2);
        graphics2D.drawImage((Image)this.getBufferedImage(), 0, 0, null);
        graphics2D.setTransform(affineTransform);
    }

    protected AffineTransform computeImageTransform(int n, int n2, Sector sector, int n3, int n4, Sector sector2) {
        double d = (double)n4 * -(sector.getMaxLatitude().degrees - sector2.getMaxLatitude().degrees) / sector2.getDeltaLatDegrees();
        double d2 = (double)n3 * (sector.getMinLongitude().degrees - sector2.getMinLongitude().degrees) / sector2.getDeltaLonDegrees();
        double d3 = (double)n4 / (double)n2 * (sector.getDeltaLatDegrees() / sector2.getDeltaLatDegrees());
        double d4 = (double)n3 / (double)n * (sector.getDeltaLonDegrees() / sector2.getDeltaLonDegrees());
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(d2, d);
        affineTransform.scale(d4, d3);
        return affineTransform;
    }

    private static long sizeOfDataBuffer(DataBuffer dataBuffer) {
        return BufferedImageRaster.sizeOfElement(dataBuffer.getDataType()) * (long)dataBuffer.getSize();
    }

    private static long sizeOfElement(int n) {
        switch (n) {
            case 0: {
                return 1L;
            }
            case 5: {
                return 8L;
            }
            case 4: {
                return 4L;
            }
            case 3: {
                return 4L;
            }
            case 1: 
            case 2: {
                return 2L;
            }
        }
        return 0L;
    }
}

