/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.data.BasicDataDescriptorReader;
import gov.nasa.worldwind.data.DataDescriptorReader;
import gov.nasa.worldwind.data.WWDotNetLayerSetReader;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.ServiceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataIORegistry {
    private static DataIORegistry instance;
    private ServiceRegistry registry = new ServiceRegistry();

    public DataIORegistry() {
        this.registry.setName(Logging.getMessage("ServiceRegistry.DataIO.Name"));
        this.registry.addService(DataDescriptorReader.class);
    }

    public static DataIORegistry getInstance() {
        if (instance == null) {
            instance = new DataIORegistry();
        }
        return instance;
    }

    public Iterable<Class<? extends DataDescriptorReader>> getDataDescriptorReaders() {
        return this.registry.getServiceProviders(DataDescriptorReader.class);
    }

    public Iterable<? extends DataDescriptorReader> createDataDescriptorReaders() {
        return this.registry.createServiceProviders(DataDescriptorReader.class);
    }

    public boolean hasDataDescriptorReader(Class<? extends DataDescriptorReader> clazz) {
        if (clazz == null) {
            String string = Logging.getMessage("nullValue.ReaderIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.registry.hasServiceProvider(clazz, DataDescriptorReader.class);
    }

    public void registerDataDescriptorReader(Class<? extends DataDescriptorReader> clazz) {
        if (clazz == null) {
            String string = Logging.getMessage("nullValue.ReaderIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.registry.registerServiceProvider(clazz, DataDescriptorReader.class);
    }

    static {
        DataIORegistry.getInstance().registerDataDescriptorReader(BasicDataDescriptorReader.class);
        DataIORegistry.getInstance().registerDataDescriptorReader(WWDotNetLayerSetReader.class);
    }
}

