/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.AbstractDataRasterReader;
import gov.nasa.worldwind.data.BufferedImageRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.DataSource;
import gov.nasa.worldwind.formats.tiff.GeotiffImageReaderSpi;
import gov.nasa.worldwind.formats.worldfile.WorldFile;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class ImageIORasterReader
extends AbstractDataRasterReader {
    public ImageIORasterReader() {
        super(ImageIO.getReaderMIMETypes(), ImageIORasterReader.getImageIOReaderSuffixes());
    }

    protected boolean doCanRead(DataSource dataSource) {
        Object object = dataSource.getValue("gov.nasa.worldwind.avKey.Sector");
        return object != null && object instanceof Sector || this.canReadWorldFiles(dataSource);
    }

    protected DataRaster[] doRead(DataSource dataSource) throws IOException {
        ImageInputStream imageInputStream = ImageIORasterReader.createInputStream(dataSource);
        BufferedImage bufferedImage = ImageIO.read(imageInputStream);
        bufferedImage = BufferedImageRaster.toCompatibleImage(bufferedImage);
        Object object = dataSource.getValue("gov.nasa.worldwind.avKey.Sector");
        if (object == null || !(object instanceof Sector)) {
            AVListImpl aVListImpl = new AVListImpl();
            aVListImpl.setValue("gov.nasa.worldwind.avkey.Image", bufferedImage);
            this.readWorldFiles(dataSource, aVListImpl);
            object = aVListImpl.getValue("gov.nasa.worldwind.avKey.Sector");
        }
        return new DataRaster[]{new BufferedImageRaster((Sector)object, bufferedImage)};
    }

    protected void doReadMetadata(DataSource dataSource, AVList aVList) throws IOException {
        Object object;
        Object object2 = aVList.getValue("gov.nasa.worldwind.avkey.Width");
        Object object3 = aVList.getValue("gov.nasa.worldwind.avkey.Height");
        if (object2 == null || object3 == null || !(object2 instanceof Integer) || !(object3 instanceof Integer)) {
            this.readImageDimension(dataSource, aVList);
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avKey.Sector")) == null || !(object instanceof Sector)) {
            this.readWorldFiles(dataSource, aVList);
        }
    }

    private boolean canReadWorldFiles(DataSource dataSource) {
        if (!(dataSource.getSource() instanceof File)) {
            return false;
        }
        try {
            File[] fileArray = WorldFile.getWorldFiles((File)dataSource.getSource());
            if (fileArray == null || fileArray.length == 0) {
                return false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readImageDimension(DataSource dataSource, AVList aVList) throws IOException {
        ImageInputStream imageInputStream = ImageIORasterReader.createInputStream(dataSource);
        ImageReader imageReader = ImageIORasterReader.readerFor(imageInputStream);
        try {
            if (imageReader == null) {
                String string = Logging.getMessage("generic.UnrecognizedImageSourceType", dataSource);
                Logging.logger().severe(string);
                throw new IOException(string);
            }
            imageReader.setInput(imageInputStream, true, true);
            int n = imageReader.getWidth(0);
            int n2 = imageReader.getHeight(0);
            aVList.setValue("gov.nasa.worldwind.avkey.Width", n);
            aVList.setValue("gov.nasa.worldwind.avkey.Height", n2);
        }
        finally {
            if (imageReader != null) {
                imageReader.dispose();
            }
            imageInputStream.close();
        }
    }

    private void readWorldFiles(DataSource dataSource, AVList aVList) throws IOException {
        Object object;
        if (!(dataSource.getSource() instanceof File)) {
            String string = Logging.getMessage("DataRaster.CannotRead", dataSource);
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        Object object2 = aVList.getValue("gov.nasa.worldwind.avkey.Image");
        if (!(object2 != null && object2 instanceof BufferedImage || (object2 = aVList.getValue("gov.nasa.worldwind.worldFile.ImageSize")) != null && object2 instanceof int[])) {
            object = aVList.getValue("gov.nasa.worldwind.avkey.Width");
            Object object3 = aVList.getValue("gov.nasa.worldwind.avkey.Height");
            if (object != null && object3 != null && object instanceof Integer && object3 instanceof Integer) {
                int[] nArray = new int[]{(Integer)object, (Integer)object3};
                aVList.setValue("gov.nasa.worldwind.worldFile.ImageSize", nArray);
            }
        }
        object = WorldFile.getWorldFiles((File)dataSource.getSource());
        WorldFile.decodeWorldFiles(object, aVList);
    }

    private static ImageInputStream createInputStream(DataSource dataSource) throws IOException {
        Object object = dataSource.getSource();
        if (object instanceof URL) {
            object = ((URL)object).openStream();
        } else if (object instanceof CharSequence) {
            object = ImageIORasterReader.openInputStream(object.toString());
        }
        return ImageIO.createImageInputStream(object);
    }

    private static InputStream openInputStream(String string) throws IOException {
        Object object = WWIO.getFileOrResourceAsStream(string, null);
        if (object == null) {
            return null;
        }
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        if (object instanceof Exception) {
            String string2 = Logging.getMessage("generic.ExceptionAttemptingToReadImageFile", string);
            Logging.logger().log(Level.SEVERE, string2, object);
            throw new IOException(string2);
        }
        return (InputStream)object;
    }

    private static ImageReader readerFor(ImageInputStream imageInputStream) {
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        if (!iterator.hasNext()) {
            return null;
        }
        return iterator.next();
    }

    private static String[] getImageIOReaderSuffixes() {
        String[] stringArray;
        Iterator<ImageReaderSpi> iterator;
        try {
            iterator = IIORegistry.getDefaultInstance().getServiceProviders(ImageReaderSpi.class, true);
        }
        catch (Exception exception) {
            return new String[0];
        }
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            stringArray = iterator.next();
            String[] stringArray2 = stringArray.getFileSuffixes();
            hashSet.addAll(Arrays.asList(stringArray2));
        }
        stringArray = new String[hashSet.size()];
        hashSet.toArray(stringArray);
        return stringArray;
    }

    static {
        IIORegistry.getDefaultInstance().registerServiceProvider(GeotiffImageReaderSpi.inst());
    }
}

