/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.cache.BasicMemoryCache;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.data.AbstractDataStoreProducer;
import gov.nasa.worldwind.data.BasicDataDescriptor;
import gov.nasa.worldwind.data.BasicDataDescriptorWriter;
import gov.nasa.worldwind.data.DataDescriptor;
import gov.nasa.worldwind.data.DataDescriptorWriter;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.DataRasterReader;
import gov.nasa.worldwind.data.DataRasterWriter;
import gov.nasa.worldwind.data.DataSource;
import gov.nasa.worldwind.data.ReadableDataRaster;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWMath;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TiledRasterProducer
extends AbstractDataStoreProducer {
    private static final long DEFAULT_TILED_RASTER_PRODUCER_CACHE_SIZE = 300000000L;
    private static final int DEFAULT_TILED_RASTER_PRODUCER_LARGE_DATASET_THRESHOLD = 3000;
    private static final int DEFAULT_WRITE_THREAD_POOL_SIZE = 2;
    private static final int DEFAULT_TILE_WIDTH_AND_HEIGHT = 512;
    private static final int DEFAULT_SINGLE_LEVEL_TILE_WIDTH_AND_HEIGHT = 512;
    private static final double DEFAULT_LEVEL_ZERO_TILE_DELTA = 36.0;
    private List<DataRaster> dataRasterList = new ArrayList<DataRaster>();
    private MemoryCache rasterCache;
    private final ExecutorService tileWriteService;
    private final Semaphore tileWriteSemaphore;
    private final Object fileLock = new Object();
    private int tile;
    private int tileCount;

    public TiledRasterProducer(MemoryCache memoryCache, int n) {
        if (memoryCache == null) {
            String string = Logging.getMessage("nullValue.CacheIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 1) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "writeThreadPoolSize < 1");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.rasterCache = memoryCache;
        this.tileWriteService = this.createDefaultTileWriteService(n);
        this.tileWriteSemaphore = new Semaphore(n, true);
    }

    public TiledRasterProducer() {
        this(TiledRasterProducer.createDefaultCache(), 2);
    }

    @Override
    public String getDataSourceDescription() {
        DataRasterReader[] dataRasterReaderArray = this.getDataRasterReaders();
        if (dataRasterReaderArray == null || dataRasterReaderArray.length < 1) {
            return "";
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        for (DataRasterReader dataRasterReader : dataRasterReaderArray) {
            String string = dataRasterReader.getDescription();
            String[] stringArray = dataRasterReader.getSuffixes();
            if (stringArray != null && stringArray.length > 0) {
                treeSet.addAll(Arrays.asList(stringArray));
                continue;
            }
            treeSet2.add(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : treeSet) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("*.").append(string);
        }
        for (String string : treeSet2) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public void removeProductionState() {
        File file = this.installLocationFor(this.getStoreParameters());
        if (file == null || !file.exists()) {
            String string = "Install location is null or does not exist";
            Logging.logger().warning(string);
            return;
        }
        try {
            WWIO.deleteDirectory(file);
        }
        catch (Exception exception) {
            String string = "Exception while removing install location";
            Logging.logger().log(Level.SEVERE, string, exception);
        }
    }

    protected abstract DataRaster createDataRaster(int var1, int var2, Sector var3, AVList var4);

    protected abstract DataRasterReader[] getDataRasterReaders();

    protected abstract DataRasterWriter[] getDataRasterWriters();

    protected MemoryCache getCache() {
        return this.rasterCache;
    }

    protected ExecutorService getTileWriteService() {
        return this.tileWriteService;
    }

    protected Semaphore getTileWriteSemaphore() {
        return this.tileWriteSemaphore;
    }

    @Override
    protected void doStartProduction(AVList aVList) throws Exception {
        AVList aVList2 = aVList.copy();
        this.initProductionParameters(aVList2);
        this.assembleDataRasters();
        this.initLevelSetParameters(aVList2);
        LevelSet levelSet = new LevelSet(aVList2);
        this.installLevelSet(levelSet, aVList2);
        this.waitForInstallTileTasks();
        this.getCache().clear();
        this.installDataDescriptor(aVList2);
    }

    @Override
    protected String validateProductionParameters(AVList aVList) {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = aVList.getValue("gov.nasa.worldwind.avkey.FileStoreLocation");
        if (object == null || !(object instanceof String) || ((String)object).length() < 1) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.fileStoreLocation"));
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.DataCacheNameKey")) == null || !(object instanceof String) || ((String)object).length() == 0) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.fileStoreFolder"));
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.DatasetNameKey")) == null || !(object instanceof String) || ((String)object).length() < 1) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.datasetName"));
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return Logging.getMessage("DataStoreProducer.InvalidDataStoreParamters", stringBuilder.toString());
    }

    protected File installLocationFor(AVList aVList) {
        String string = aVList.getStringValue("gov.nasa.worldwind.avkey.FileStoreLocation");
        String string2 = aVList.getStringValue("gov.nasa.worldwind.avkey.DataCacheNameKey");
        if (string == null || string2 == null) {
            return null;
        }
        String string3 = TiledRasterProducer.appendPathPart(string, string2);
        if (string3 == null || string3.length() < 1) {
            return null;
        }
        return new File(string3);
    }

    protected void initProductionParameters(AVList aVList) {
    }

    protected void initLevelSetParameters(AVList aVList) {
        LatLon latLon;
        LatLon latLon2;
        Integer n;
        Integer n2;
        Integer n3;
        int n4 = Configuration.getIntegerValue("gov.nasa.worldwind.avkey.TiledRasterProducerLargeDatasetThreshold", 3000);
        boolean bl = this.isDataSetLarge(this.dataRasterList, n4);
        Sector sector = (Sector)aVList.getValue("gov.nasa.worldwind.avKey.Sector");
        if (sector == null) {
            sector = this.computeBoundingSector(this.dataRasterList);
            if (sector != null) {
                sector = sector.intersection(Sector.FULL_SPHERE);
            }
            aVList.setValue("gov.nasa.worldwind.avKey.Sector", sector);
        }
        if ((n3 = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.TileWidthKey")) == null) {
            n3 = bl ? 512 : 512;
            aVList.setValue("gov.nasa.worldwind.avkey.TileWidthKey", n3);
        }
        if ((n2 = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.TileHeightKey")) == null) {
            n2 = bl ? 512 : 512;
            aVList.setValue("gov.nasa.worldwind.avkey.TileHeightKey", n2);
        }
        LatLon latLon3 = this.computeRasterTileDelta(n3, n2, this.dataRasterList);
        LatLon latLon4 = this.computeDesiredTileDelta(sector);
        Integer n5 = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.NumLevels");
        if (n5 == null) {
            n5 = bl ? this.computeNumLevels(latLon4, latLon3) : 1;
            aVList.setValue("gov.nasa.worldwind.avkey.NumLevels", n5);
        }
        if ((n = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.NumEmptyLevels")) == null) {
            n = 0;
            aVList.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", n);
        }
        if ((latLon2 = (LatLon)aVList.getValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta")) == null) {
            double d = Math.pow(2.0, n5 - 1);
            latLon2 = LatLon.fromDegrees(d * latLon3.getLatitude().degrees, d * latLon3.getLongitude().degrees);
            aVList.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", latLon2);
        }
        if ((latLon = (LatLon)aVList.getValue("gov.nasa.worldwind.avkey.TileOrigin")) == null) {
            latLon = new LatLon(sector.getMinLatitude(), sector.getMinLongitude());
            aVList.setValue("gov.nasa.worldwind.avkey.TileOrigin", latLon);
        }
        if (!this.isWithinLatLonLimits(sector, latLon2, latLon)) {
            String string = "TiledRasterProducer: native tiling is outside lat/lon limits. Falling back to default tiling.";
            Logging.logger().warning(string);
            latLon2 = LatLon.fromDegrees(36.0, 36.0);
            aVList.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", latLon2);
            latLon = new LatLon(Angle.NEG90, Angle.NEG180);
            aVList.setValue("gov.nasa.worldwind.avkey.TileOrigin", latLon);
            n5 = this.computeNumLevels(latLon2, latLon3);
            aVList.setValue("gov.nasa.worldwind.avkey.NumLevels", n5);
            int n6 = bl ? this.computeNumLevels(latLon4, latLon3) : 1;
            n = n5 > n6 ? n5 - n6 : 0;
            aVList.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", n);
        }
    }

    protected boolean isDataSetLarge(Iterable<? extends DataRaster> iterable, int n) {
        Sector sector = this.computeBoundingSector(iterable);
        LatLon latLon = this.computeSmallestPixelSize(iterable);
        int n2 = (int)Math.ceil(sector.getDeltaLonDegrees() / latLon.getLongitude().degrees);
        int n3 = (int)Math.ceil(sector.getDeltaLatDegrees() / latLon.getLatitude().degrees);
        return n2 >= n || n3 >= n;
    }

    protected boolean isWithinLatLonLimits(Sector sector, LatLon latLon, LatLon latLon2) {
        double d = Math.floor((sector.getMinLatitude().degrees - latLon2.getLatitude().degrees) / latLon.getLatitude().degrees);
        d = latLon2.getLatitude().degrees + d * latLon.getLatitude().degrees;
        double d2 = Math.ceil((sector.getMaxLatitude().degrees - latLon2.getLatitude().degrees) / latLon.getLatitude().degrees);
        d2 = latLon2.getLatitude().degrees + d2 * latLon.getLatitude().degrees;
        double d3 = Math.floor((sector.getMinLongitude().degrees - latLon2.getLongitude().degrees) / latLon.getLongitude().degrees);
        d3 = latLon2.getLongitude().degrees + d3 * latLon.getLongitude().degrees;
        double d4 = Math.ceil((sector.getMaxLongitude().degrees - latLon2.getLongitude().degrees) / latLon.getLongitude().degrees);
        d4 = latLon2.getLongitude().degrees + d4 * latLon.getLongitude().degrees;
        return Sector.fromDegrees(d, d2, d3, d4).isWithinLatLonLimits();
    }

    protected Sector computeBoundingSector(Iterable<? extends DataRaster> iterable) {
        Sector sector = null;
        for (DataRaster dataRaster : iterable) {
            sector = sector != null ? dataRaster.getSector().union(sector) : dataRaster.getSector();
        }
        return sector;
    }

    protected LatLon computeRasterTileDelta(int n, int n2, Iterable<? extends DataRaster> iterable) {
        LatLon latLon = this.computeSmallestPixelSize(iterable);
        double d = (double)n2 * latLon.getLatitude().degrees;
        double d2 = (double)n * latLon.getLongitude().degrees;
        return LatLon.fromDegrees(d, d2);
    }

    protected LatLon computeDesiredTileDelta(Sector sector) {
        double d = Math.min(sector.getDeltaLatDegrees(), 36.0);
        double d2 = Math.min(sector.getDeltaLonDegrees(), 36.0);
        return LatLon.fromDegrees(d, d2);
    }

    protected LatLon computeRasterPixelSize(DataRaster dataRaster) {
        return LatLon.fromDegrees(dataRaster.getSector().getDeltaLatDegrees() / (double)dataRaster.getHeight(), dataRaster.getSector().getDeltaLonDegrees() / (double)dataRaster.getWidth());
    }

    protected LatLon computeSmallestPixelSize(Iterable<? extends DataRaster> iterable) {
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        for (DataRaster dataRaster : iterable) {
            LatLon latLon = this.computeRasterPixelSize(dataRaster);
            if (d > latLon.getLatitude().degrees) {
                d = latLon.getLatitude().degrees;
            }
            if (!(d2 > latLon.getLongitude().degrees)) continue;
            d2 = latLon.getLongitude().degrees;
        }
        return LatLon.fromDegrees(d, d2);
    }

    protected int computeNumLevels(LatLon latLon, LatLon latLon2) {
        double d;
        double d2 = WWMath.logBase2(latLon.getLatitude().getDegrees()) - WWMath.logBase2(latLon2.getLatitude().getDegrees());
        int n = (int)Math.ceil(Math.max(d2, d = WWMath.logBase2(latLon.getLongitude().getDegrees()) - WWMath.logBase2(latLon2.getLongitude().getDegrees())));
        if (n < 1) {
            n = 1;
        }
        return n;
    }

    protected void assembleDataRasters() throws Exception {
        if (this.isStopped()) {
            return;
        }
        for (DataSource dataSource : this.getDataSourceList()) {
            if (this.isStopped()) break;
            String string = this.validateDataSource(dataSource);
            if (string != null) {
                Logging.logger().severe(string);
                throw new IOException(string);
            }
            this.assembleDataSource(dataSource);
        }
    }

    protected void assembleDataSource(DataSource dataSource) throws Exception {
        if (dataSource.getSource() instanceof DataRaster) {
            this.dataRasterList.add((DataRaster)dataSource.getSource());
        } else {
            DataRasterReader dataRasterReader = ReadableDataRaster.findReaderFor(dataSource, this.getDataRasterReaders());
            this.dataRasterList.add(new ReadableDataRaster(dataSource, dataRasterReader, this.getCache()));
        }
    }

    @Override
    protected String validateDataSource(DataSource dataSource) {
        DataRasterReader dataRasterReader;
        if (dataSource == null) {
            return Logging.getMessage("nullValue.DataSourceIsNull");
        }
        if (!(dataSource.getSource() instanceof DataRaster) && (dataRasterReader = ReadableDataRaster.findReaderFor(dataSource, this.getDataRasterReaders())) == null) {
            return Logging.getMessage("DataStoreProducer.InvalidDataSource", dataSource);
        }
        return null;
    }

    protected static MemoryCache createDefaultCache() {
        long l = Configuration.getLongValue("gov.nasa.worldwind.avkey.TiledRasterProducerCacheSize", 300000000L);
        return new BasicMemoryCache((long)(0.8 * (double)l), l);
    }

    protected void installLevelSet(LevelSet levelSet, AVList aVList) throws IOException {
        if (this.isStopped()) {
            return;
        }
        this.setProgressParams(levelSet);
        this.startProgress();
        Sector sector = levelSet.getSector();
        gov.nasa.worldwind.util.Level level = levelSet.getFirstLevel();
        Angle angle = level.getTileDelta().getLatitude();
        Angle angle2 = level.getTileDelta().getLongitude();
        Angle angle3 = levelSet.getTileOrigin().getLatitude();
        Angle angle4 = levelSet.getTileOrigin().getLongitude();
        int n = Tile.computeRow(angle, sector.getMinLatitude(), angle3);
        int n2 = Tile.computeColumn(angle2, sector.getMinLongitude(), angle4);
        int n3 = Tile.computeRow(angle, sector.getMaxLatitude(), angle3);
        int n4 = Tile.computeColumn(angle2, sector.getMaxLongitude(), angle4);
        Angle angle5 = Tile.computeRowLatitude(n, angle, angle3);
        for (int i = n; i <= n3 && !this.isStopped(); ++i) {
            Angle angle6 = angle5.add(angle);
            Angle angle7 = Tile.computeColumnLongitude(n2, angle2, angle4);
            for (int j = n2; j <= n4 && !this.isStopped(); ++j) {
                Angle angle8 = angle7.add(angle2);
                Tile tile = new Tile(new Sector(angle5, angle6, angle7, angle8), level, i, j);
                DataRaster dataRaster = this.createTileRaster(levelSet, tile, aVList);
                if (dataRaster != null) {
                    this.installTileRasterLater(tile, dataRaster, aVList);
                }
                angle7 = angle8;
            }
            angle5 = angle6;
        }
    }

    protected DataRaster createTileRaster(LevelSet levelSet, Tile tile, AVList aVList) throws IOException {
        if (this.isStopped()) {
            return null;
        }
        DataRaster dataRaster = levelSet.isFinalLevel(tile.getLevelNumber()) ? this.drawDataSources(levelSet, tile, this.dataRasterList, aVList) : this.drawDescendants(levelSet, tile, aVList);
        this.updateProgress();
        return dataRaster;
    }

    protected DataRaster drawDataSources(LevelSet levelSet, Tile tile, Iterable<DataRaster> iterable, AVList aVList) throws IOException {
        DataRaster dataRaster = null;
        ArrayList<DataRaster> arrayList = new ArrayList<DataRaster>();
        for (DataRaster dataRaster2 : iterable) {
            if (!dataRaster2.getSector().intersects(tile.getSector()) || !dataRaster2.getSector().intersects(levelSet.getSector())) continue;
            arrayList.add(dataRaster2);
        }
        if (!arrayList.isEmpty() && !tile.getLevel().isEmpty()) {
            dataRaster = this.createDataRaster(tile.getLevel().getTileWidth(), tile.getLevel().getTileHeight(), tile.getSector(), aVList);
            for (DataRaster dataRaster2 : arrayList) {
                dataRaster2.drawOnCanvas(dataRaster);
            }
        }
        arrayList.clear();
        arrayList = null;
        return dataRaster;
    }

    protected DataRaster drawDescendants(LevelSet levelSet, Tile tile, AVList aVList) throws IOException {
        int n;
        DataRaster dataRaster = null;
        boolean bl = false;
        Tile[] tileArray = this.createSubTiles(tile, levelSet.getLevel(tile.getLevelNumber() + 1));
        DataRaster[] dataRasterArray = new DataRaster[tileArray.length];
        for (n = 0; n < tileArray.length; ++n) {
            DataRaster dataRaster2;
            if (!tileArray[n].getSector().intersects(levelSet.getSector()) || (dataRaster2 = this.createTileRaster(levelSet, tileArray[n], aVList)) == null) continue;
            dataRasterArray[n] = dataRaster2;
            bl = true;
        }
        if (this.isStopped()) {
            return null;
        }
        if (bl && !tile.getLevel().isEmpty()) {
            dataRaster = this.createDataRaster(tile.getLevel().getTileWidth(), tile.getLevel().getTileHeight(), tile.getSector(), aVList);
            for (n = 0; n < tileArray.length; ++n) {
                if (dataRasterArray[n] == null) continue;
                dataRasterArray[n].drawOnCanvas(dataRaster);
                this.installTileRasterLater(tileArray[n], dataRasterArray[n], aVList);
            }
        }
        for (n = 0; n < tileArray.length; ++n) {
            tileArray[n] = null;
            dataRasterArray[n] = null;
        }
        tileArray = null;
        dataRasterArray = null;
        return dataRaster;
    }

    protected Tile[] createSubTiles(Tile tile, gov.nasa.worldwind.util.Level level) {
        Angle angle = tile.getSector().getMinLatitude();
        Angle angle2 = tile.getSector().getMaxLatitude();
        Angle angle3 = Angle.midAngle(angle, angle2);
        Angle angle4 = tile.getSector().getMinLongitude();
        Angle angle5 = tile.getSector().getMaxLongitude();
        Angle angle6 = Angle.midAngle(angle4, angle5);
        int n = tile.getRow();
        int n2 = tile.getColumn();
        Tile[] tileArray = new Tile[]{new Tile(new Sector(angle, angle3, angle4, angle6), level, 2 * n, 2 * n2), new Tile(new Sector(angle, angle3, angle6, angle5), level, 2 * n, 2 * n2 + 1), new Tile(new Sector(angle3, angle2, angle6, angle5), level, 2 * n + 1, 2 * n2 + 1), new Tile(new Sector(angle3, angle2, angle4, angle6), level, 2 * n + 1, 2 * n2)};
        return tileArray;
    }

    protected ExecutorService createDefaultTileWriteService(int n) {
        return new ThreadPoolExecutor(n, n, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue()){

            protected void afterExecute(Runnable runnable, Throwable throwable) {
                super.afterExecute(runnable, throwable);
                TiledRasterProducer.this.installTileRasterComplete();
            }
        };
    }

    protected void installTileRasterLater(final Tile tile, final DataRaster dataRaster, final AVList aVList) {
        this.getTileWriteSemaphore().acquireUninterruptibly();
        this.getTileWriteService().execute(new Runnable(){

            public void run() {
                try {
                    TiledRasterProducer.this.installTileRaster(tile, dataRaster, aVList);
                    if (dataRaster instanceof Disposable) {
                        ((Disposable)((Object)dataRaster)).dispose();
                    }
                }
                catch (Throwable throwable) {
                    String string = Logging.getMessage("generic.ExceptionWhileWriting", tile);
                    Logging.logger().log(Level.SEVERE, string, throwable);
                }
            }
        });
    }

    protected void installTileRasterComplete() {
        this.getTileWriteSemaphore().release();
    }

    protected void waitForInstallTileTasks() {
        try {
            ExecutorService executorService = this.getTileWriteService();
            executorService.shutdown();
            while (!executorService.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
            }
        }
        catch (InterruptedException interruptedException) {
            String string = "Exception while shutting down executor";
            Logging.logger().severe(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installTileRaster(Tile tile, DataRaster dataRaster, AVList aVList) throws IOException {
        Object object;
        DataRasterWriter[] dataRasterWriterArray;
        Object object2 = this.installLocationForTile(aVList, tile);
        if (!(object2 instanceof File)) {
            String string = object2.toString();
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        File file = (File)object2;
        Object object3 = this.fileLock;
        synchronized (object3) {
            dataRasterWriterArray = file.getParentFile();
            if (!dataRasterWriterArray.exists() && !dataRasterWriterArray.mkdirs()) {
                object = Logging.getMessage("generic.CannotCreateFile", new Object[]{dataRasterWriterArray});
                Logging.logger().warning((String)object);
            }
        }
        object3 = aVList.getStringValue("gov.nasa.worldwind.avkey.FormatSuffixKey");
        dataRasterWriterArray = this.getDataRasterWriters();
        object = this.findWriterFor(dataRaster, (String)object3, file, dataRasterWriterArray);
        if (object instanceof DataRasterWriter) {
            try {
                ((DataRasterWriter)object).write(dataRaster, (String)object3, file);
            }
            catch (IOException iOException) {
                String string = Logging.getMessage("generic.ExceptionWhileWriting", file);
                Logging.logger().log(Level.SEVERE, string, iOException);
            }
        }
    }

    protected Object installLocationForTile(AVList aVList, Tile tile) {
        String string = null;
        String string2 = aVList.getStringValue("gov.nasa.worldwind.avkey.FileStoreLocation");
        if (string2 != null) {
            string = TiledRasterProducer.appendPathPart(string, string2);
        }
        if ((string2 = tile.getPath()) != null) {
            string = TiledRasterProducer.appendPathPart(string, string2);
        }
        if (string == null || string.length() < 1) {
            return Logging.getMessage("DataStoreProducer.InvalidTile", tile);
        }
        return new File(string);
    }

    protected Object findWriterFor(DataRaster dataRaster, String string, File file, DataRasterWriter[] dataRasterWriterArray) {
        for (DataRasterWriter dataRasterWriter : dataRasterWriterArray) {
            if (!dataRasterWriter.canWrite(dataRaster, string, file)) continue;
            return dataRasterWriter;
        }
        return Logging.getMessage("DataRaster.CannotWrite", dataRaster, string, file);
    }

    private static String appendPathPart(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        if (string == null || string.length() == 0) {
            return string2;
        }
        string = WWIO.stripTrailingSeparator(string);
        string2 = WWIO.stripLeadingSeparator(string2);
        return string + System.getProperty("file.separator") + string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installDataDescriptor(AVList aVList) throws IOException {
        Object object;
        if (this.isStopped()) {
            return;
        }
        BasicDataDescriptor basicDataDescriptor = new BasicDataDescriptor();
        BasicDataDescriptorWriter basicDataDescriptorWriter = new BasicDataDescriptorWriter();
        Object object3 = aVList.getValue("gov.nasa.worldwind.avkey.FileStoreLocation");
        if (object3 != null) {
            basicDataDescriptor.setFileStoreLocation(new File(object3.toString()));
        }
        if ((object3 = aVList.getValue("gov.nasa.worldwind.avkey.DataCacheNameKey")) != null) {
            basicDataDescriptor.setFileStorePath(object3.toString());
        }
        if ((object3 = aVList.getValue("gov.nasa.worldwind.avkey.DatasetNameKey")) != null) {
            basicDataDescriptor.setName(object3.toString());
        }
        if ((object3 = aVList.getValue("gov.nasa.worldwind.avkey.DataType")) != null) {
            basicDataDescriptor.setType(object3.toString());
        }
        for (Map.Entry<String, Object> object22 : aVList.getEntries()) {
            object = object22.getKey();
            if (((String)object).equals("gov.nasa.worldwind.avkey.FileStoreLocation") || ((String)object).equals("gov.nasa.worldwind.avkey.DataCacheNameKey") || ((String)object).equals("gov.nasa.worldwind.avkey.DatasetNameKey") || ((String)object).equals("gov.nasa.worldwind.avkey.DataType")) continue;
            basicDataDescriptor.setValue((String)object, object22.getValue());
        }
        Object object2 = this.installLocationForDescriptor(basicDataDescriptor, basicDataDescriptorWriter);
        if (!(object2 instanceof File)) {
            object = object2.toString();
            Logging.logger().severe((String)object);
            throw new IOException((String)object);
        }
        File file = (File)object2;
        object = this.fileLock;
        synchronized (object) {
            File file2 = file.getParentFile();
            if (!file2.exists() && !file2.mkdirs()) {
                String string = Logging.getMessage("generic.CannotCreateFile", file2);
                Logging.logger().warning(string);
            }
        }
        basicDataDescriptorWriter.setDestination(file);
        basicDataDescriptorWriter.write(basicDataDescriptor);
        this.getProductionResultsList().add(basicDataDescriptor);
    }

    protected Object installLocationForDescriptor(DataDescriptor dataDescriptor, DataDescriptorWriter dataDescriptorWriter) {
        String string;
        String string2 = null;
        File file = dataDescriptor.getFileStoreLocation();
        if (file != null) {
            string2 = TiledRasterProducer.appendPathPart(string2, file.getPath());
        }
        if ((string = dataDescriptor.getFileStorePath()) != null) {
            string2 = TiledRasterProducer.appendPathPart(string2, string);
        }
        if ((string2 = TiledRasterProducer.appendPathPart(string2, string = "dataDescriptor" + WWIO.makeSuffixForMimeType(dataDescriptorWriter.getMimeType()))) == null || string2.length() < 1) {
            return Logging.getMessage("DataStoreProducer.InvalidDataStoreParamters", dataDescriptor);
        }
        return new File(string2);
    }

    protected void setProgressParams(LevelSet levelSet) {
        Sector sector = levelSet.getSector();
        this.tileCount = 0;
        for (gov.nasa.worldwind.util.Level level : levelSet.getLevels()) {
            Angle angle = level.getTileDelta().getLatitude();
            Angle angle2 = level.getTileDelta().getLongitude();
            Angle angle3 = levelSet.getTileOrigin().getLatitude();
            Angle angle4 = levelSet.getTileOrigin().getLongitude();
            int n = Tile.computeRow(angle, sector.getMinLatitude(), angle3);
            int n2 = Tile.computeColumn(angle2, sector.getMinLongitude(), angle4);
            int n3 = Tile.computeRow(angle, sector.getMaxLatitude(), angle3);
            int n4 = Tile.computeColumn(angle2, sector.getMaxLongitude(), angle4);
            this.tileCount += (n3 - n + 1) * (n4 - n2 + 1);
        }
    }

    protected void startProgress() {
        this.tile = 0;
        this.firePropertyChange("gov.nasa.worldwind.avkey.Progress", null, 0.0);
    }

    protected void updateProgress() {
        double d = (double)this.tile / (double)this.tileCount;
        double d2 = (double)(++this.tile) / (double)this.tileCount;
        this.firePropertyChange("gov.nasa.worldwind.avkey.Progress", d, d2);
    }
}

