/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.data.AbstractDataStoreProducer;
import gov.nasa.worldwind.data.DataDescriptor;
import gov.nasa.worldwind.data.DataSource;
import gov.nasa.worldwind.data.WWDotNetLayerSetReader;
import gov.nasa.worldwind.data.WWDotNetLayerSetWriter;
import gov.nasa.worldwind.formats.dds.DDSCompressor;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WWDotNetLayerSetInstaller
extends AbstractDataStoreProducer {
    @Override
    public String getDataSourceDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Logging.getMessage("DataStoreProducer.WWDotNetLayerSet.Description"));
        WWDotNetLayerSetReader wWDotNetLayerSetReader = new WWDotNetLayerSetReader();
        String string = WWIO.makeSuffixForMimeType(wWDotNetLayerSetReader.getMimeType());
        stringBuilder.append(" (").append("*").append(string).append(")");
        return stringBuilder.toString();
    }

    @Override
    protected void doStartProduction(AVList aVList) throws Exception {
        this.getProductionResultsList().clear();
        List<DataSource> list = this.getDataSourceList();
        ProductionState productionState = new ProductionState();
        this.initProductionParameters(aVList, productionState);
        this.setProgressParameters(list, productionState);
        for (DataSource dataSource : list) {
            ++productionState.curSource;
            this.install(dataSource, productionState);
        }
    }

    protected void initProductionParameters(AVList aVList, ProductionState productionState) {
        Object object = aVList.getValue("gov.nasa.worldwind.avkey.MimeType");
        if (object == null || !(object instanceof String)) {
            aVList.setValue("gov.nasa.worldwind.avkey.MimeType", "image/dds");
        }
        productionState.productionParams = aVList;
    }

    @Override
    protected String validateProductionParameters(AVList aVList) {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = aVList.getValue("gov.nasa.worldwind.avkey.FileStoreLocation");
        if (object == null || !(object instanceof String) || ((String)object).length() < 1) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.fileStoreLocation"));
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.DataCacheNameKey")) != null && !(object instanceof String)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.fileStoreFolder"));
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return Logging.getMessage("DataStoreProducer.InvalidDataStoreParamters", stringBuilder.toString());
    }

    @Override
    protected String validateDataSource(DataSource dataSource) {
        StringBuilder stringBuilder = new StringBuilder();
        if (dataSource.getSource() instanceof DataDescriptor) {
            DataDescriptor dataDescriptor = (DataDescriptor)dataSource.getSource();
            if (!dataDescriptor.hasKey("gov.nasa.worldwind.avkey.WorldWindDotNetLayerSet")) {
                stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append("DataDescriptor not a World Wind .NET LayerSet: ").append(dataSource);
            }
        } else {
            try {
                WWDotNetLayerSetReader wWDotNetLayerSetReader = new WWDotNetLayerSetReader();
                wWDotNetLayerSetReader.setSource(dataSource.getSource());
                if (!wWDotNetLayerSetReader.canRead()) {
                    stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append("source not a World Wind .NET LayerSet: ").append(dataSource);
                }
            }
            catch (IOException iOException) {
                stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append("source not readable: ").append(dataSource);
            }
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return Logging.getMessage("DataStoreProducer.InvalidDataSource", stringBuilder.toString());
    }

    protected void install(DataSource dataSource, ProductionState productionState) throws IOException {
        File file;
        File file2;
        String string = null;
        AVList aVList = productionState.productionParams;
        Object object = this.readSource(dataSource);
        if (!(object instanceof DataDescriptor)) {
            String string2 = object.toString();
            Logging.logger().severe(string2);
            throw new IOException(string2);
        }
        DataDescriptor dataDescriptor = (DataDescriptor)object;
        object = this.sourceLocationFor(dataSource, dataDescriptor);
        if (!(object instanceof File)) {
            String string3 = object.toString();
            Logging.logger().severe(string3);
            throw new IOException(string3);
        }
        File file3 = (File)object;
        object = this.installLocationFor(aVList, dataSource, dataDescriptor);
        if (object instanceof File) {
            file2 = (File)object;
            file = new File(file2, this.filenameFor(dataDescriptor));
            if (WWIO.isAncestorOf(file3, file2)) {
                String string4 = Logging.getMessage("DataStoreProducer.CannotInstallInto", file3, file2);
                Logging.logger().severe(string4);
                throw new IOException(string4);
            }
            if (WWIO.isAncestorOf(file2, file3)) {
                String string5 = Logging.getMessage("DataStoreProducer.CannotInstallInto", file2, file3);
                Logging.logger().severe(string5);
                throw new IOException(string5);
            }
        } else {
            String string6 = object.toString();
            Logging.logger().severe(string6);
            throw new IOException(string6);
        }
        try {
            object = aVList.getValue("gov.nasa.worldwind.avkey.MimeType");
            if (object != null) {
                string = object.toString();
                dataDescriptor.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", WWIO.makeSuffixForMimeType(string));
            }
            productionState.numSourceFiles[productionState.curSource] = this.countWWDotNetFiles(file3);
            this.installWWDotNetDiretory(file3, file2, string, productionState);
            if (productionState.numSourceFiles[productionState.curSource] != productionState.numInstalledFiles[productionState.curSource]) {
                String string7 = Logging.getMessage("DataStoreProducer.IncompleteInstallation", file2);
                Logging.logger().severe(string7);
                throw new IOException(string7);
            }
        }
        catch (IOException iOException) {
            WWIO.deleteDirectory(file2);
            String string8 = Logging.getMessage("generic.ExceptionWhileWriting", file2);
            Logging.logger().log(Level.SEVERE, string8, iOException);
            throw iOException;
        }
        try {
            WWDotNetLayerSetWriter wWDotNetLayerSetWriter = new WWDotNetLayerSetWriter();
            wWDotNetLayerSetWriter.setDestination(file);
            wWDotNetLayerSetWriter.write(dataDescriptor);
        }
        catch (IOException iOException) {
            WWIO.deleteDirectory(file2);
            file.delete();
            String string9 = Logging.getMessage("generic.ExceptionWhileWriting", file);
            Logging.logger().severe(string9);
            throw iOException;
        }
        this.getProductionResultsList().add(dataDescriptor);
    }

    protected Object readSource(DataSource dataSource) {
        Object object;
        try {
            WWDotNetLayerSetReader wWDotNetLayerSetReader = new WWDotNetLayerSetReader();
            wWDotNetLayerSetReader.setSource(dataSource.getSource());
            object = wWDotNetLayerSetReader.read();
        }
        catch (IOException iOException) {
            object = Logging.getMessage("generic.ExceptionWhileReading", dataSource);
        }
        return object;
    }

    protected Object sourceLocationFor(DataSource dataSource, DataDescriptor dataDescriptor) {
        Object object;
        if (dataSource.getSource() instanceof File) {
            File file = (File)dataSource.getSource();
            object = file.getParentFile();
            if (object == null) {
                object = Logging.getMessage("DataStoreProducer.FileWithoutParent", dataSource);
            }
        } else {
            File file;
            String string = dataDescriptor.getStringValue("gov.nasa.worldwind.avkey.WorldWindDotNetPermanentDirectory");
            object = string != null ? ((file = new File(string)).exists() ? file : Logging.getMessage("DataStoreProducer.WWDotNetPermanentDirectoryInvalid", string)) : Logging.getMessage("DataStoreProducer.WWDotNetPermanentDirectoryMissing", dataSource);
        }
        return object;
    }

    protected Object installLocationFor(AVList aVList, DataSource dataSource, DataDescriptor dataDescriptor) {
        String string = null;
        String string2 = aVList.getStringValue("gov.nasa.worldwind.avkey.FileStoreLocation");
        if (string2 != null) {
            string = WWDotNetLayerSetInstaller.appendPathPart(string, string2);
        }
        if ((string2 = aVList.getStringValue("gov.nasa.worldwind.avkey.DataCacheNameKey")) != null) {
            string = WWDotNetLayerSetInstaller.appendPathPart(string, string2);
        }
        if (dataDescriptor != null && dataDescriptor.getName() != null) {
            string = WWDotNetLayerSetInstaller.appendPathPart(string, dataDescriptor.getName());
        }
        if (string == null || string.length() < 1) {
            return Logging.getMessage("DataStoreProducer.InvalidDataSource", dataSource);
        }
        return new File(string);
    }

    protected String filenameFor(DataDescriptor dataDescriptor) {
        String string = dataDescriptor.getStringValue("gov.nasa.worldwind.avkey.DatasetNameKey");
        if (string != null) {
            string = WWIO.replaceSuffix(string, ".xml");
        }
        if (string == null) {
            string = "WorldWindDotNetLayerSet.xml";
        }
        return WWIO.formPath(string);
    }

    private static String appendPathPart(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        if (string == null || string.length() == 0) {
            return string2;
        }
        string = WWIO.stripTrailingSeparator(string);
        string2 = WWIO.stripLeadingSeparator(string2);
        return string + System.getProperty("file.separator") + string2;
    }

    private void installWWDotNetDiretory(File file, File file2, String string, ProductionState productionState) throws IOException {
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (!file2.exists()) {
            String string2 = Logging.getMessage("generic.CannotCreateFile", file2);
            Logging.logger().severe(string2);
            throw new IOException(string2);
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        for (File object : fileArray) {
            if (object == null || object.isHidden()) continue;
            if (object.isDirectory()) {
                arrayList2.add(object);
                continue;
            }
            arrayList.add(object);
        }
        for (File file3 : arrayList) {
            if (!WWDotNetLayerSetInstaller.isWWDotNetFile(file3)) continue;
            File file4 = WWDotNetLayerSetInstaller.makeWWJavaFile(file2, file3.getName(), string);
            this.installWWDotNetFile(file3, file4, productionState);
            if (file4.exists()) continue;
            String string2 = Logging.getMessage("generic.CannotCreateFile", file4);
            Logging.logger().severe(string2);
            throw new IOException(string2);
        }
        for (File file5 : arrayList2) {
            if (!WWDotNetLayerSetInstaller.isWWDotNetDirectory(file5)) continue;
            File file6 = WWDotNetLayerSetInstaller.makeWWJavaDirectory(file2, file5.getName());
            this.installWWDotNetDiretory(file5, file6, string, productionState);
        }
    }

    private void installWWDotNetFile(File file, File file2, ProductionState productionState) throws IOException {
        String string;
        if (file2.exists() && file.lastModified() >= file2.lastModified() && file.length() == file2.length()) {
            return;
        }
        String string2 = WWIO.getSuffix(file.getName());
        if (string2.equalsIgnoreCase(string = WWIO.getSuffix(file2.getName()))) {
            WWIO.copyFile(file, file2);
        } else if (string.equalsIgnoreCase("dds")) {
            ByteBuffer byteBuffer = DDSCompressor.compressImageFile(file);
            WWIO.saveBuffer(byteBuffer, file2);
        } else {
            BufferedImage bufferedImage = ImageIO.read(file);
            ImageIO.write((RenderedImage)bufferedImage, string, file2);
        }
        this.updateProgress(productionState);
    }

    private static File makeWWJavaDirectory(File file, String string) {
        return new File(file, WWIO.stripLeadingZeros(string));
    }

    private static File makeWWJavaFile(File file, String string, String string2) {
        String[] stringArray = string.split("[._]");
        if (stringArray == null || stringArray.length < 3 || stringArray[0].length() < 1 || stringArray[1].length() < 1) {
            return new File(file, string);
        }
        if (string2 != null) {
            stringArray[2] = WWIO.makeSuffixForMimeType(string2);
        } else if (stringArray[2].length() > 1) {
            stringArray[2] = "." + stringArray[2];
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(WWIO.stripLeadingZeros(stringArray[0])).append("_").append(WWIO.stripLeadingZeros(stringArray[1]));
        stringBuilder.append(stringArray[2]);
        return new File(file, stringBuilder.toString());
    }

    private static boolean isWWDotNetDirectory(File file) {
        String string = "\\d+";
        return file.getName().matches(string);
    }

    private static boolean isWWDotNetFile(File file) {
        String string = "\\d+[_]\\d+[.]\\w+";
        return file.getName().matches(string);
    }

    private int countWWDotNetFiles(File file) {
        int n = 0;
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return n;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        for (File file2 : fileArray) {
            if (file2 == null || file2.isHidden()) continue;
            if (file2.isDirectory()) {
                arrayList2.add(file2);
                continue;
            }
            arrayList.add(file2);
        }
        for (File file3 : arrayList) {
            if (!WWDotNetLayerSetInstaller.isWWDotNetFile(file3)) continue;
            ++n;
        }
        for (File file4 : arrayList2) {
            if (!WWDotNetLayerSetInstaller.isWWDotNetDirectory(file4)) continue;
            n += this.countWWDotNetFiles(file4);
        }
        return n;
    }

    protected void setProgressParameters(Iterable<?> iterable, ProductionState productionState) {
        int n = 0;
        for (Object obj : iterable) {
            ++n;
        }
        productionState.numSources = n;
        productionState.curSource = -1;
        productionState.numSourceFiles = new int[n];
        productionState.numInstalledFiles = new int[n];
    }

    private void updateProgress(ProductionState productionState) {
        double d = this.computeProgress(productionState);
        int n = productionState.curSource;
        productionState.numInstalledFiles[n] = productionState.numInstalledFiles[n] + 1;
        double d2 = this.computeProgress(productionState);
        this.firePropertyChange("gov.nasa.worldwind.avkey.Progress", d, d2);
    }

    private double computeProgress(ProductionState productionState) {
        double d = 0.0;
        for (int i = 0; i <= productionState.curSource; ++i) {
            d += (double)productionState.numInstalledFiles[i] / (double)productionState.numSourceFiles[i] * (1.0 / (double)productionState.numSources);
        }
        return d;
    }

    static class ProductionState {
        AVList productionParams;
        int numSources;
        int curSource;
        int[] numSourceFiles;
        int[] numInstalledFiles;

        ProductionState() {
        }
    }
}

