/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.data.AbstractDataDescriptorReader;
import gov.nasa.worldwind.data.BasicDataDescriptor;
import gov.nasa.worldwind.data.DataDescriptor;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WWDotNetLayerSetReader
extends AbstractDataDescriptorReader {
    public static final String MIME_TYPE = "text/xml";

    public String getMimeType() {
        return MIME_TYPE;
    }

    public boolean matchesMimeType(String string) {
        if (string == null) {
            return false;
        }
        return string.toLowerCase().contains(this.getMimeType());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Logging.getMessage("DataDescriptor.WWDotNetLayerSet.Name"));
        stringBuilder.append("(*").append(WWIO.makeSuffixForMimeType(this.getMimeType())).append(")");
        return stringBuilder.toString();
    }

    protected boolean doCanRead(Object object) throws IOException {
        String string = null;
        if (object instanceof File) {
            string = ((File)object).getPath();
        } else if (object instanceof URL) {
            string = ((URL)object).toExternalForm();
        }
        String string2 = WWIO.makeSuffixForMimeType(this.getMimeType());
        if (string != null && !string.toLowerCase().endsWith(string2)) {
            return false;
        }
        return super.doCanRead(object);
    }

    protected boolean doCanReadStream(Reader reader) throws IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(reader));
            Object object = xPath.evaluate("/LayerSet", document.getDocumentElement(), XPathConstants.NODE);
            if (object != null && object instanceof Node) {
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    protected DataDescriptor doRead(Reader reader) throws IOException {
        BasicDataDescriptor basicDataDescriptor = new BasicDataDescriptor();
        this.readInputStream(reader, basicDataDescriptor);
        return basicDataDescriptor;
    }

    protected void readInputStream(Reader reader, DataDescriptor dataDescriptor) throws IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(reader));
            this.parseLayerSet(document.getDocumentElement(), dataDescriptor);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = Logging.getMessage("generic.CannotParseInputStream", reader);
            Logging.logger().log(Level.SEVERE, string, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            String string = Logging.getMessage("generic.CannotParseInputStream", reader);
            Logging.logger().log(Level.SEVERE, string, sAXException);
        }
    }

    protected void parseLayerSet(Node node, DataDescriptor dataDescriptor) throws IOException {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        try {
            Double d;
            Object object = xPath.evaluate("/LayerSet", node, XPathConstants.NODE);
            if (object == null) {
                String string = Logging.getMessage("generic.CannotParseInputStream", node);
                Logging.logger().severe(string);
                throw new IOException(string);
            }
            dataDescriptor.setValue("gov.nasa.worldwind.avkey.WorldWindDotNetLayerSet", Boolean.TRUE);
            dataDescriptor.setType("gov.nasa.worldwind.avkey.TiledImagery");
            String string = xPath.evaluate("/LayerSet/QuadTileSet/Name", node);
            if (string != null && string.length() != 0) {
                dataDescriptor.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", string);
            }
            Double d2 = (Double)xPath.evaluate("/LayerSet/QuadTileSet/BoundingBox/South/Value", node, XPathConstants.NUMBER);
            Double d3 = (Double)xPath.evaluate("/LayerSet/QuadTileSet/BoundingBox/North/Value", node, XPathConstants.NUMBER);
            Double d4 = (Double)xPath.evaluate("/LayerSet/QuadTileSet/BoundingBox/West/Value", node, XPathConstants.NUMBER);
            Double d5 = (Double)xPath.evaluate("/LayerSet/QuadTileSet/BoundingBox/East/Value", node, XPathConstants.NUMBER);
            if (!(d2 == null || d3 == null || d4 == null || d5 == null || Double.isNaN(d2) || Double.isNaN(d3) || Double.isNaN(d4) || Double.isNaN(d5))) {
                dataDescriptor.setValue("gov.nasa.worldwind.avKey.Sector", Sector.fromDegrees(d2, d3, d4, d5));
            }
            if ((d = (Double)xPath.evaluate("/LayerSet/QuadTileSet/ImageAccessor/LevelZeroTileSizeDegrees", node, XPathConstants.NUMBER)) != null && !Double.isNaN(d)) {
                LatLon latLon = LatLon.fromDegrees(d, d);
                dataDescriptor.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", latLon);
            }
            if ((d = (Double)xPath.evaluate("/LayerSet/QuadTileSet/ImageAccessor/NumberLevels", node, XPathConstants.NUMBER)) != null && !Double.isNaN(d)) {
                int n = d.intValue();
                dataDescriptor.setValue("gov.nasa.worldwind.avkey.NumLevels", n);
            }
            dataDescriptor.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", 0);
            d = (Double)xPath.evaluate("/LayerSet/QuadTileSet/ImageAccessor/TextureSizePixels", node, XPathConstants.NUMBER);
            if (d != null && !Double.isNaN(d)) {
                int n = d.intValue();
                dataDescriptor.setValue("gov.nasa.worldwind.avkey.TileWidthKey", n);
                dataDescriptor.setValue("gov.nasa.worldwind.avkey.TileHeightKey", n);
            }
            if ((string = xPath.evaluate("/LayerSet/QuadTileSet/ImageAccessor/ImageFileExtension", node)) != null && string.length() != 0) {
                string = WWDotNetLayerSetReader.addLeadingPeriod(string);
                dataDescriptor.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", string);
            }
            if ((string = xPath.evaluate("/LayerSet/QuadTileSet/ImageAccessor/PermanentDirectory", node)) != null && string.length() != 0) {
                dataDescriptor.setValue("gov.nasa.worldwind.avkey.WorldWindDotNetPermanentDirectory", string);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            String string = Logging.getMessage("generic.CannotParseInputStream", node);
            Logging.logger().log(Level.SEVERE, string, xPathExpressionException);
        }
    }

    private static String addLeadingPeriod(String string) {
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        return string;
    }
}

