/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.SceneController;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.examples.util.ShapeUtils;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.AirspaceLayer;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.airspaces.Airspace;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.BasicAirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.Polygon;
import gov.nasa.worldwind.render.airspaces.SphereAirspace;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceEditEvent;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceEditListener;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceEditor;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceEditorController;
import gov.nasa.worldwind.render.airspaces.editor.PolygonEditor;
import gov.nasa.worldwind.render.airspaces.editor.SphereAirspaceEditor;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.view.FlyToOrbitViewStateIterator;
import gov.nasa.worldwind.view.OrbitView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class AirspaceBuilder
extends ApplicationTemplate {
    protected static final String AIRSPACE_LAYER_NAME = "Airspace Shapes";
    protected static final String CLEAR_SELECTION = "AirspaceBuilder.ClearSelection";
    protected static final String SIZE_NEW_SHAPES_TO_VIEWPORT = "AirspaceBuilder.SizeNewShapesToViewport";
    protected static final String ENABLE_EDIT = "AirspaceBuilder.EnableEdit";
    protected static final String OPEN = "AirspaceBuilder.Open";
    protected static final String OPEN_URL = "AirspaceBuilder.OpenUrl";
    protected static final String OPEN_DEMO_AIRSPACES = "AirspaceBuilder.OpenDemoAirspaces";
    protected static final String NEW_AIRSPACE = "AirspaceBuilder.NewAirspace";
    protected static final String REMOVE_SELECTED = "AirspaceBuilder.RemoveSelected";
    protected static final String SAVE = "AirspaceBuilder.Save";
    protected static final String SELECTION_CHANGED = "AirspaceBuilder.SelectionChanged";
    protected static final String DEMO_AIRSPACES_URL = "http://worldwind.arc.nasa.gov/java/demos/data/AirspaceBuilder-DemoShapes.zip";
    protected static AirspaceFactory[] defaultAirspaceFactories = new AirspaceFactory[]{new PolygonAirspaceFactory(), new SphereAirspaceFactory()};
    protected static final double DEFAULT_SHAPE_SIZE_METERS = 200000.0;
    private static long nextEntryNumber = 1L;

    public static AirspaceAttributes getDefaultAttributes() {
        BasicAirspaceAttributes basicAirspaceAttributes = new BasicAirspaceAttributes();
        basicAirspaceAttributes.setMaterial(new Material(Color.BLACK, Color.LIGHT_GRAY, Color.DARK_GRAY, Color.BLACK, 0.0f));
        basicAirspaceAttributes.setOutlineMaterial(Material.DARK_GRAY);
        basicAirspaceAttributes.setDrawOutline(true);
        basicAirspaceAttributes.setOpacity(0.95);
        basicAirspaceAttributes.setOutlineOpacity(0.95);
        basicAirspaceAttributes.setOutlineWidth(2.0);
        return basicAirspaceAttributes;
    }

    public static AirspaceAttributes getSelectionAttributes() {
        BasicAirspaceAttributes basicAirspaceAttributes = new BasicAirspaceAttributes();
        basicAirspaceAttributes.setMaterial(Material.WHITE);
        basicAirspaceAttributes.setOutlineMaterial(Material.BLACK);
        basicAirspaceAttributes.setDrawOutline(true);
        basicAirspaceAttributes.setOpacity(0.8);
        basicAirspaceAttributes.setOutlineOpacity(0.8);
        basicAirspaceAttributes.setOutlineWidth(2.0);
        return basicAirspaceAttributes;
    }

    public static AirspaceAttributes getIntersectionAttributes() {
        BasicAirspaceAttributes basicAirspaceAttributes = new BasicAirspaceAttributes();
        basicAirspaceAttributes.setMaterial(Material.RED);
        basicAirspaceAttributes.setOpacity(0.95);
        return basicAirspaceAttributes;
    }

    public static AirspaceAttributes getSelectionAndIntersectionAttributes() {
        BasicAirspaceAttributes basicAirspaceAttributes = new BasicAirspaceAttributes();
        basicAirspaceAttributes.setMaterial(Material.ORANGE);
        basicAirspaceAttributes.setOpacity(0.8);
        return basicAirspaceAttributes;
    }

    public static void setEditorAttributes(AirspaceEditor airspaceEditor) {
        airspaceEditor.setUseRubberBand(true);
        airspaceEditor.setKeepControlPointsAboveTerrain(true);
    }

    public static String getNextName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(nextEntryNumber++);
        return stringBuilder.toString();
    }

    private static AirspaceEditor getEditorFor(Airspace airspace) {
        if (airspace instanceof Polygon) {
            PolygonEditor polygonEditor = new PolygonEditor();
            polygonEditor.setPolygon((Polygon)airspace);
            AirspaceBuilder.setEditorAttributes(polygonEditor);
            return polygonEditor;
        }
        if (airspace instanceof SphereAirspace) {
            SphereAirspaceEditor sphereAirspaceEditor = new SphereAirspaceEditor();
            sphereAirspaceEditor.setSphere((SphereAirspace)airspace);
            AirspaceBuilder.setEditorAttributes(sphereAirspaceEditor);
            return sphereAirspaceEditor;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("Airspace Builder", AppFrame.class);
    }

    protected static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private AirspaceLayer airspaceLayer = new AirspaceLayer();
        private AirspaceBuilderModel builderModel;
        private AirspaceBuilderPanel builderView;
        private AirspaceBuilderController builderController;

        public AppFrame() {
            this.airspaceLayer.setName(AirspaceBuilder.AIRSPACE_LAYER_NAME);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), this.airspaceLayer);
            this.getLayerPanel().update(this.getWwd());
            this.builderController = new AirspaceBuilderController(this);
            this.builderModel = new AirspaceBuilderModel();
            this.builderView = new AirspaceBuilderPanel(this.builderModel, this.builderController);
            this.getContentPane().add((Component)this.builderView, "South");
            this.builderController.setModel(this.builderModel);
            this.builderController.setView(this.builderView);
            this.builderController.setResizeNewShapesToViewport(true);
            AppFrame.makeMenuBar(this, this.builderController);
        }

        public AirspaceBuilderPanel getAirspaceBuilderPanel() {
            return this.builderView;
        }

        public AirspaceLayer getAirspaceLayer() {
            return this.airspaceLayer;
        }

        public static void makeMenuBar(JFrame jFrame, final AirspaceBuilderController airspaceBuilderController) {
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            JMenuItem jMenuItem = new JMenuItem("Open...");
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            jMenuItem.setActionCommand(AirspaceBuilder.OPEN);
            jMenuItem.addActionListener(airspaceBuilderController);
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Open URL...");
            jMenuItem.setActionCommand(AirspaceBuilder.OPEN_URL);
            jMenuItem.addActionListener(airspaceBuilderController);
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Save...");
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            jMenuItem.setActionCommand(AirspaceBuilder.SAVE);
            jMenuItem.addActionListener(airspaceBuilderController);
            jMenu.add(jMenuItem);
            jMenu.addSeparator();
            jMenuItem = new JMenuItem("Load Demo Shapes");
            jMenuItem.setActionCommand(AirspaceBuilder.OPEN_DEMO_AIRSPACES);
            jMenuItem.addActionListener(airspaceBuilderController);
            jMenu.add(jMenuItem);
            jMenuBar.add(jMenu);
            jMenu = new JMenu("Shape");
            jMenuItem = new JMenu("New");
            for (final AirspaceFactory airspaceFactory : defaultAirspaceFactories) {
                JMenuItem jMenuItem2 = new JMenuItem(airspaceFactory.toString());
                jMenuItem2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        airspaceBuilderController.createNewEntry(airspaceFactory);
                    }
                });
                ((JMenu)jMenuItem).add(jMenuItem2);
            }
            jMenu.add(jMenuItem);
            final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Fit new shapes to viewport");
            jCheckBoxMenuItem.setActionCommand(AirspaceBuilder.SIZE_NEW_SHAPES_TO_VIEWPORT);
            jCheckBoxMenuItem.addActionListener(airspaceBuilderController);
            jCheckBoxMenuItem.setState(airspaceBuilderController.isResizeNewShapesToViewport());
            jMenu.add(jCheckBoxMenuItem);
            final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Enable shape editing");
            jCheckBoxMenuItem2.setActionCommand(AirspaceBuilder.ENABLE_EDIT);
            jCheckBoxMenuItem2.addActionListener(airspaceBuilderController);
            jCheckBoxMenuItem2.setState(airspaceBuilderController.isEnableEdit());
            jMenu.add(jCheckBoxMenuItem2);
            jMenuBar.add(jMenu);
            jMenu = new JMenu("Selection");
            jMenuItem = new JMenuItem("Deselect");
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            jMenuItem.setActionCommand(AirspaceBuilder.CLEAR_SELECTION);
            jMenuItem.addActionListener(airspaceBuilderController);
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Delete");
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
            jMenuItem.setActionCommand(AirspaceBuilder.REMOVE_SELECTED);
            jMenuItem.addActionListener(airspaceBuilderController);
            jMenu.add(jMenuItem);
            jMenuBar.add(jMenu);
            jFrame.setJMenuBar(jMenuBar);
            airspaceBuilderController.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName() == AirspaceBuilder.SIZE_NEW_SHAPES_TO_VIEWPORT) {
                        jCheckBoxMenuItem.setSelected(airspaceBuilderController.isResizeNewShapesToViewport());
                    } else if (propertyChangeEvent.getPropertyName() == AirspaceBuilder.ENABLE_EDIT) {
                        jCheckBoxMenuItem2.setSelected(airspaceBuilderController.isEnableEdit());
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AirspaceBuilderController
    extends WWObjectImpl
    implements ActionListener,
    MouseListener,
    AirspaceEditListener {
        private AppFrame app;
        private AirspaceBuilderModel model;
        private AirspaceBuilderPanel view;
        private AirspaceEntry selectedEntry;
        private AirspaceEditorController editorController;
        private boolean enabled = true;
        private boolean enableEdit = true;
        private boolean resizeNewShapes;
        private JFileChooser fileChooser;

        public AirspaceBuilderController(AppFrame appFrame) {
            this.app = appFrame;
            this.editorController = new AirspaceEditorController();
            this.editorController.setWorldWindow(this.app.getWwd());
            this.app.getWwd().getInputHandler().addMouseListener(this);
        }

        public AppFrame getApp() {
            return this.app;
        }

        public AirspaceBuilderModel getModel() {
            return this.model;
        }

        public void setModel(AirspaceBuilderModel airspaceBuilderModel) {
            this.model = airspaceBuilderModel;
        }

        public AirspaceBuilderPanel getView() {
            return this.view;
        }

        public void setView(AirspaceBuilderPanel airspaceBuilderPanel) {
            this.view = airspaceBuilderPanel;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
            this.getView().setEnabled(bl);
            this.getApp().setEnabled(bl);
        }

        public boolean isEnableEdit() {
            return this.enableEdit;
        }

        public void setEnableEdit(boolean bl) {
            this.enableEdit = bl;
            this.handleEnableEdit(bl);
            this.firePropertyChange(AirspaceBuilder.ENABLE_EDIT, null, bl);
        }

        public boolean isResizeNewShapesToViewport() {
            return this.resizeNewShapes;
        }

        public void setResizeNewShapesToViewport(boolean bl) {
            this.resizeNewShapes = bl;
            this.firePropertyChange(AirspaceBuilder.SIZE_NEW_SHAPES_TO_VIEWPORT, null, bl);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            if (actionEvent.getActionCommand() == AirspaceBuilder.NEW_AIRSPACE) {
                this.createNewEntry(this.getView().getSelectedFactory());
            } else if (actionEvent.getActionCommand() == AirspaceBuilder.CLEAR_SELECTION) {
                this.selectEntry(null, true);
            } else if (actionEvent.getActionCommand() == AirspaceBuilder.SIZE_NEW_SHAPES_TO_VIEWPORT) {
                if (actionEvent.getSource() instanceof AbstractButton) {
                    boolean bl = ((AbstractButton)actionEvent.getSource()).isSelected();
                    this.setResizeNewShapesToViewport(bl);
                }
            } else if (actionEvent.getActionCommand() == AirspaceBuilder.ENABLE_EDIT) {
                if (actionEvent.getSource() instanceof AbstractButton) {
                    boolean bl = ((AbstractButton)actionEvent.getSource()).isSelected();
                    this.setEnableEdit(bl);
                }
            } else if (actionEvent.getActionCommand() == AirspaceBuilder.OPEN) {
                this.openFromFile();
            } else if (actionEvent.getActionCommand() == AirspaceBuilder.OPEN_URL) {
                this.openFromURL();
            } else if (actionEvent.getActionCommand() == AirspaceBuilder.OPEN_DEMO_AIRSPACES) {
                URL uRL = null;
                try {
                    uRL = new URL(AirspaceBuilder.DEMO_AIRSPACES_URL);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                if (uRL != null) {
                    this.openFromURL(uRL);
                    this.zoomTo(LatLon.fromDegrees(47.6584074779224, -122.3059199579634), Angle.fromDegrees(-152.0), Angle.fromDegrees(75.0), 750.0);
                }
            } else if (actionEvent.getActionCommand() == AirspaceBuilder.REMOVE_SELECTED) {
                this.removeEntries(Arrays.asList(this.getSelectedEntries()));
            } else if (actionEvent.getActionCommand() == AirspaceBuilder.SAVE) {
                this.saveToFile();
            } else if (actionEvent.getActionCommand() == AirspaceBuilder.SELECTION_CHANGED) {
                this.viewSelectionChanged();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent == null || mouseEvent.isConsumed()) {
                return;
            }
            if (!this.isEnabled()) {
                return;
            }
            if (mouseEvent.getButton() == 1) {
                this.handleSelect();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void airspaceMoved(AirspaceEditEvent airspaceEditEvent) {
            this.updateShapeIntersection();
        }

        @Override
        public void airspaceResized(AirspaceEditEvent airspaceEditEvent) {
            this.updateShapeIntersection();
        }

        @Override
        public void controlPointAdded(AirspaceEditEvent airspaceEditEvent) {
        }

        @Override
        public void controlPointRemoved(AirspaceEditEvent airspaceEditEvent) {
        }

        @Override
        public void controlPointChanged(AirspaceEditEvent airspaceEditEvent) {
        }

        protected void handleSelect() {
            PickedObjectList pickedObjectList = this.getApp().getWwd().getObjectsAtCurrentPosition();
            Object object = pickedObjectList.getTopObject();
            if (!(object instanceof Airspace)) {
                return;
            }
            AirspaceEntry airspaceEntry = this.getEntryFor((Airspace)object);
            if (airspaceEntry == null) {
                return;
            }
            if (this.getSelectedEntry() != airspaceEntry) {
                this.selectEntry(airspaceEntry, true);
            }
        }

        protected void handleEnableEdit(boolean bl) {
            if (this.getSelectedEntry() == null) {
                return;
            }
            if (this.isSelectionEditing() != bl) {
                this.setSelectionEditing(bl);
            }
        }

        protected void updateShapeIntersection() {
            AirspaceEntry airspaceEntry = this.getSelectedEntry();
            if (airspaceEntry != null) {
                boolean bl = false;
                for (AirspaceEntry airspaceEntry2 : this.getModel().getEntries()) {
                    if (airspaceEntry2 == airspaceEntry) continue;
                    boolean bl2 = this.areShapesIntersecting(airspaceEntry2.getAirspace(), airspaceEntry.getAirspace());
                    if (bl2) {
                        bl = true;
                    }
                    airspaceEntry2.setIntersecting(bl2);
                }
                airspaceEntry.setIntersecting(bl);
            } else {
                for (AirspaceEntry airspaceEntry3 : this.getModel().getEntries()) {
                    airspaceEntry3.setIntersecting(false);
                }
            }
        }

        protected boolean areShapesIntersecting(Airspace airspace, Airspace airspace2) {
            if (airspace instanceof SphereAirspace && airspace2 instanceof SphereAirspace) {
                SphereAirspace sphereAirspace = (SphereAirspace)airspace;
                SphereAirspace sphereAirspace2 = (SphereAirspace)airspace2;
                LatLon latLon = sphereAirspace.getLocation();
                LatLon latLon2 = sphereAirspace2.getLocation();
                double d = sphereAirspace.getAltitudes()[0];
                double d2 = sphereAirspace2.getAltitudes()[0];
                boolean bl = sphereAirspace.isTerrainConforming()[0];
                boolean bl2 = sphereAirspace2.isTerrainConforming()[0];
                Vec4 vec4 = bl ? this.getSurfacePoint(latLon, d) : this.getPoint(latLon, d);
                Vec4 vec42 = bl2 ? this.getSurfacePoint(latLon2, d2) : this.getPoint(latLon2, d2);
                double d3 = sphereAirspace.getRadius();
                double d4 = sphereAirspace2.getRadius();
                double d5 = vec4.distanceTo3(vec42);
                return d5 <= d3 + d4;
            }
            return false;
        }

        protected Vec4 getSurfacePoint(LatLon latLon, double d) {
            Vec4 vec4 = null;
            SceneController sceneController = this.getApp().getWwd().getSceneController();
            Globe globe = this.getApp().getWwd().getModel().getGlobe();
            if (sceneController.getTerrain() != null) {
                vec4 = sceneController.getTerrain().getSurfacePoint(latLon.getLatitude(), latLon.getLongitude(), d * sceneController.getVerticalExaggeration());
            }
            if (vec4 == null) {
                double d2 = globe.getElevation(latLon.getLatitude(), latLon.getLongitude());
                vec4 = globe.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), (d2 + d) * sceneController.getVerticalExaggeration());
            }
            return vec4;
        }

        protected Vec4 getPoint(LatLon latLon, double d) {
            SceneController sceneController = this.getApp().getWwd().getSceneController();
            Globe globe = this.getApp().getWwd().getModel().getGlobe();
            double d2 = globe.getElevation(latLon.getLatitude(), latLon.getLongitude());
            return globe.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), (d2 + d) * sceneController.getVerticalExaggeration());
        }

        public void createNewEntry(AirspaceFactory airspaceFactory) {
            Airspace airspace = airspaceFactory.createAirspace(this.getApp().getWwd(), this.isResizeNewShapesToViewport());
            AirspaceEditor airspaceEditor = airspaceFactory.createEditor(airspace);
            AirspaceEntry airspaceEntry = new AirspaceEntry(airspace, airspaceEditor);
            this.addEntry(airspaceEntry);
            this.selectEntry(airspaceEntry, true);
        }

        public void removeEntries(Iterable<? extends AirspaceEntry> iterable) {
            if (iterable != null) {
                for (AirspaceEntry airspaceEntry : iterable) {
                    this.removeEntry(airspaceEntry);
                }
            }
        }

        public void addEntry(AirspaceEntry airspaceEntry) {
            airspaceEntry.getEditor().addEditListener(this);
            this.getModel().addEntry(airspaceEntry);
            this.updateShapeIntersection();
            this.getApp().getAirspaceLayer().addAirspace(airspaceEntry.getAirspace());
            this.getApp().getWwd().redraw();
        }

        public void removeEntry(AirspaceEntry airspaceEntry) {
            airspaceEntry.getEditor().removeEditListener(this);
            if (this.getSelectedEntry() == airspaceEntry) {
                this.selectEntry(null, true);
            }
            this.getModel().removeEntry(airspaceEntry);
            this.updateShapeIntersection();
            this.getApp().getAirspaceLayer().removeAirspace(airspaceEntry.getAirspace());
            this.getApp().getWwd().redraw();
        }

        public AirspaceEntry getSelectedEntry() {
            return this.selectedEntry;
        }

        public void selectEntry(AirspaceEntry airspaceEntry, boolean bl) {
            this.setSelectedEntry(airspaceEntry);
            if (bl) {
                if (airspaceEntry != null) {
                    int n = this.getModel().getIndexForEntry(airspaceEntry);
                    this.getView().setSelectedIndices(new int[]{n});
                } else {
                    this.getView().setSelectedIndices(new int[0]);
                }
            }
            if (this.isEnableEdit() && this.getSelectedEntry() != null && !this.isSelectionEditing()) {
                this.setSelectionEditing(true);
            }
            this.updateShapeIntersection();
            this.getApp().getWwd().redraw();
        }

        protected void setSelectedEntry(AirspaceEntry airspaceEntry) {
            if (this.selectedEntry != null) {
                if (this.selectedEntry != airspaceEntry && this.selectedEntry.isEditing()) {
                    this.setSelectionEditing(false);
                }
                this.selectedEntry.setSelected(false);
            }
            this.selectedEntry = airspaceEntry;
            if (this.selectedEntry != null) {
                this.selectedEntry.setSelected(true);
            }
        }

        protected boolean isSelectionEditing() {
            return this.selectedEntry != null && this.selectedEntry.isEditing();
        }

        protected void setSelectionEditing(boolean bl) {
            if (this.selectedEntry == null) {
                throw new IllegalStateException();
            }
            if (this.selectedEntry.isEditing() == bl) {
                throw new IllegalStateException();
            }
            this.selectedEntry.setEditing(bl);
            AirspaceEditor airspaceEditor = this.selectedEntry.getEditor();
            airspaceEditor.setArmed(bl);
            if (bl) {
                this.editorController.setEditor(airspaceEditor);
                ApplicationTemplate.insertBeforePlacenames(this.getApp().getWwd(), airspaceEditor);
            } else {
                this.editorController.setEditor(null);
                this.getApp().getWwd().getModel().getLayers().remove(airspaceEditor);
            }
            int n = this.getModel().getIndexForEntry(this.selectedEntry);
            this.getModel().fireTableRowsUpdated(n, n);
        }

        protected void viewSelectionChanged() {
            int[] nArray = this.getView().getSelectedIndices();
            if (nArray != null) {
                for (AirspaceEntry airspaceEntry : this.getEntriesFor(nArray)) {
                    this.selectEntry(airspaceEntry, false);
                }
            }
            this.getApp().getWwd().redraw();
        }

        protected AirspaceEntry[] getSelectedEntries() {
            int[] nArray = this.getView().getSelectedIndices();
            if (nArray != null) {
                return this.getEntriesFor(nArray);
            }
            return new AirspaceEntry[0];
        }

        protected AirspaceEntry[] getEntriesFor(int[] nArray) {
            AirspaceEntry[] airspaceEntryArray = new AirspaceEntry[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                airspaceEntryArray[i] = this.getModel().getEntry(nArray[i]);
            }
            return airspaceEntryArray;
        }

        protected AirspaceEntry getEntryFor(Airspace airspace) {
            for (AirspaceEntry airspaceEntry : this.getModel().getEntries()) {
                if (airspaceEntry.getAirspace() != airspace) continue;
                return airspaceEntry;
            }
            return null;
        }

        protected void zoomTo(LatLon latLon, Angle angle, Angle angle2, double d) {
            OrbitView orbitView = (OrbitView)this.getApp().getWwd().getView();
            Globe globe = this.getApp().getWwd().getModel().getGlobe();
            FlyToOrbitViewStateIterator flyToOrbitViewStateIterator = FlyToOrbitViewStateIterator.createPanToIterator(orbitView, globe, new Position(latLon, 0.0), angle, angle2, d, true);
            orbitView.stopMovement();
            orbitView.applyStateIterator(flyToOrbitViewStateIterator);
        }

        protected void openFromURL() {
            Object object = JOptionPane.showInputDialog(this.getApp(), "Enter a URL: ", "Open Shapes from URL", 3, null, null, null);
            if (object == null) {
                return;
            }
            URL uRL = null;
            try {
                uRL = new URL(object.toString());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (uRL != null) {
                this.openFromURL(uRL);
            }
        }

        protected void openFromURL(final URL uRL) {
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ArrayList<Airspace> arrayList = new ArrayList<Airspace>();
                    try {
                        AirspaceBuilderController.this.loadAirspacesFromURL(uRL, arrayList);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(arrayList){
                            final /* synthetic */ ArrayList val$airspaces;
                            {
                                this.val$airspaces = arrayList;
                            }

                            public void run() {
                                AirspaceBuilderController.this.setAirspaces(this.val$airspaces);
                                AirspaceBuilderController.this.setEnabled(true);
                                AirspaceBuilderController.this.getApp().setCursor(null);
                                AirspaceBuilderController.this.getApp().getWwd().redraw();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
            this.setEnabled(false);
            this.getApp().setCursor(new Cursor(3));
            thread.start();
        }

        protected void loadAirspacesFromURL(URL uRL, Collection<Airspace> collection) {
            Object object;
            Object object2;
            Closeable closeable;
            File file = null;
            try {
                int n;
                file = File.createTempFile("AirspaceBuilder-TempFile", null);
                closeable = uRL.openStream();
                object2 = new FileOutputStream(file);
                object = new byte[4096];
                while ((n = ((InputStream)closeable).read((byte[])object)) > 0) {
                    ((OutputStream)object2).write((byte[])object, 0, n);
                }
                ((InputStream)closeable).close();
                ((OutputStream)object2).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (file == null) {
                return;
            }
            try {
                closeable = new ZipFile(file);
                object2 = null;
                object = ((ZipFile)closeable).entries();
                while (object.hasMoreElements()) {
                    if (object2 != null) {
                        String string = ((ZipEntry)object2).getName();
                        if ((string = this.getFileName(string)).startsWith("gov.nasa.worldwind.render.airspaces") && string.endsWith(".xml")) {
                            String[] stringArray = string.split("-");
                            try {
                                Class<?> clazz = Class.forName(stringArray[0]);
                                Airspace airspace = (Airspace)clazz.newInstance();
                                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((ZipFile)closeable).getInputStream((ZipEntry)object2)));
                                String string2 = bufferedReader.readLine();
                                airspace.restoreState(string2);
                                collection.add(airspace);
                                if (stringArray.length >= 2) {
                                    airspace.setValue("gov.nasa.worldwind.avkey.DisplayName", stringArray[1]);
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                    object2 = (ZipEntry)object.nextElement();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        protected void openFromFile() {
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser();
                this.fileChooser.setCurrentDirectory(new File(Configuration.getUserHomeDirectory()));
            }
            this.fileChooser.setDialogTitle("Choose Airspace File Directory");
            this.fileChooser.setFileSelectionMode(1);
            this.fileChooser.setMultiSelectionEnabled(false);
            int n = this.fileChooser.showOpenDialog(null);
            if (n != 0) {
                return;
            }
            final File file = this.fileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ArrayList<Airspace> arrayList = new ArrayList<Airspace>();
                    try {
                        File[] fileArray;
                        for (File file2 : fileArray = file.listFiles(new FilenameFilter(){

                            public boolean accept(File file, String string) {
                                return string.startsWith("gov.nasa.worldwind.render.airspaces") && string.endsWith(".xml");
                            }
                        })) {
                            String[] stringArray = file2.getName().split("-");
                            try {
                                Class<?> clazz = Class.forName(stringArray[0]);
                                Airspace airspace = (Airspace)clazz.newInstance();
                                BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
                                String string = bufferedReader.readLine();
                                airspace.restoreState(string);
                                arrayList.add(airspace);
                                if (stringArray.length < 2) continue;
                                airspace.setValue("gov.nasa.worldwind.avkey.DisplayName", stringArray[1]);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(arrayList){
                            final /* synthetic */ ArrayList val$airspaces;
                            {
                                this.val$airspaces = arrayList;
                            }

                            public void run() {
                                AirspaceBuilderController.this.setAirspaces(this.val$airspaces);
                                AirspaceBuilderController.this.setEnabled(true);
                                AirspaceBuilderController.this.getApp().setCursor(null);
                                AirspaceBuilderController.this.getApp().getWwd().redraw();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
            this.setEnabled(false);
            this.getApp().setCursor(new Cursor(3));
            thread.start();
        }

        protected void saveToFile() {
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser();
                this.fileChooser.setCurrentDirectory(new File(Configuration.getUserHomeDirectory()));
            }
            this.fileChooser.setDialogTitle("Choose Directory to Place Airspaces");
            this.fileChooser.setFileSelectionMode(1);
            this.fileChooser.setMultiSelectionEnabled(false);
            int n = this.fileChooser.showSaveDialog(null);
            if (n != 0) {
                return;
            }
            final File file = this.fileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            if (file.exists()) {
                try {
                    WWIO.deleteDirectory(file);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (!file.exists()) {
                file.mkdirs();
            }
            final List<AirspaceEntry> list = this.getModel().getEntries();
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        DecimalFormat decimalFormat = new DecimalFormat("####");
                        decimalFormat.setMinimumIntegerDigits(4);
                        int n = 0;
                        for (AirspaceEntry airspaceEntry : list) {
                            Airspace airspace = airspaceEntry.getAirspace();
                            AirspaceAttributes airspaceAttributes = airspace.getAttributes();
                            airspace.setAttributes(airspaceEntry.getAttributes());
                            String string = airspace.getRestorableState();
                            if (string != null) {
                                try {
                                    PrintWriter printWriter = new PrintWriter(new File(file, airspace.getClass().getName() + "-" + airspaceEntry.getName() + "-" + decimalFormat.format(n++) + ".xml"));
                                    printWriter.write(string);
                                    printWriter.flush();
                                    printWriter.close();
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            airspace.setAttributes(airspaceAttributes);
                        }
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                AirspaceBuilderController.this.setEnabled(true);
                                AirspaceBuilderController.this.getApp().setCursor(null);
                                AirspaceBuilderController.this.getApp().getWwd().redraw();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
            this.setEnabled(false);
            this.getApp().setCursor(new Cursor(3));
            thread.start();
        }

        private void setAirspaces(Iterable<? extends Airspace> iterable) {
            ArrayList<AirspaceEntry> arrayList = new ArrayList<AirspaceEntry>(this.getModel().getEntries());
            this.removeEntries(arrayList);
            for (Airspace airspace : iterable) {
                airspace.setAttributes(AirspaceBuilder.getDefaultAttributes());
                AirspaceEntry airspaceEntry = new AirspaceEntry(airspace, AirspaceBuilder.getEditorFor(airspace));
                this.addEntry(airspaceEntry);
            }
        }

        private String getFileName(String string) {
            int n = string.lastIndexOf("/");
            if (n == -1) {
                n = string.lastIndexOf("\\");
            }
            if (n != -1 && n < string.length()) {
                return string.substring(n + 1, string.length());
            }
            return string;
        }
    }

    protected static class AirspaceBuilderPanel
    extends JPanel {
        private JComboBox factoryComboBox;
        private JTable entryTable;
        private boolean ignoreSelectEvents = false;

        public AirspaceBuilderPanel(AirspaceBuilderModel airspaceBuilderModel, AirspaceBuilderController airspaceBuilderController) {
            this.initComponents(airspaceBuilderModel, airspaceBuilderController);
        }

        public int[] getSelectedIndices() {
            return this.entryTable.getSelectedRows();
        }

        public void setSelectedIndices(int[] nArray) {
            this.ignoreSelectEvents = true;
            if (nArray != null && nArray.length != 0) {
                for (int n : nArray) {
                    this.entryTable.setRowSelectionInterval(n, n);
                }
            } else {
                this.entryTable.clearSelection();
            }
            this.ignoreSelectEvents = false;
        }

        public AirspaceFactory getSelectedFactory() {
            return (AirspaceFactory)this.factoryComboBox.getSelectedItem();
        }

        public void setSelectedFactory(AirspaceFactory airspaceFactory) {
            this.factoryComboBox.setSelectedItem(airspaceFactory);
        }

        private void initComponents(AirspaceBuilderModel airspaceBuilderModel, final AirspaceBuilderController airspaceBuilderController) {
            JPanel jPanel = new JPanel();
            JComponent jComponent = new JButton("New shape");
            ((AbstractButton)jComponent).setActionCommand(AirspaceBuilder.NEW_AIRSPACE);
            ((AbstractButton)jComponent).addActionListener(airspaceBuilderController);
            jComponent.setToolTipText("Create a new shape centered in the viewport");
            this.factoryComboBox = new JComboBox<AirspaceFactory>(defaultAirspaceFactories);
            this.factoryComboBox.setEditable(false);
            this.factoryComboBox.setToolTipText("Choose shape type to create");
            final JCheckBox jCheckBox = new JCheckBox("Fit new shapes to viewport");
            jCheckBox.setActionCommand(AirspaceBuilder.SIZE_NEW_SHAPES_TO_VIEWPORT);
            jCheckBox.addActionListener(airspaceBuilderController);
            jCheckBox.setSelected(airspaceBuilderController.isResizeNewShapesToViewport());
            jCheckBox.setAlignmentX(0.0f);
            jCheckBox.setToolTipText("New shapes are sized to fit the geographic viewport");
            final JCheckBox jCheckBox2 = new JCheckBox("Enable shape editing");
            jCheckBox2.setActionCommand(AirspaceBuilder.ENABLE_EDIT);
            jCheckBox2.addActionListener(airspaceBuilderController);
            jCheckBox2.setSelected(airspaceBuilderController.isEnableEdit());
            jCheckBox2.setAlignmentX(0.0f);
            jCheckBox2.setToolTipText("Allow modifications to shapes");
            JComponent jComponent2 = Box.createHorizontalBox();
            jComponent2.add(jComponent);
            jComponent2.add(Box.createHorizontalStrut(5));
            jComponent2.add(this.factoryComboBox);
            jComponent2.setAlignmentX(0.0f);
            JComponent jComponent3 = new JPanel(new GridLayout(0, 1, 0, 5));
            jComponent3.add(jComponent2);
            jComponent3.add(jCheckBox);
            jComponent3.add(jCheckBox2);
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)jComponent3, "North");
            jComponent = new JPanel();
            this.entryTable = new JTable(airspaceBuilderModel);
            this.entryTable.setColumnSelectionAllowed(false);
            this.entryTable.setRowSelectionAllowed(true);
            this.entryTable.setSelectionMode(0);
            this.entryTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!AirspaceBuilderPanel.this.ignoreSelectEvents) {
                        airspaceBuilderController.actionPerformed(new ActionEvent(listSelectionEvent.getSource(), -1, AirspaceBuilder.SELECTION_CHANGED));
                    }
                }
            });
            this.entryTable.setToolTipText("<html>Click to select<br>Double-Click to rename</html>");
            jComponent2 = new JScrollPane(this.entryTable);
            jComponent2.setPreferredSize(new Dimension(200, 100));
            jComponent.setLayout(new BorderLayout(0, 0));
            jComponent.add((Component)jComponent2, "Center");
            jComponent2 = new JPanel();
            jComponent3 = new JButton("Deselect");
            ((AbstractButton)jComponent3).setActionCommand(AirspaceBuilder.CLEAR_SELECTION);
            ((AbstractButton)jComponent3).addActionListener(airspaceBuilderController);
            jComponent3.setToolTipText("Clear the selection");
            JButton jButton = new JButton("Delete Selected");
            jButton.setActionCommand(AirspaceBuilder.REMOVE_SELECTED);
            jButton.addActionListener(airspaceBuilderController);
            jButton.setToolTipText("Delete selected shapes");
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 5));
            jPanel2.add(jComponent3);
            jPanel2.add(jButton);
            jComponent2.setLayout(new BorderLayout());
            jComponent2.add((Component)jPanel2, "North");
            this.setLayout(new BorderLayout(30, 0));
            this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            this.add((Component)jPanel, "West");
            this.add((Component)jComponent, "Center");
            this.add((Component)jComponent2, "East");
            airspaceBuilderController.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName() == AirspaceBuilder.SIZE_NEW_SHAPES_TO_VIEWPORT) {
                        jCheckBox.setSelected(airspaceBuilderController.isResizeNewShapesToViewport());
                    } else if (propertyChangeEvent.getPropertyName() == AirspaceBuilder.ENABLE_EDIT) {
                        jCheckBox2.setSelected(airspaceBuilderController.isEnableEdit());
                    }
                }
            });
        }
    }

    protected static class SphereAirspaceFactory
    implements AirspaceFactory {
        public Airspace createAirspace(WorldWindow worldWindow, boolean bl) {
            SphereAirspace sphereAirspace = new SphereAirspace();
            sphereAirspace.setAttributes(AirspaceBuilder.getDefaultAttributes());
            sphereAirspace.setValue("gov.nasa.worldwind.avkey.DisplayName", AirspaceBuilder.getNextName(this.toString()));
            sphereAirspace.setAltitude(0.0);
            sphereAirspace.setTerrainConforming(true);
            this.initializeSphere(worldWindow, sphereAirspace, bl);
            return sphereAirspace;
        }

        public AirspaceEditor createEditor(Airspace airspace) {
            SphereAirspaceEditor sphereAirspaceEditor = new SphereAirspaceEditor();
            sphereAirspaceEditor.setSphere((SphereAirspace)airspace);
            AirspaceBuilder.setEditorAttributes(sphereAirspaceEditor);
            return sphereAirspaceEditor;
        }

        protected void initializeSphere(WorldWindow worldWindow, SphereAirspace sphereAirspace, boolean bl) {
            Position position = ShapeUtils.getNewShapePosition(worldWindow);
            double d = bl ? ShapeUtils.getViewportScaleFactor(worldWindow) : 200000.0;
            sphereAirspace.setLocation(new LatLon(position));
            sphereAirspace.setRadius(d / 2.0);
        }

        public String toString() {
            return "Sphere";
        }
    }

    protected static class PolygonAirspaceFactory
    implements AirspaceFactory {
        public Airspace createAirspace(WorldWindow worldWindow, boolean bl) {
            Polygon polygon = new Polygon();
            polygon.setAttributes(AirspaceBuilder.getDefaultAttributes());
            polygon.setValue("gov.nasa.worldwind.avkey.DisplayName", AirspaceBuilder.getNextName(this.toString()));
            polygon.setAltitudes(0.0, 0.0);
            polygon.setTerrainConforming(true, false);
            this.initializePolygon(worldWindow, polygon, bl);
            return polygon;
        }

        public AirspaceEditor createEditor(Airspace airspace) {
            PolygonEditor polygonEditor = new PolygonEditor();
            polygonEditor.setPolygon((Polygon)airspace);
            AirspaceBuilder.setEditorAttributes(polygonEditor);
            return polygonEditor;
        }

        protected void initializePolygon(WorldWindow worldWindow, Polygon polygon, boolean bl) {
            Position position = ShapeUtils.getNewShapePosition(worldWindow);
            Angle angle = ShapeUtils.getNewShapeHeading(worldWindow, true);
            double d = bl ? ShapeUtils.getViewportScaleFactor(worldWindow) : 200000.0;
            List<LatLon> list = ShapeUtils.createSquareInViewport(worldWindow, position, angle, d);
            double d2 = -1.7976931348623157E308;
            Globe globe = worldWindow.getModel().getGlobe();
            for (LatLon latLon : list) {
                double d3 = globe.getElevation(latLon.getLatitude(), latLon.getLongitude());
                if (!(d3 > d2)) continue;
                d2 = d3;
            }
            polygon.setAltitudes(0.0, d2 + d);
            polygon.setTerrainConforming(true, false);
            polygon.setLocations(list);
        }

        public String toString() {
            return "Polygon";
        }
    }

    protected static interface AirspaceFactory {
        public Airspace createAirspace(WorldWindow var1, boolean var2);

        public AirspaceEditor createEditor(Airspace var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AirspaceBuilderModel
    extends AbstractTableModel {
        private static String[] columnName = new String[]{"Name"};
        private static Class[] columnClass = new Class[]{String.class};
        private static String[] columnAttribute = new String[]{"gov.nasa.worldwind.avkey.DisplayName"};
        private ArrayList<AirspaceEntry> entryList = new ArrayList();

        @Override
        public String getColumnName(int n) {
            return columnName[n];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return columnClass[n];
        }

        @Override
        public int getRowCount() {
            return this.entryList.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            AirspaceEntry airspaceEntry = this.entryList.get(n);
            return airspaceEntry.getValue(columnAttribute[n2]);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            AirspaceEntry airspaceEntry = this.entryList.get(n);
            String string = columnAttribute[n2];
            airspaceEntry.setValue(string, object);
        }

        public List<AirspaceEntry> getEntries() {
            return Collections.unmodifiableList(this.entryList);
        }

        public void setEntries(Iterable<? extends AirspaceEntry> iterable) {
            this.entryList.clear();
            if (iterable != null) {
                for (AirspaceEntry airspaceEntry : iterable) {
                    this.entryList.add(airspaceEntry);
                }
            }
            this.fireTableDataChanged();
        }

        public void addEntry(AirspaceEntry airspaceEntry) {
            this.entryList.add(airspaceEntry);
            int n = this.entryList.size() - 1;
            this.fireTableRowsInserted(n, n);
        }

        public void removeEntry(AirspaceEntry airspaceEntry) {
            int n = this.entryList.indexOf(airspaceEntry);
            if (n != -1) {
                this.entryList.remove(airspaceEntry);
                this.fireTableRowsDeleted(n, n);
            }
        }

        public void removeAllEntries() {
            this.entryList.clear();
            this.fireTableDataChanged();
        }

        public AirspaceEntry getEntry(int n) {
            return this.entryList.get(n);
        }

        public AirspaceEntry setEntry(int n, AirspaceEntry airspaceEntry) {
            return this.entryList.set(n, airspaceEntry);
        }

        public int getIndexForEntry(AirspaceEntry airspaceEntry) {
            return this.entryList.indexOf(airspaceEntry);
        }
    }

    protected static class AirspaceEntry
    extends WWObjectImpl {
        private Airspace airspace;
        private AirspaceEditor editor;
        private AirspaceAttributes attributes;
        private boolean editing = false;
        private boolean selected = false;
        private boolean intersecting = false;

        public AirspaceEntry(Airspace airspace, AirspaceEditor airspaceEditor) {
            this.airspace = airspace;
            this.editor = airspaceEditor;
            this.attributes = this.airspace.getAttributes();
        }

        public boolean isEditing() {
            return this.editing;
        }

        public void setEditing(boolean bl) {
            this.editing = bl;
            this.updateAttributes();
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
            this.updateAttributes();
        }

        public boolean isIntersecting() {
            return this.intersecting;
        }

        public void setIntersecting(boolean bl) {
            this.intersecting = bl;
            this.updateAttributes();
        }

        public String getName() {
            return this.getStringValue("gov.nasa.worldwind.avkey.DisplayName");
        }

        public void setName(String string) {
            this.setValue("gov.nasa.worldwind.avkey.DisplayName", string);
        }

        public Airspace getAirspace() {
            return this.airspace;
        }

        public AirspaceEditor getEditor() {
            return this.editor;
        }

        public AirspaceAttributes getAttributes() {
            return this.attributes;
        }

        public String toString() {
            return this.getName();
        }

        public Object getValue(String string) {
            Object object = super.getValue(string);
            if (object == null) {
                object = this.airspace.getValue(string);
            }
            return object;
        }

        public Object setValue(String string, Object object) {
            if (string == "gov.nasa.worldwind.avkey.DisplayName") {
                return this.airspace.setValue(string, object);
            }
            return super.setValue(string, object);
        }

        protected void updateAttributes() {
            if (this.isSelected() && this.isIntersecting()) {
                this.airspace.setAttributes(AirspaceBuilder.getSelectionAndIntersectionAttributes());
            } else if (this.isSelected()) {
                this.airspace.setAttributes(AirspaceBuilder.getSelectionAttributes());
            } else if (this.isIntersecting()) {
                this.airspace.setAttributes(AirspaceBuilder.getIntersectionAttributes());
            } else {
                this.airspace.setAttributes(this.getAttributes());
            }
        }
    }
}

