/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.layers.Earth.BMNGOneImage;
import gov.nasa.worldwind.layers.Earth.BMNGSurfaceLayer;
import gov.nasa.worldwind.layers.Earth.BMNGWMSLayer;
import gov.nasa.worldwind.layers.Earth.EarthNASAPlaceNameLayer;
import gov.nasa.worldwind.layers.Earth.NASAWFSPlaceNameLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.RenderableLayer;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BMNGTwelveMonth
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Blue Marble Twelve Month 2004", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private static final String BMNG_BASE_URL = "http://worldwind28.arc.nasa.gov/public/world.topo.bathy.";
        private static final String BMNG_IMAGE_SUFFIX = ".jpg";
        private static final int DEFAULT_ANIMATION_DELAY = 5000;
        private static final int REDRAW_TIMER_DELAY = 500;
        private Layer[] BMNGBaseLayers;
        private Layer[] BMNGTiledLayers;
        private int baseLayerID = -1;
        private int tiledLayerID = -1;
        private int month = 5;
        private Timer monthAnimator;
        private JSlider monthSlider;
        private Timer redrawTimer;

        public AppFrame() {
            super(true, true, false);
            int n;
            LayerList layerList = this.getWwd().getModel().getLayers();
            for (n = 0; n < layerList.size(); ++n) {
                if (layerList.get(n) instanceof BMNGOneImage) {
                    this.baseLayerID = n;
                    continue;
                }
                if (layerList.get(n) instanceof BMNGSurfaceLayer || layerList.get(n) instanceof BMNGWMSLayer) {
                    this.tiledLayerID = n;
                    continue;
                }
                if (!(layerList.get(n) instanceof EarthNASAPlaceNameLayer) && !(layerList.get(n) instanceof NASAWFSPlaceNameLayer)) continue;
                ((Layer)layerList.get(n)).setEnabled(false);
            }
            this.BMNGBaseLayers = new Layer[12];
            this.BMNGTiledLayers = new Layer[12];
            for (n = 1; n <= 12; ++n) {
                BMNGWMSLayer bMNGWMSLayer = new BMNGWMSLayer(n);
                bMNGWMSLayer.setMaxActiveAltitude(1.0E7);
                this.BMNGTiledLayers[n - 1] = bMNGWMSLayer;
                RenderableLayer renderableLayer = new RenderableLayer();
                renderableLayer.setName("BMNG Base " + String.format("%02d-2004", n));
                renderableLayer.setPickEnabled(false);
                this.BMNGBaseLayers[n - 1] = renderableLayer;
            }
            this.update();
            this.monthAnimator = new Timer(5000, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.monthSlider.setValue(AppFrame.this.month < 12 ? AppFrame.this.month + 1 : 1);
                }
            });
            this.monthAnimator.setInitialDelay(0);
            this.redrawTimer = new Timer(500, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.getWwd().redraw();
                }
            });
            this.redrawTimer.start();
            this.getLayerPanel().add((Component)this.makeControlPanel(), "South");
        }

        private JPanel makeControlPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            JPanel jPanel2 = new JPanel(new GridLayout(0, 2, 0, 0));
            jPanel2.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            jPanel2.add(new JLabel("Month:"));
            JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel3.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            this.monthSlider = new JSlider(1, 12, 5);
            this.monthSlider.setPaintTicks(true);
            this.monthSlider.setPaintLabels(true);
            this.monthSlider.setMajorTickSpacing(1);
            this.monthSlider.setSnapToTicks(true);
            this.monthSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    AppFrame.this.month = AppFrame.this.monthSlider.getValue();
                    AppFrame.this.update();
                }
            });
            jPanel3.add(this.monthSlider);
            JPanel jPanel4 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel4.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            final JButton jButton = new JButton("Animate");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.monthAnimator.isRunning()) {
                        AppFrame.this.monthAnimator.stop();
                        jButton.setText("Animate");
                    } else {
                        AppFrame.this.monthAnimator.start();
                        jButton.setText("Stop");
                    }
                }
            });
            jPanel4.add(jButton);
            JPanel jPanel5 = new JPanel();
            jPanel5.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            jPanel5.setLayout(new BoxLayout(jPanel5, 0));
            jPanel5.add(new JLabel("Speed:"));
            final JSlider jSlider = new JSlider(0, 10, 2);
            jSlider.setPaintTicks(true);
            jSlider.setPaintLabels(true);
            jSlider.setMajorTickSpacing(1);
            double d = (double)jSlider.getMaximum() - 0.8166666666666667 * (double)jSlider.getMaximum();
            jSlider.setValue((int)d);
            jSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    double d = (double)(jSlider.getMaximum() - jSlider.getValue()) / (double)jSlider.getMaximum() * 6000.0 + 100.0;
                    AppFrame.this.monthAnimator.setDelay((int)d);
                }
            });
            jPanel5.add(jSlider);
            JPanel jPanel6 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel6.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            JLabel jLabel = new JLabel("Tip: go through the twelve month once");
            jLabel.setAlignmentX(0.0f);
            JLabel jLabel2 = new JLabel("before increasing speed.");
            jLabel2.setAlignmentX(0.0f);
            jPanel6.add(jLabel);
            jPanel6.add(jLabel2);
            jPanel.add(jPanel2);
            jPanel.add(jPanel3);
            jPanel.add(jPanel4);
            jPanel.add(jPanel5);
            jPanel.add(jPanel6);
            jPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Blue Marble Next Generation 2004")));
            jPanel.setToolTipText("Set the current BMNG month");
            return jPanel;
        }

        private void update() {
            LayerList layerList = this.getWwd().getModel().getLayers();
            layerList.remove(this.tiledLayerID);
            layerList.remove(this.baseLayerID);
            layerList.add(this.baseLayerID, this.BMNGBaseLayers[this.month - 1]);
            layerList.add(this.tiledLayerID, this.BMNGTiledLayers[this.month - 1]);
            this.getLayerPanel().update(this.getWwd());
            this.getWwd().redraw();
        }
    }
}

