/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.examples.util.SectorSelector;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.retrieve.BulkRetrievable;
import gov.nasa.worldwind.retrieve.BulkRetrievalThread;
import gov.nasa.worldwind.retrieve.Progress;
import gov.nasa.worldwind.terrain.CompoundElevationModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class BulkDownload
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Layer Download", AppFrame.class);
    }

    public static class DownloadMonitorPanel
    extends JPanel {
        private BulkRetrievalThread thread;
        private Progress progress;
        private Timer updateTimer;
        private JLabel descriptionLabel;
        private JProgressBar progressBar;
        private JButton cancelButton;

        public DownloadMonitorPanel(BulkRetrievalThread bulkRetrievalThread) {
            this.thread = bulkRetrievalThread;
            this.progress = bulkRetrievalThread.getProgress();
            this.initComponents();
            this.updateTimer = new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DownloadMonitorPanel.this.updateStatus();
                }
            });
            this.updateTimer.start();
        }

        private void updateStatus() {
            String string = this.thread.getRetrievable().getName();
            string = string.length() > 30 ? string.substring(0, 27) + "..." : string;
            string = string + " (" + BulkDownloadPanel.makeSizeDescription(this.progress.getCurrentSize()) + " / " + BulkDownloadPanel.makeSizeDescription(this.progress.getTotalSize()) + ")";
            this.descriptionLabel.setText(string);
            int n = 0;
            if (this.progress.getTotalCount() > 0) {
                n = (int)((float)this.progress.getCurrentCount() / (float)this.progress.getTotalCount() * 100.0f);
            }
            this.progressBar.setValue(Math.min(n, 100));
            String string2 = BulkDownloadPanel.makeSectorDescription(this.thread.getSector());
            this.descriptionLabel.setToolTipText(string2);
            this.progressBar.setToolTipText(this.makeProgressDescription());
            if (!this.thread.isAlive()) {
                this.cancelButton.setText("Remove");
                this.cancelButton.setBackground(Color.GREEN);
                this.updateTimer.stop();
            }
        }

        private void cancelButtonActionPerformed(ActionEvent actionEvent) {
            if (this.thread.isAlive()) {
                this.thread.interrupt();
                this.cancelButton.setBackground(Color.ORANGE);
                this.cancelButton.setText("Remove");
                this.updateTimer.stop();
            } else {
                Container container = this.getTopLevelAncestor();
                this.getParent().remove(this);
                container.validate();
            }
        }

        private void initComponents() {
            int n = 2;
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
            String string = this.thread.getRetrievable().getName();
            string = string.length() > 40 ? string.substring(0, 37) + "..." : string;
            this.descriptionLabel = new JLabel(string);
            jPanel.add(this.descriptionLabel);
            this.add(jPanel);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setPreferredSize(new Dimension(100, 16));
            jPanel2.add(this.progressBar);
            jPanel2.add(Box.createHorizontalStrut(8));
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.setBackground(Color.RED);
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DownloadMonitorPanel.this.cancelButtonActionPerformed(actionEvent);
                }
            });
            jPanel2.add(this.cancelButton);
            this.add(jPanel2);
        }

        private String makeProgressDescription() {
            String string = "";
            if (this.progress.getTotalCount() > 0) {
                int n = (int)((float)this.progress.getCurrentCount() / (float)this.progress.getTotalCount() * 100.0f);
                string = n + "% of ";
                string = string + BulkDownloadPanel.makeSizeDescription(this.progress.getTotalSize());
            }
            return string;
        }
    }

    public static class BulkRetrievablePanel
    extends JPanel {
        private BulkRetrievable retrievable;
        private JCheckBox selectCheckBox;
        private JLabel descriptionLabel;
        private Thread updateThread;
        private Sector sector;

        BulkRetrievablePanel(BulkRetrievable bulkRetrievable) {
            this.retrievable = bulkRetrievable;
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.selectCheckBox = new JCheckBox(this.retrievable.getName());
            this.selectCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (((JCheckBox)actionEvent.getSource()).isSelected() && BulkRetrievablePanel.this.sector != null) {
                        BulkRetrievablePanel.this.updateDescription(BulkRetrievablePanel.this.sector);
                    }
                }
            });
            this.add((Component)this.selectCheckBox, "West");
            this.descriptionLabel = new JLabel();
            this.add((Component)this.descriptionLabel, "East");
        }

        public void updateDescription(final Sector sector) {
            if (this.updateThread != null && this.updateThread.isAlive()) {
                this.updateThread.interrupt();
            }
            this.sector = sector;
            if (!this.selectCheckBox.isSelected()) {
                this.doUpdateDescription(null);
                return;
            }
            this.updateThread = new Thread(new Runnable(){

                public void run() {
                    BulkRetrievablePanel.this.descriptionLabel.setText("...");
                    BulkRetrievablePanel.this.doUpdateDescription(sector);
                }
            });
            this.updateThread.setDaemon(true);
            this.updateThread.start();
        }

        private void doUpdateDescription(Sector sector) {
            if (sector != null) {
                try {
                    this.descriptionLabel.setText(BulkDownloadPanel.makeSizeDescription(this.retrievable.getEstimatedMissingDataSize(sector, 0.0)));
                }
                catch (Exception exception) {
                    this.descriptionLabel.setText("-");
                }
            } else {
                this.descriptionLabel.setText("-");
            }
        }

        public String toString() {
            return this.retrievable.getName();
        }
    }

    private static class BulkDownloadPanel
    extends JPanel {
        private WorldWindow wwd;
        private Sector currentSector;
        private ArrayList<BulkRetrievablePanel> retrievables;
        private JButton selectButton;
        private JLabel sectorLabel;
        private JButton startButton;
        private JPanel monitorPanel;
        private SectorSelector selector;
        Timer updateTimer;

        public BulkDownloadPanel(WorldWindow worldWindow) {
            this.wwd = worldWindow;
            this.retrievables = new ArrayList();
            for (Object object : this.wwd.getModel().getLayers()) {
                if (!(object instanceof BulkRetrievable)) continue;
                this.retrievables.add(new BulkRetrievablePanel((BulkRetrievable)object));
            }
            CompoundElevationModel compoundElevationModel = (CompoundElevationModel)worldWindow.getModel().getGlobe().getElevationModel();
            for (ElevationModel elevationModel : compoundElevationModel.getElevationModels()) {
                if (!(elevationModel instanceof BulkRetrievable)) continue;
                this.retrievables.add(new BulkRetrievablePanel((BulkRetrievable)((Object)elevationModel)));
            }
            this.selector = new SectorSelector(worldWindow);
            this.selector.setInteriorColor(new Color(1.0f, 1.0f, 1.0f, 0.1f));
            this.selector.setBorderColor(new Color(1.0f, 0.0f, 0.0f, 0.5f));
            this.selector.setBorderWidth(3.0);
            this.selector.addPropertyChangeListener("gov.nasa.worldwind.SectorSelector", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    BulkDownloadPanel.this.updateSector();
                }
            });
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
            this.initComponents();
        }

        private void updateSector() {
            this.currentSector = this.selector.getSector();
            if (this.currentSector != null) {
                this.sectorLabel.setText(BulkDownloadPanel.makeSectorDescription(this.currentSector));
                this.selectButton.setText("Clear sector");
                this.startButton.setEnabled(true);
            } else {
                this.sectorLabel.setText("-");
                this.selectButton.setText("Select sector");
                this.startButton.setEnabled(false);
            }
            this.updateRetrievablePanels(this.currentSector);
        }

        private void updateRetrievablePanels(Sector sector) {
            for (BulkRetrievablePanel bulkRetrievablePanel : this.retrievables) {
                bulkRetrievablePanel.updateDescription(sector);
            }
        }

        private void selectButtonActionPerformed(ActionEvent actionEvent) {
            if (this.selector.getSector() != null) {
                this.selector.disable();
            } else {
                this.selector.enable();
            }
            this.updateSector();
        }

        private void startButtonActionPerformed(ActionEvent actionEvent) {
            for (BulkRetrievablePanel bulkRetrievablePanel : this.retrievables) {
                if (!bulkRetrievablePanel.selectCheckBox.isSelected()) continue;
                BulkRetrievable bulkRetrievable = bulkRetrievablePanel.retrievable;
                BulkRetrievalThread bulkRetrievalThread = bulkRetrievable.makeLocal(this.currentSector, 0.0);
                this.monitorPanel.add(new DownloadMonitorPanel(bulkRetrievalThread));
            }
            this.getTopLevelAncestor().validate();
        }

        private void initComponents() {
            int n = 6;
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Download")));
            this.setToolTipText("Layer imagery bulk download.");
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel2.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
            this.selectButton = new JButton("Select sector");
            this.selectButton.setToolTipText("Press Select then press and drag button 1 on globe");
            this.selectButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BulkDownloadPanel.this.selectButtonActionPerformed(actionEvent);
                }
            });
            jPanel2.add(this.selectButton);
            this.sectorLabel = new JLabel("-");
            this.sectorLabel.setPreferredSize(new Dimension(350, 16));
            this.sectorLabel.setHorizontalAlignment(0);
            jPanel2.add(this.sectorLabel);
            this.add(jPanel2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 1));
            jPanel3.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
            for (BulkRetrievablePanel jPanel4 : this.retrievables) {
                jPanel3.add(jPanel4);
            }
            this.add(jPanel3);
            JPanel jPanel5 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel5.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
            this.startButton = new JButton("Start download");
            this.startButton.setEnabled(false);
            this.startButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BulkDownloadPanel.this.startButtonActionPerformed(actionEvent);
                }
            });
            jPanel5.add(this.startButton);
            this.add(jPanel5);
            this.monitorPanel = new JPanel();
            this.monitorPanel.setLayout(new BoxLayout(this.monitorPanel, 1));
            this.monitorPanel.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.monitorPanel, "North");
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jScrollPane.setPreferredSize(new Dimension(350, 200));
            this.add(jScrollPane);
        }

        public static String makeSectorDescription(Sector sector) {
            return String.format("S %7.4f\u00b0 W %7.4f\u00b0 N %7.4f\u00b0 E %7.4f\u00b0", sector.getMinLatitude().degrees, sector.getMinLongitude().degrees, sector.getMaxLatitude().degrees, sector.getMaxLongitude().degrees);
        }

        public static String makeSizeDescription(long l) {
            return String.format("%.1f MB", (double)l / 1024.0 / 1024.0);
        }
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            this.getLayerPanel().add((Component)new BulkDownloadPanel(this.getWwd()), "South");
        }
    }
}

