/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.examples.BasicDragger;
import gov.nasa.worldwind.examples.LayerPanel;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.IconLayer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.AbstractSurfaceShape;
import gov.nasa.worldwind.render.ConformingCircle;
import gov.nasa.worldwind.render.ConformingEllipse;
import gov.nasa.worldwind.render.ConformingEllipticalPolygon;
import gov.nasa.worldwind.render.ConformingPolygon;
import gov.nasa.worldwind.render.ConformingQuad;
import gov.nasa.worldwind.render.ConformingShape;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.SurfaceEllipse;
import gov.nasa.worldwind.render.UserFacingIcon;
import gov.nasa.worldwind.render.WWIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class DraggingConformingShapes
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("Conforming Surface Shape Dragging", AppFrame.class);
    }

    private static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private boolean drawWireframeInterior = false;
        private boolean drawWireframeExterior = false;
        private boolean buildConformingShapes = true;
        private boolean drawShapeInterior = true;
        private boolean drawShapeBoundary = true;
        private RenderableLayer rLayer = new RenderableLayer();
        private int numShapesInLayer = -1;
        WWIcon lastPickedIcon;

        public AppFrame() {
            super(true, true, true);
            this.rebuildRenderableShapeLayer(this.getWwd().getModel().getGlobe());
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), this.rLayer);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), this.buildIconLayer());
            this.getLayerPanel().update(this.getWwd());
            this.makeControlPanel(this.getLayerPanel());
            this.getWwd().addSelectListener(new SelectListener(){
                private WWIcon lastToolTipIcon = null;
                private BasicDragger dragger = new BasicDragger(AppFrame.this.getWwd());

                public void selected(SelectEvent selectEvent) {
                    if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Hover")) {
                        if (this.lastToolTipIcon != null) {
                            this.lastToolTipIcon.setShowToolTip(false);
                            this.lastToolTipIcon = null;
                            AppFrame.this.getWwd().repaint();
                        }
                        if (selectEvent.hasObjects() && !this.dragger.isDragging()) {
                            if (selectEvent.getTopObject() instanceof WWIcon) {
                                this.lastToolTipIcon = (WWIcon)selectEvent.getTopObject();
                                this.lastToolTipIcon.setShowToolTip(true);
                                AppFrame.this.getWwd().repaint();
                            } else if (selectEvent.getTopObject() instanceof ConformingPolygon) {
                                ConformingPolygon conformingPolygon = (ConformingPolygon)selectEvent.getTopObject();
                                Globe globe = AppFrame.this.getWwd().getModel().getGlobe();
                                double d = conformingPolygon.getLength(globe);
                                double d2 = conformingPolygon.getArea(globe);
                                double d3 = conformingPolygon.getPerimeter(globe);
                                double d4 = conformingPolygon.getWidth(globe);
                                double d5 = conformingPolygon.getHeight(globe);
                                System.out.println("length = " + d + ", area = " + d2 + ", perimeter = " + d3);
                                System.out.println("width = " + d4 + ", height = " + d5);
                            }
                        }
                    } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover") && !this.dragger.isDragging()) {
                        AppFrame.this.highlight(selectEvent.getTopObject());
                    } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd") || selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag")) {
                        PickedObjectList pickedObjectList;
                        this.dragger.selected(selectEvent);
                        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd") && (pickedObjectList = AppFrame.this.getWwd().getObjectsAtCurrentPosition()) != null) {
                            AppFrame.this.highlight(pickedObjectList.getTopObject());
                            AppFrame.this.getWwd().repaint();
                        }
                    }
                }
            });
        }

        private void highlight(Object object) {
            if (this.lastPickedIcon == object) {
                return;
            }
            if (this.lastPickedIcon != null) {
                this.lastPickedIcon.setHighlighted(false);
                this.lastPickedIcon = null;
            }
            if (object != null && object instanceof WWIcon) {
                this.lastPickedIcon = (WWIcon)object;
                this.lastPickedIcon.setHighlighted(true);
            }
        }

        private IconLayer buildIconLayer() {
            IconLayer iconLayer = new IconLayer();
            Font font = this.makeToolTipFont();
            for (double d = 0.0; d < 10.0; d += 10.0) {
                for (double d2 = -180.0; d2 < 180.0; d2 += 10.0) {
                    double d3 = 0.0;
                    if (d2 % 90.0 == 0.0) {
                        d3 = 2000000.0;
                    }
                    UserFacingIcon userFacingIcon = new UserFacingIcon("images/32x32-icon-nasa.png", new Position(Angle.fromDegrees(d), Angle.fromDegrees(d2), d3));
                    userFacingIcon.setHighlightScale(1.5);
                    userFacingIcon.setToolTipFont(font);
                    userFacingIcon.setToolTipText(userFacingIcon.getImageSource().toString());
                    userFacingIcon.setToolTipTextColor(Color.YELLOW);
                    iconLayer.addIcon(userFacingIcon);
                }
            }
            return iconLayer;
        }

        private void makeControlPanel(LayerPanel layerPanel) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(0, 1));
            String[] stringArray = new String[]{"Demo", "25", "50", "100", "200", "400", "800", "1600", "3200"};
            JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
            jComboBox.setSelectedIndex(0);
            jComboBox.addActionListener(new ActionListener(){
                private int[] num = new int[]{-1, 25, 50, 100, 200, 400, 800, 1600, 3200};

                public void actionPerformed(ActionEvent actionEvent) {
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    int n = jComboBox.getSelectedIndex();
                    AppFrame.this.numShapesInLayer = this.num[n];
                    AppFrame.this.rLayer.removeAllRenderables();
                    AppFrame.this.rebuildRenderableShapeLayer(AppFrame.this.getWwd().getModel().getGlobe());
                    AppFrame.this.getWwd().redraw();
                }
            });
            jPanel.add(jComboBox);
            JCheckBox jCheckBox = new JCheckBox("Build 'Conforming' Shapes", this.buildConformingShapes);
            jPanel.add(jCheckBox);
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.buildConformingShapes = !AppFrame.this.buildConformingShapes;
                    AppFrame.this.rLayer.removeAllRenderables();
                    AppFrame.this.rebuildRenderableShapeLayer(AppFrame.this.getWwd().getModel().getGlobe());
                    AppFrame.this.getWwd().redraw();
                }
            });
            JCheckBox jCheckBox2 = new JCheckBox("Fill shape boundaries", this.drawShapeInterior);
            jPanel.add(jCheckBox2);
            jCheckBox2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.drawShapeInterior = !AppFrame.this.drawShapeInterior;
                    for (Renderable renderable : AppFrame.this.rLayer.getRenderables()) {
                        if (renderable instanceof ConformingShape) {
                            ((ConformingShape)renderable).setDrawInterior(AppFrame.this.drawShapeInterior);
                            continue;
                        }
                        ((AbstractSurfaceShape)renderable).getAttributes().setDrawOutline(AppFrame.this.drawShapeInterior);
                    }
                    AppFrame.this.getWwd().redraw();
                }
            });
            JCheckBox jCheckBox3 = new JCheckBox("Draw shape boundaries", this.drawShapeBoundary);
            jPanel.add(jCheckBox3);
            jCheckBox3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.drawShapeBoundary = !AppFrame.this.drawShapeBoundary;
                    for (Renderable renderable : AppFrame.this.rLayer.getRenderables()) {
                        if (renderable instanceof ConformingShape) {
                            ((ConformingShape)renderable).setDrawBorder(AppFrame.this.drawShapeBoundary);
                            continue;
                        }
                        ((AbstractSurfaceShape)renderable).getAttributes().setDrawOutline(AppFrame.this.drawShapeBoundary);
                    }
                    AppFrame.this.getWwd().redraw();
                }
            });
            JCheckBox jCheckBox4 = new JCheckBox("Show wireframe exterior", this.drawWireframeExterior);
            if (this.drawWireframeExterior) {
                this.getWwd().getModel().setShowWireframeExterior(true);
            }
            jPanel.add(jCheckBox4);
            jCheckBox4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.drawWireframeExterior = !AppFrame.this.drawWireframeExterior;
                    WorldWindowGLCanvas worldWindowGLCanvas = AppFrame.this.getWwd();
                    worldWindowGLCanvas.getModel().setShowWireframeExterior(AppFrame.this.drawWireframeExterior);
                    worldWindowGLCanvas.redraw();
                }
            });
            JCheckBox jCheckBox5 = new JCheckBox("Show wireframe interior", this.drawWireframeInterior);
            if (this.drawWireframeInterior) {
                this.getWwd().getModel().setShowWireframeInterior(true);
            }
            jPanel.add(jCheckBox5);
            jCheckBox5.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.drawWireframeInterior = !AppFrame.this.drawWireframeInterior;
                    WorldWindowGLCanvas worldWindowGLCanvas = AppFrame.this.getWwd();
                    worldWindowGLCanvas.getModel().setShowWireframeInterior(AppFrame.this.drawWireframeInterior);
                    worldWindowGLCanvas.redraw();
                }
            });
            layerPanel.add((Component)jPanel, "South");
        }

        private Font makeToolTipFont() {
            HashMap<TextAttribute, Color> hashMap = new HashMap<TextAttribute, Color>();
            hashMap.put(TextAttribute.BACKGROUND, new Color(0.4f, 0.4f, 0.4f, 1.0f));
            return Font.decode("Arial-BOLD-14").deriveFont(hashMap);
        }

        private void rebuildRenderableShapeLayer(Globe globe) {
            if (this.numShapesInLayer > 0) {
                this.buildRandomShapes(globe);
            } else {
                this.buildDemoShapes(globe);
            }
        }

        private void buildDemoShapes(Globe globe) {
            ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
            arrayList.add(new LatLon(Angle.fromDegrees(35.0), Angle.fromDegrees(-115.0)));
            arrayList.add(new LatLon(Angle.fromDegrees(35.0), Angle.fromDegrees(-105.0)));
            arrayList.add(new LatLon(Angle.fromDegrees(40.0), Angle.fromDegrees(-110.0)));
            arrayList.add(new LatLon(Angle.fromDegrees(35.0), Angle.fromDegrees(-115.0)));
            Color color = new Color(1.0f, 0.0f, 1.0f, 1.0f);
            Color color2 = new Color(0.8f, 0.0f, 0.0f, 0.3f);
            ConformingPolygon conformingPolygon = new ConformingPolygon(globe, arrayList, color2, color);
            conformingPolygon.setBorderWidth(3.0);
            conformingPolygon.setDrawBorder(this.drawShapeBoundary);
            conformingPolygon.setDrawInterior(this.drawShapeInterior);
            this.rLayer.addRenderable(conformingPolygon);
            ArrayList<LatLon> arrayList2 = new ArrayList<LatLon>();
            arrayList2.add(new LatLon(Angle.fromDegrees(30.0), Angle.fromDegrees(-80.0)));
            arrayList2.add(new LatLon(Angle.fromDegrees(32.0), Angle.fromDegrees(-78.0)));
            arrayList2.add(new LatLon(Angle.fromDegrees(34.0), Angle.fromDegrees(-72.0)));
            arrayList2.add(new LatLon(Angle.fromDegrees(34.0), Angle.fromDegrees(-76.0)));
            arrayList2.add(new LatLon(Angle.fromDegrees(38.0), Angle.fromDegrees(-72.0)));
            arrayList2.add(new LatLon(Angle.fromDegrees(36.0), Angle.fromDegrees(-76.0)));
            arrayList2.add(new LatLon(Angle.fromDegrees(40.0), Angle.fromDegrees(-80.0)));
            arrayList2.add(new LatLon(Angle.fromDegrees(30.0), Angle.fromDegrees(-80.0)));
            ConformingPolygon conformingPolygon2 = new ConformingPolygon(globe, arrayList2);
            conformingPolygon2.setBorderWidth(2.0);
            conformingPolygon2.setDrawBorder(this.drawShapeBoundary);
            conformingPolygon2.setDrawInterior(this.drawShapeInterior);
            this.rLayer.addRenderable(conformingPolygon2);
            ConformingEllipticalPolygon conformingEllipticalPolygon = new ConformingEllipticalPolygon(globe, new LatLon(Angle.fromDegrees(39.0), Angle.fromDegrees(-77.0)), 110000.0, 110000.0, Angle.ZERO, 5);
            conformingEllipticalPolygon.setDrawBorder(this.drawShapeBoundary);
            conformingEllipticalPolygon.setDrawInterior(this.drawShapeInterior);
            this.rLayer.addRenderable(conformingEllipticalPolygon);
            ConformingEllipticalPolygon conformingEllipticalPolygon2 = new ConformingEllipticalPolygon(globe, new LatLon(Angle.fromDegrees(44.0), Angle.fromDegrees(-96.0)), 375000.0, 200000.0, Angle.ZERO, 6);
            conformingEllipticalPolygon2.setDrawBorder(this.drawShapeBoundary);
            conformingEllipticalPolygon2.setDrawInterior(this.drawShapeInterior);
            this.rLayer.addRenderable(conformingEllipticalPolygon2);
            ConformingQuad conformingQuad = new ConformingQuad(globe, new LatLon(Angle.fromDegrees(43.75), Angle.fromDegrees(-121.0)), 150000.0, 80000.0, Angle.ZERO);
            conformingQuad.setDrawBorder(this.drawShapeBoundary);
            conformingQuad.setDrawInterior(this.drawShapeInterior);
            this.rLayer.addRenderable(conformingQuad);
            ConformingQuad conformingQuad2 = new ConformingQuad(globe, new LatLon(Angle.fromDegrees(25.0), Angle.fromDegrees(-90.0)), 450000.0, 30000.0, Angle.ZERO);
            conformingQuad2.setDrawBorder(this.drawShapeBoundary);
            conformingQuad2.setDrawInterior(this.drawShapeInterior);
            this.rLayer.addRenderable(conformingQuad2);
            ConformingEllipticalPolygon conformingEllipticalPolygon3 = new ConformingEllipticalPolygon(globe, new LatLon(Angle.fromDegrees(20.0), Angle.fromDegrees(179.0)), 425000.0, 200000.0, Angle.ZERO, 6);
            conformingEllipticalPolygon3.setDrawBorder(this.drawShapeBoundary);
            conformingEllipticalPolygon3.setDrawInterior(this.drawShapeInterior);
            this.rLayer.addRenderable(conformingEllipticalPolygon3);
            ArrayList<LatLon> arrayList3 = new ArrayList<LatLon>();
            arrayList3.add(new LatLon(Angle.fromDegrees(-35.0), Angle.fromDegrees(170.0)));
            arrayList3.add(new LatLon(Angle.fromDegrees(-35.0), Angle.fromDegrees(-170.0)));
            arrayList3.add(new LatLon(Angle.fromDegrees(-20.0), Angle.fromDegrees(-175.0)));
            arrayList3.add(new LatLon(Angle.fromDegrees(-35.0), Angle.fromDegrees(170.0)));
            Color color3 = new Color(1.0f, 0.0f, 1.0f, 1.0f);
            Color color4 = new Color(0.8f, 0.0f, 0.0f, 0.3f);
            ConformingPolygon conformingPolygon3 = new ConformingPolygon(globe, arrayList3, color4, color3);
            conformingPolygon3.setBorderWidth(2.0);
            conformingPolygon3.setDrawBorder(this.drawShapeBoundary);
            conformingPolygon3.setDrawInterior(this.drawShapeInterior);
            this.rLayer.addRenderable(conformingPolygon3);
            ArrayList<LatLon> arrayList4 = new ArrayList<LatLon>();
            arrayList4.add(new LatLon(Angle.fromDegrees(-15.0), Angle.fromDegrees(170.0)));
            arrayList4.add(new LatLon(Angle.fromDegrees(-15.0), Angle.fromDegrees(-170.0)));
            arrayList4.add(new LatLon(Angle.fromDegrees(0.0), Angle.fromDegrees(170.0)));
            arrayList4.add(new LatLon(Angle.fromDegrees(-15.0), Angle.fromDegrees(170.0)));
            Color color5 = new Color(1.0f, 0.0f, 1.0f, 1.0f);
            Color color6 = new Color(0.8f, 0.0f, 0.0f, 0.3f);
            ConformingPolygon conformingPolygon4 = new ConformingPolygon(globe, arrayList4, color6, color5);
            conformingPolygon4.setBorderWidth(2.0);
            conformingPolygon4.setDrawBorder(this.drawShapeBoundary);
            conformingPolygon4.setDrawInterior(this.drawShapeInterior);
            this.rLayer.addRenderable(conformingPolygon4);
            ConformingEllipse conformingEllipse = new ConformingEllipse(new LatLon(Angle.fromDegrees(20.0), Angle.fromDegrees(-100.0)), 375000.0, 200000.0, null);
            conformingEllipse.setDrawBorder(this.drawShapeBoundary);
            conformingEllipse.setDrawInterior(this.drawShapeInterior);
            this.rLayer.addRenderable(conformingEllipse);
            ConformingCircle conformingCircle = new ConformingCircle(new LatLon(Angle.fromDegrees(30.0), Angle.fromDegrees(-100.0)), 375000.0);
            conformingCircle.setDrawBorder(this.drawShapeBoundary);
            conformingCircle.setDrawInterior(this.drawShapeInterior);
            this.rLayer.addRenderable(conformingCircle);
        }

        private void buildRandomShapes(Globe globe) {
            int[] nArray = new int[]{3, 4, 5, 6, 7, 8};
            Color[] colorArray = new Color[]{new Color(1.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 1.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 1.0f, 1.0f), new Color(0.0f, 1.0f, 1.0f, 1.0f), new Color(1.0f, 0.0f, 1.0f, 1.0f), new Color(1.0f, 1.0f, 0.0f, 1.0f)};
            float f = 0.3f;
            float f2 = 0.3f;
            Color[] colorArray2 = new Color[]{new Color(1.0f, f2, f2, f), new Color(f2, 1.0f, f2, f), new Color(f2, f2, 1.0f, f), new Color(f2, 1.0f, 1.0f, f), new Color(1.0f, f2, 1.0f, f), new Color(1.0f, 1.0f, f2, f)};
            double d = 0.0;
            double d2 = 80.0;
            double d3 = -170.0;
            double d4 = 0.0;
            for (int i = 0; i < this.numShapesInLayer; ++i) {
                Movable movable;
                int n = i % nArray.length;
                double d5 = d + Math.random() * (d2 - d);
                double d6 = d3 + Math.random() * (d4 - d3);
                if (this.buildConformingShapes) {
                    movable = new ConformingEllipticalPolygon(globe, new LatLon(Angle.fromDegrees(d5), Angle.fromDegrees(d6)), 175000.0, 100000.0, Angle.ZERO, nArray[n], colorArray2[n], colorArray[n]);
                    ((ConformingShape)movable).setDrawBorder(this.drawShapeBoundary);
                    ((ConformingShape)movable).setDrawInterior(this.drawShapeInterior);
                    this.rLayer.addRenderable((Renderable)((Object)movable));
                    continue;
                }
                movable = new SurfaceEllipse(new LatLon(Angle.fromDegrees(d5), Angle.fromDegrees(d6)), 175000.0, 100000.0, Angle.ZERO);
                ((AbstractSurfaceShape)movable).getAttributes().setDrawInterior(this.drawShapeInterior);
                ((AbstractSurfaceShape)movable).getAttributes().setDrawOutline(this.drawShapeBoundary);
                ((AbstractSurfaceShape)movable).getAttributes().setInteriorMaterial(new Material(colorArray2[n]));
                ((AbstractSurfaceShape)movable).getAttributes().setOutlineMaterial(new Material(colorArray[n]));
                ((AbstractSurfaceShape)movable).getAttributes().setInteriorOpacity((double)colorArray2[n].getAlpha() / 255.0);
                ((AbstractSurfaceShape)movable).getAttributes().setOutlineOpacity((double)colorArray[n].getAlpha() / 255.0);
                this.rLayer.addRenderable((Renderable)((Object)movable));
            }
        }
    }
}

