/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.event.PositionEvent;
import gov.nasa.worldwind.event.PositionListener;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.MarkerLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.markers.BasicMarker;
import gov.nasa.worldwind.render.markers.BasicMarkerAttributes;
import gov.nasa.worldwind.render.markers.Marker;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class FilterByRegion
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Filtering by Region", AppFrame.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyMarkerLayer
    extends MarkerLayer {
        private static final double[] REGION_SIZES = new double[]{5.0, 1.0};
        private static final long TIME_LIMIT = 10L;
        private Position position;
        private Iterable<Marker> markers;

        public MyMarkerLayer() {
            this.setOverrideMarkerElevation(true);
        }

        public void setCursorLocation(Position position) {
            this.position = position;
        }

        @Override
        protected void draw(DrawContext drawContext, Point point) {
            if (this.position == null) {
                return;
            }
            Vec4 vec4 = drawContext.getGlobe().computePointFromPosition(this.position);
            if (!this.isPickEnabled() || drawContext.isPickingMode() || this.markers == null) {
                this.markers = this.sortPositions(drawContext, vec4);
            }
            this.setMarkers(this.markers);
            super.draw(drawContext, point);
        }

        private Iterable<Marker> sortPositions(DrawContext drawContext, Vec4 vec4) {
            BasicMarkerAttributes basicMarkerAttributes = new BasicMarkerAttributes();
            ArrayList<Marker> arrayList = new ArrayList<Marker>();
            for (Sector sector : drawContext.getVisibleSectors(REGION_SIZES, 10L, Sector.FULL_SPHERE)) {
                LatLon latLon = sector.getCentroid();
                Vec4 vec42 = drawContext.getGlobe().computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), 0.0);
                if (!(vec42.distanceTo3(vec4) <= 1000000.0)) continue;
                arrayList.add(new BasicMarker(new Position(latLon.getLatitude(), latLon.getLongitude(), 0.0), basicMarkerAttributes));
            }
            return arrayList;
        }
    }

    private static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() throws IOException, ParserConfigurationException, SAXException {
            super(true, true, false);
            final MyMarkerLayer myMarkerLayer = new MyMarkerLayer();
            myMarkerLayer.setKeepSeparated(false);
            myMarkerLayer.setPickEnabled(false);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), myMarkerLayer);
            this.getLayerPanel().update(this.getWwd());
            this.getWwd().addPositionListener(new PositionListener(){

                public void moved(PositionEvent positionEvent) {
                    myMarkerLayer.setCursorLocation(positionEvent.getPosition());
                }
            });
        }
    }
}

