/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.DragSelectEvent;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.GeoQuad;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.EllipsoidalGlobe;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.SurfaceImage;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageEditor
implements SelectListener {
    private static final int NONE = 0;
    private static final int MOVING = 1;
    private static final int SIZING = 2;
    private static final double EDGE_FACTOR = 0.1;
    private final WorldWindow wwd;
    private int operation = 0;
    private Position previousPosition = null;
    private RenderableLayer layer;
    private RegionShape shape;

    public ImageEditor(WorldWindow worldWindow, SurfaceImage surfaceImage) {
        if (worldWindow == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        this.wwd = worldWindow;
        this.layer = new RenderableLayer();
        this.layer.setPickEnabled(true);
        this.shape = new RegionShape(surfaceImage);
        this.layer.addRenderable(this.shape);
        worldWindow.addSelectListener(this);
        this.wwd.getInputHandler().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (1024 != mouseEvent.getModifiersEx()) {
                    return;
                }
                if (!ImageEditor.this.shape.armed) {
                    return;
                }
                ImageEditor.this.shape.resizeable = true;
                ImageEditor.this.shape.startPosition = null;
                ImageEditor.this.shape.armed = false;
                mouseEvent.consume();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (1 != mouseEvent.getButton()) {
                    return;
                }
                if (ImageEditor.this.shape.resizeable) {
                    ((Component)((Object)ImageEditor.this.wwd)).setCursor(Cursor.getDefaultCursor());
                }
                ImageEditor.this.shape.resizeable = false;
                mouseEvent.consume();
            }
        });
        this.wwd.getInputHandler().addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (ImageEditor.this.shape.resizeable) {
                    mouseEvent.consume();
                }
            }
        });
    }

    public void enableLayer() {
        this.shape.startPosition = null;
        LayerList layerList = this.wwd.getModel().getLayers();
        if (!layerList.contains(this.layer)) {
            layerList.add(this.layer);
        }
        if (!this.layer.isEnabled()) {
            this.layer.setEnabled(true);
        }
        this.shape.armed = true;
    }

    public void disableLayer() {
        LayerList layerList = this.wwd.getModel().getLayers();
        layerList.remove(this.layer);
        this.shape.clear();
    }

    public Sector getSelectedSector() {
        return this.shape.hasSelection() ? this.shape.getBoundingSector() : null;
    }

    @Override
    public void selected(SelectEvent selectEvent) {
        if (selectEvent == null) {
            String string = Logging.getMessage("nullValue.EventIsNull");
            Logging.logger().log(Level.FINE, string);
            throw new IllegalArgumentException(string);
        }
        if (selectEvent.getTopObject() != null && selectEvent.getTopObject() != this.shape.image) {
            ((Component)((Object)this.wwd)).setCursor(Cursor.getDefaultCursor());
            this.shape.setHighlight(0);
            return;
        }
        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd")) {
            this.operation = 0;
            this.previousPosition = null;
        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover")) {
            if (!(this.wwd instanceof Component)) {
                return;
            }
            if (selectEvent.getTopObject() == null || selectEvent.getTopPickedObject().isTerrain()) {
                ((Component)((Object)this.wwd)).setCursor(Cursor.getDefaultCursor());
                this.shape.setHighlight(0);
                return;
            }
            if (!(selectEvent.getTopObject() instanceof Movable)) {
                return;
            }
            int n = this.determineAdjustmentSide((Movable)selectEvent.getTopObject(), 0.1);
            this.shape.setHighlight(n);
            Cursor cursor = Cursor.getDefaultCursor();
            switch (n) {
                case 0: {
                    cursor = Cursor.getPredefinedCursor(12);
                    break;
                }
                case 1: {
                    cursor = Cursor.getPredefinedCursor(8);
                    break;
                }
                case 2: {
                    cursor = Cursor.getPredefinedCursor(9);
                    break;
                }
                case 4: {
                    cursor = Cursor.getPredefinedCursor(11);
                    break;
                }
                case 8: {
                    cursor = Cursor.getPredefinedCursor(10);
                    break;
                }
                case 9: {
                    cursor = Cursor.getPredefinedCursor(6);
                    break;
                }
                case 5: {
                    cursor = Cursor.getPredefinedCursor(7);
                    break;
                }
                case 10: {
                    cursor = Cursor.getPredefinedCursor(4);
                    break;
                }
                case 6: {
                    cursor = Cursor.getPredefinedCursor(5);
                }
            }
            ((Component)((Object)this.wwd)).setCursor(cursor);
        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftPress")) {
            this.previousPosition = this.wwd.getCurrentPosition();
        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag")) {
            DragSelectEvent dragSelectEvent = (DragSelectEvent)selectEvent;
            Object object = dragSelectEvent.getTopObject();
            if (object == null) {
                return;
            }
            if (!(object instanceof Movable)) {
                return;
            }
            Movable movable = (Movable)object;
            int n = this.determineAdjustmentSide(movable, 0.1);
            if (n == 0 || this.operation == 1) {
                this.operation = 1;
                this.dragWholeShape(dragSelectEvent, movable);
            } else if (movable instanceof SurfaceImage) {
                List<LatLon> list = this.resizeShape(movable, n);
                ((SurfaceImage)movable).setCorners(list);
                this.operation = 2;
            }
            this.previousPosition = this.wwd.getCurrentPosition();
        }
    }

    private int determineAdjustmentSide(Movable movable, double d) {
        if (movable instanceof SurfaceImage) {
            double d2;
            SurfaceImage surfaceImage = (SurfaceImage)movable;
            Position position = this.wwd.getCurrentPosition();
            if (position == null) {
                return 0;
            }
            GeoQuad geoQuad = new GeoQuad(surfaceImage.getCorners());
            double d3 = d * surfaceImage.getSector().getDeltaLatDegrees();
            double d4 = 0.5 * (d3 + (d2 = d * surfaceImage.getSector().getDeltaLonDegrees()));
            if (geoQuad.distanceToNW((LatLon)position).degrees < d4) {
                return 9;
            }
            if (geoQuad.distanceToNE((LatLon)position).degrees < d4) {
                return 5;
            }
            if (geoQuad.distanceToSW((LatLon)position).degrees < d4) {
                return 10;
            }
            if (geoQuad.distanceToSE((LatLon)position).degrees < d4) {
                return 6;
            }
            if (geoQuad.distanceToNorthEdge((LatLon)position).degrees < d4) {
                return 1;
            }
            if (geoQuad.distanceToSouthEdge((LatLon)position).degrees < d4) {
                return 2;
            }
            if (geoQuad.distanceToEastEdge((LatLon)position).degrees < d4) {
                return 4;
            }
            if (geoQuad.distanceToWestEdge((LatLon)position).degrees < d4) {
                return 8;
            }
        }
        return 0;
    }

    private List<LatLon> resizeShape(Movable movable, int n) {
        if (movable instanceof SurfaceImage) {
            SurfaceImage surfaceImage = (SurfaceImage)movable;
            List<LatLon> list = surfaceImage.getCorners();
            Position position = this.wwd.getCurrentPosition();
            Angle angle = position.getLatitude().subtract(this.previousPosition.getLatitude());
            Angle angle2 = position.getLongitude().subtract(this.previousPosition.getLongitude());
            LatLon latLon = new LatLon(angle, angle2);
            LatLon latLon2 = list.get(0);
            LatLon latLon3 = list.get(1);
            LatLon latLon4 = list.get(2);
            LatLon latLon5 = list.get(3);
            if (n == 1) {
                latLon5 = latLon5.add(latLon);
                latLon4 = latLon4.add(latLon);
            } else if (n == 2) {
                latLon2 = latLon2.add(latLon);
                latLon3 = latLon3.add(latLon);
            } else if (n == 4) {
                latLon3 = latLon3.add(latLon);
                latLon4 = latLon4.add(latLon);
            } else if (n == 8) {
                latLon2 = latLon2.add(latLon);
                latLon5 = latLon5.add(latLon);
            } else if (n == 9) {
                latLon5 = latLon5.add(latLon);
            } else if (n == 5) {
                latLon4 = latLon4.add(latLon);
            } else if (n == 10) {
                latLon2 = latLon2.add(latLon);
            } else if (n == 6) {
                latLon3 = latLon3.add(latLon);
            }
            return Arrays.asList(latLon2, latLon3, latLon4, latLon5);
        }
        return null;
    }

    private static double minAbs(double d, double d2, double d3, double d4) {
        double d5 = d;
        if (ImageEditor.abs(d2) < ImageEditor.abs(d5)) {
            d5 = d2;
        }
        if (ImageEditor.abs(d3) < ImageEditor.abs(d5)) {
            d5 = d3;
        }
        if (ImageEditor.abs(d4) < ImageEditor.abs(d5)) {
            d5 = d4;
        }
        return d5;
    }

    private static double abs(double d) {
        return d >= 0.0 ? d : -d;
    }

    private void dragWholeShape(DragSelectEvent dragSelectEvent, Movable movable) {
        View view = this.wwd.getView();
        EllipsoidalGlobe ellipsoidalGlobe = (EllipsoidalGlobe)this.wwd.getModel().getGlobe();
        Position position = movable.getReferencePosition();
        Vec4 vec4 = ellipsoidalGlobe.computePointFromPosition(position);
        Vec4 vec42 = view.project(vec4);
        int n = dragSelectEvent.getPickPoint().x - dragSelectEvent.getPreviousPickPoint().x;
        double d = vec42.x + (double)n;
        int n2 = dragSelectEvent.getPickPoint().y - dragSelectEvent.getPreviousPickPoint().y;
        double d2 = (double)dragSelectEvent.getMouseEvent().getComponent().getSize().height - vec42.y + (double)n2 - 1.0;
        Line line = view.computeRayFromScreenPoint(d, d2);
        Intersection[] intersectionArray = ellipsoidalGlobe.intersect(line, position.getElevation());
        if (intersectionArray != null) {
            Position position2 = ellipsoidalGlobe.computePositionFromPoint(intersectionArray[0].getIntersectionPoint());
            movable.moveTo(position2);
        }
    }

    public static class RegionShape
    implements Renderable {
        private SurfaceImage image;
        private boolean armed = false;
        private boolean resizeable = false;
        private Position startPosition;
        private Position endPosition;
        private int highlightSide = 0;
        private Polyline handle;

        public RegionShape(SurfaceImage surfaceImage) {
            this.image = surfaceImage;
            this.handle = new Polyline();
            this.handle.setFollowTerrain(true);
            this.handle.setPathType(1);
            this.handle.setClosed(false);
            this.handle.setColor(new Color(1.0f, 0.0f, 0.0f, 0.5f));
            this.handle.setLineWidth(3.0);
        }

        public Sector getBoundingSector() {
            return this.image.getSector();
        }

        public boolean hasSelection() {
            return this.startPosition != null && this.endPosition != null;
        }

        private void clear() {
            this.endPosition = null;
            this.startPosition = null;
        }

        public void setHighlight(int n) {
            this.highlightSide = n;
        }

        public void render(DrawContext drawContext) {
            if (drawContext.isPickingMode() && this.resizeable) {
                return;
            }
            if (!this.resizeable && this.startPosition != null && this.endPosition != null) {
                this.image.render(drawContext);
            }
            List<LatLon> list = this.image.getCorners();
            ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
            switch (this.highlightSide) {
                case 1: {
                    arrayList.addAll(Arrays.asList(list.get(2), list.get(3)));
                    break;
                }
                case 2: {
                    arrayList.addAll(Arrays.asList(list.get(0), list.get(1)));
                    break;
                }
                case 4: {
                    arrayList.addAll(Arrays.asList(list.get(1), list.get(2)));
                    break;
                }
                case 8: {
                    arrayList.addAll(Arrays.asList(list.get(3), list.get(0)));
                    break;
                }
                case 9: {
                    break;
                }
                case 5: {
                    break;
                }
                case 10: {
                    break;
                }
                case 6: {
                    break;
                }
            }
            this.handle.setPositions(arrayList, 0.0);
            this.handle.render(drawContext);
        }
    }
}

