/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.data.DataDescriptor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstalledDataPanel
extends JPanel {
    public static final String REFRESH_ACTION_COMMAND = "InstalledDataPanel.RefreshActionCommand";
    public static final String INSTALL_ACTION_COMMAND = "InstalledDataPanel.InstallActionCommand";
    public static final String UNINSTALL_ACTION_COMMAND = "InstalledDataPanel.UninstallActionCommand";
    public static final String PROPERTIES_ACTION_COMMAND = "InstalledDataPanel.PropertiesActionCommand";
    public static final String ZOOM_ACTION_COMMAND = "InstalledDataPanel.ZoomActionCommand";
    protected static final String COLUMN_INSTALLED = "Installed";
    protected static final String COLUMN_NAME = "Name";
    protected static final String COLUMN_DATA_STORE_LOCATION = "Data store location";
    protected static final String COLUMN_DATA_STORE_PATH = "Path";
    protected static final int ROW_OBJECT = -1;
    private EventListenerList listenerList = new EventListenerList();
    private ActionListener actionListenerDelegate = new ActionListenerDelegate(this);
    private JToolBar toolBar;
    private JButton refreshButton;
    private JButton installButton;
    private JButton uninstallButton;
    private JButton propertiesButton;
    private JButton zoomButton;
    private DataDescriptorTableModel tableModel;
    private JTable table;
    private JScrollPane scrollPane;

    public InstalledDataPanel() {
        this.makeComponents();
        this.layoutComponents();
    }

    public void update(String string) {
        this.fill(string);
        this.revalidate();
        this.repaint();
    }

    public JButton getRefreshButton() {
        return this.refreshButton;
    }

    public JButton getInstallButton() {
        return this.installButton;
    }

    public JButton getUninstallButton() {
        return this.uninstallButton;
    }

    public JButton getPropertiesButton() {
        return this.propertiesButton;
    }

    public JButton getZoomButton() {
        return this.zoomButton;
    }

    public Iterable<DataDescriptor> getDataDescriptors() {
        ArrayList<DataDescriptor> arrayList = new ArrayList<DataDescriptor>();
        int n = this.table.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.table.getModel().getValueAt(i, -1);
            if (object == null || !(object instanceof DataDescriptor)) continue;
            arrayList.add((DataDescriptor)object);
        }
        return arrayList;
    }

    public Iterable<DataDescriptor> getSelectedDataDescriptors() {
        ArrayList<DataDescriptor> arrayList = new ArrayList<DataDescriptor>();
        int[] nArray = this.table.getSelectedRows();
        if (nArray != null) {
            for (int n : nArray) {
                Object object = this.table.getModel().getValueAt(n, -1);
                if (object == null || !(object instanceof DataDescriptor)) continue;
                arrayList.add((DataDescriptor)object);
            }
        }
        return arrayList;
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    protected JTable getTable() {
        return this.table;
    }

    protected JToolBar getToolBar() {
        return this.toolBar;
    }

    protected void fill(String string) {
        this.tableModel.setRowValues(null);
        FileStore fileStore = WorldWind.getDataFileStore();
        if (fileStore == null) {
            return;
        }
        List<? extends DataDescriptor> list = fileStore.findDataDescriptors(string);
        this.tableModel.setRowValues(list);
    }

    protected void makeComponents() {
        this.toolBar = new JToolBar();
        this.refreshButton = new JButton("Refresh");
        this.installButton = new JButton("Install new data");
        this.uninstallButton = new JButton("Uninstall selected");
        this.propertiesButton = new JButton("Properties");
        this.zoomButton = new JButton("Zoom to selected");
        this.refreshButton.setActionCommand(REFRESH_ACTION_COMMAND);
        this.installButton.setActionCommand(INSTALL_ACTION_COMMAND);
        this.uninstallButton.setActionCommand(UNINSTALL_ACTION_COMMAND);
        this.propertiesButton.setActionCommand(PROPERTIES_ACTION_COMMAND);
        this.zoomButton.setActionCommand(ZOOM_ACTION_COMMAND);
        this.refreshButton.addActionListener(this.actionListenerDelegate);
        this.installButton.addActionListener(this.actionListenerDelegate);
        this.uninstallButton.addActionListener(this.actionListenerDelegate);
        this.propertiesButton.addActionListener(this.actionListenerDelegate);
        this.zoomButton.addActionListener(this.actionListenerDelegate);
        this.toolBar.add(this.refreshButton);
        this.toolBar.add(this.installButton);
        this.toolBar.add(this.uninstallButton);
        this.toolBar.add(this.propertiesButton);
        this.toolBar.add(this.zoomButton);
        this.tableModel = new DataDescriptorTableModel();
        this.setupTableModel(this.tableModel);
        this.table = new JTable(this.tableModel);
        this.table.setSelectionMode(2);
        this.table.setColumnSelectionAllowed(false);
        this.scrollPane = new JScrollPane(this.table);
    }

    protected void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Installed Data")));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setBackground(this.toolBar.getBackground().darker());
        this.add((Component)this.toolBar, "North");
        this.table.getColumn(COLUMN_INSTALLED).setMaxWidth(60);
        this.table.getColumn(COLUMN_NAME).setPreferredWidth(200);
        this.table.getColumn(COLUMN_DATA_STORE_LOCATION).setPreferredWidth(100);
        this.table.getColumn(COLUMN_DATA_STORE_PATH).setPreferredWidth(100);
        this.scrollPane.setPreferredSize(new Dimension(this.scrollPane.getPreferredSize().width, 160));
        this.add((Component)this.scrollPane, "Center");
    }

    private void setupTableModel(DataDescriptorTableModel dataDescriptorTableModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        arrayList.add(COLUMN_INSTALLED);
        arrayList2.add(Boolean.class);
        arrayList3.add("gov.nasa.worldwind.avkey.Installed");
        arrayList.add(COLUMN_NAME);
        arrayList2.add(String.class);
        arrayList3.add("gov.nasa.worldwind.avkey.DatasetNameKey");
        arrayList.add(COLUMN_DATA_STORE_LOCATION);
        arrayList2.add(File.class);
        arrayList3.add("gov.nasa.worldwind.avkey.FileStoreLocation");
        arrayList.add(COLUMN_DATA_STORE_PATH);
        arrayList2.add(String.class);
        arrayList3.add("gov.nasa.worldwind.avkey.DataCacheNameKey");
        dataDescriptorTableModel.setColumnNames(arrayList);
        dataDescriptorTableModel.setColumnTypes(arrayList2);
        dataDescriptorTableModel.setColumnParameters(arrayList3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DataDescriptorTableModel
    extends AbstractTableModel {
        private List<String> columnNames = new ArrayList<String>();
        private List<Class> columnTypes = new ArrayList<Class>();
        private List<String> columnParams = new ArrayList<String>();
        private List<DataDescriptor> rowValues = new ArrayList<DataDescriptor>();

        @Override
        public int getColumnCount() {
            return this.columnParams.size();
        }

        @Override
        public int getRowCount() {
            return this.rowValues.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n < 0 || n >= this.columnNames.size()) {
                return super.getColumnName(n);
            }
            return this.columnNames.get(n);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n < 0 || n >= this.columnTypes.size()) {
                return Object.class;
            }
            return this.columnTypes.get(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n < 0 || n >= this.rowValues.size()) {
                return null;
            }
            DataDescriptor dataDescriptor = this.rowValues.get(n);
            if (dataDescriptor == null) {
                return null;
            }
            if (n2 == -1) {
                return dataDescriptor;
            }
            if (n2 < 0 || n2 >= this.columnParams.size()) {
                return null;
            }
            String string = this.columnParams.get(n2);
            if (string == null) {
                return null;
            }
            return dataDescriptor.getValue(string);
        }

        public List<String> getColumnNames() {
            return Collections.unmodifiableList(this.columnNames);
        }

        public void setColumnNames(Iterable<? extends String> iterable) {
            this.columnNames.clear();
            if (iterable != null) {
                for (String string : iterable) {
                    this.columnNames.add(string);
                }
            }
            this.fireTableRowsUpdated(-1, -1);
        }

        public List<Class> getColumnTypes() {
            return Collections.unmodifiableList(this.columnTypes);
        }

        public void setColumnTypes(Iterable<Class<?>> iterable) {
            this.columnTypes.clear();
            if (iterable != null) {
                for (Class<?> clazz : iterable) {
                    this.columnTypes.add(clazz);
                }
            }
            this.fireTableStructureChanged();
        }

        public List<String> getColumnParameters() {
            return Collections.unmodifiableList(this.columnParams);
        }

        public void setColumnParameters(Iterable<? extends String> iterable) {
            this.columnParams.clear();
            if (iterable != null) {
                for (String string : iterable) {
                    this.columnParams.add(string);
                }
            }
            this.fireTableStructureChanged();
        }

        public List<DataDescriptor> getRowValues() {
            return Collections.unmodifiableList(this.rowValues);
        }

        public void setRowValues(Iterable<? extends DataDescriptor> iterable) {
            this.rowValues.clear();
            if (iterable != null) {
                for (DataDescriptor dataDescriptor : iterable) {
                    this.rowValues.add(dataDescriptor);
                }
            }
            this.fireTableDataChanged();
        }
    }

    private static class ActionListenerDelegate
    implements ActionListener {
        private InstalledDataPanel panel;

        public ActionListenerDelegate(InstalledDataPanel installedDataPanel) {
            this.panel = installedDataPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = this.panel.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ActionListener.class) continue;
                ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
            }
        }
    }
}

