/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.Mars.MDIMLayer;
import gov.nasa.worldwind.layers.Mars.MOCLayer;
import gov.nasa.worldwind.layers.Mars.MolaColorASULayer;
import gov.nasa.worldwind.layers.Mars.MolaColoredJPLLayer;
import gov.nasa.worldwind.layers.Mars.THEMISColorLayer;
import gov.nasa.worldwind.layers.Mars.THEMISLayer;
import gov.nasa.worldwind.layers.SkyGradientLayer;
import java.awt.Color;

public class Mars
extends ApplicationTemplate {
    private static final String LAYERS = "gov.nasa.worldwind.layers.StarsLayer,gov.nasa.worldwind.layers.SkyGradientLayer,gov.nasa.worldwind.layers.Mars.MOCColorizedBaseLayer,gov.nasa.worldwind.layers.Mars.MOCLayer,gov.nasa.worldwind.layers.Mars.MOCColorizedLayer,gov.nasa.worldwind.layers.Mars.MolaColorASULayer,gov.nasa.worldwind.layers.Mars.MolaColoredJPLLayer,gov.nasa.worldwind.layers.Mars.MDIMLayer,gov.nasa.worldwind.layers.Mars.THEMISLayer,gov.nasa.worldwind.layers.Mars.THEMISColorLayer,gov.nasa.worldwind.layers.ScalebarLayer,gov.nasa.worldwind.layers.CompassLayer";

    public static void main(String[] stringArray) {
        Configuration.setValue("gov.nasa.worldwind.avkey.GlobeClassName", gov.nasa.worldwind.globes.Mars.class.getName());
        Configuration.setValue("gov.nasa.worldwind.avkey.MarsElevationModelConfigFile", "config/MarsElevationModel.xml");
        Configuration.setValue("gov.nasa.worldwind.avkey.LayerClassNames", LAYERS);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialAltitude", 1.0E7);
        ApplicationTemplate.start("World Wind Mars", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            LayerList layerList = this.getWwd().getModel().getLayers();
            for (Layer layer : layerList) {
                if (layer instanceof SkyGradientLayer) {
                    SkyGradientLayer skyGradientLayer = (SkyGradientLayer)layer;
                    skyGradientLayer.setHorizonColor(new Color(236, 223, 174));
                    skyGradientLayer.setZenithColor(new Color(183, 117, 3));
                    skyGradientLayer.setAtmosphereThickness(40000.0);
                    continue;
                }
                if (layer instanceof MOCLayer || layer instanceof MolaColorASULayer || layer instanceof MolaColoredJPLLayer || layer instanceof THEMISLayer || layer instanceof MDIMLayer) {
                    layer.setEnabled(false);
                    continue;
                }
                if (!(layer instanceof THEMISColorLayer)) continue;
                layer.setOpacity(0.7);
                layer.setEnabled(false);
            }
            this.getLayerPanel().update(this.getWwd());
        }
    }
}

