/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.ScreenImage;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ScreenImageDragging
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("Screen Image Dragging", AppFrame.class);
    }

    private static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() throws IOException, ParserConfigurationException, SAXException {
            super(true, true, false);
            final ScreenImage screenImage = new ScreenImage();
            screenImage.setImageSource(ImageIO.read(new File("src/images/32x32-icon-nasa.png")));
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.setName("Screen Image");
            renderableLayer.addRenderable(screenImage);
            this.getWwd().getModel().getLayers().add(renderableLayer);
            this.getLayerPanel().update(this.getWwd());
            this.getWwd().getInputHandler().addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseDragged(MouseEvent mouseEvent) {
                    screenImage.setScreenLocation(mouseEvent.getPoint());
                    mouseEvent.consume();
                }
            });
        }
    }
}

