/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.AirspaceLayer;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.airspaces.AbstractAirspace;
import gov.nasa.worldwind.render.airspaces.Cake;
import gov.nasa.worldwind.render.airspaces.CappedCylinder;
import gov.nasa.worldwind.render.airspaces.Curtain;
import gov.nasa.worldwind.render.airspaces.Route;
import java.awt.Color;
import java.util.Arrays;

public class StressAirspace {
    private AirspaceLayer airspaceLayer = new AirspaceLayer();
    public static final String DRAW_AIRSPACE_EXTENT = "gov.nasa.worldwind.avkey.DrawAirspaceExtent";
    public static final String DRAW_AIRSPACE_WIREFRAME = "gov.nasa.worldwind.avkey.DrawAirspaceWireframe";
    public static final String AIRSPACE_LAYER_NAME = "Airspaces";
    private int counter = 0;
    private static final Material[] materials = new Material[]{new Material(Color.ORANGE), new Material(Color.YELLOW), new Material(Color.GREEN), new Material(Color.MAGENTA), new Material(Color.CYAN), new Material(Color.LIGHT_GRAY), new Material(Color.GRAY), new Material(Color.DARK_GRAY), new Material(Color.BLACK), new Material(Color.RED), new Material(Color.PINK), new Material(Color.BLUE)};

    public StressAirspace() {
        this.airspaceLayer.setName(AIRSPACE_LAYER_NAME);
        String string = Configuration.getStringValue(DRAW_AIRSPACE_EXTENT);
        if (string != null) {
            this.airspaceLayer.setDrawExtents(Boolean.parseBoolean(string));
        }
        if ((string = Configuration.getStringValue(DRAW_AIRSPACE_WIREFRAME)) != null) {
            this.airspaceLayer.setDrawWireframe(Boolean.parseBoolean(string));
        }
    }

    public void clearAirspace() {
        this.counter = 0;
        this.airspaceLayer.removeAllAirspaces();
    }

    public AirspaceLayer getAirspaceLayer() {
        return this.airspaceLayer;
    }

    public int size() {
        return this.counter;
    }

    public void addAirspace(Position position) {
        AbstractAirspace abstractAirspace;
        switch (this.size() % 4) {
            case 0: {
                CappedCylinder cappedCylinder = new CappedCylinder();
                cappedCylinder.getAttributes().setMaterial(materials[this.size() % materials.length]);
                cappedCylinder.getAttributes().setOpacity(0.8);
                cappedCylinder.setCenter(position);
                double d = 30000.0 + 30000.0 * Math.random();
                cappedCylinder.setRadius(d);
                double d2 = 10000.0 + 100000.0 * Math.random();
                cappedCylinder.setAltitudes(5000.0, d2);
                cappedCylinder.setTerrainConforming(true, true);
                abstractAirspace = cappedCylinder;
                break;
            }
            case 1: {
                Curtain curtain = new Curtain();
                curtain.getAttributes().setMaterial(materials[this.size() % materials.length]);
                double d = position.getLatitude().getDegrees() > 0.0 ? position.getLatitude().getDegrees() - 1.0 : position.getLatitude().getDegrees() + 1.0;
                double d3 = position.getLongitude().getDegrees() > 0.0 ? position.getLongitude().getDegrees() - 1.0 : position.getLongitude().getDegrees() + 1.0;
                double d4 = d > 0.0 ? d - 1.0 : d + 1.0;
                curtain.setLocations(Arrays.asList(position, LatLon.fromDegrees(d, d3), LatLon.fromDegrees(d4, d3)));
                curtain.setAltitudes(1000.0, 100000.0);
                curtain.setTerrainConforming(true, false);
                abstractAirspace = curtain;
                break;
            }
            case 2: {
                Cake cake = new Cake();
                cake.getAttributes().setMaterial(materials[this.size() % materials.length]);
                cake.getAttributes().setOpacity(0.8);
                cake.setLayers(Arrays.asList(new Cake.Layer(position, 20000.0, Angle.fromDegrees(190.0), Angle.fromDegrees(170.0), 10000.0, 20000.0), new Cake.Layer(position, 25000.0, Angle.fromDegrees(190.0), Angle.fromDegrees(90.0), 21000.0, 30000.0), new Cake.Layer(position, 12500.0, Angle.fromDegrees(270.0), Angle.fromDegrees(60.0), 32000.0, 39000.0)));
                cake.getLayers().get(0).setTerrainConforming(false, false);
                cake.getLayers().get(1).setTerrainConforming(false, false);
                cake.getLayers().get(2).setTerrainConforming(false, true);
                abstractAirspace = cake;
                break;
            }
            default: {
                Route route = new Route();
                route.getAttributes().setOpacity(0.8);
                route.getAttributes().setMaterial(materials[this.size() % materials.length]);
                route.setAltitudes(5000.0, 20000.0);
                route.setWidth(20000.0);
                double d = position.getLatitude().getDegrees() > 0.0 ? position.getLatitude().getDegrees() - 1.0 : position.getLatitude().getDegrees() + 1.0;
                double d5 = position.getLongitude().getDegrees() > 0.0 ? position.getLongitude().getDegrees() - 1.0 : position.getLongitude().getDegrees() + 1.0;
                double d6 = d > 0.0 ? d - 1.0 : d + 1.0;
                route.setLocations(Arrays.asList(position, LatLon.fromDegrees(d, d5), LatLon.fromDegrees(d6, d5)));
                route.setTerrainConforming(false, true);
                abstractAirspace = route;
            }
        }
        this.airspaceLayer.addAirspace(abstractAirspace);
        ++this.counter;
    }
}

