/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.RenderingEvent;
import gov.nasa.worldwind.event.RenderingListener;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.examples.StressWWJIterator;
import gov.nasa.worldwind.layers.MarkerLayer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;

public class StressWWJApp
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Stress Test", AppFrame.class);
    }

    private static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, true);
            final StressWWJIterator stressWWJIterator = new StressWWJIterator(this);
            MarkerLayer markerLayer = new MarkerLayer();
            markerLayer.setOverrideMarkerElevation(true);
            markerLayer.setKeepSeparated(false);
            markerLayer.setElevation(500.0);
            markerLayer.setMarkers(stressWWJIterator.getMarkers());
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), markerLayer);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), stressWWJIterator.getAirspaceLayer());
            this.getWwd().addRenderingListener(new RenderingListener(){

                public void stageChanged(RenderingEvent renderingEvent) {
                    if (renderingEvent.getSource() instanceof WorldWindow) {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                stressWWJIterator.updateStressStatsPanel();
                            }
                        });
                    }
                }
            });
            this.getLayerPanel().add((Component)stressWWJIterator.makeControlPanel(), "South");
            this.getLayerPanel().update(this.getWwd());
            this.setCursor(Cursor.getPredefinedCursor(3));
            stressWWJIterator.runWWJIterator();
        }
    }
}

