/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.ViewStateIterator;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.examples.StressAirspace;
import gov.nasa.worldwind.examples.StressWMS;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.AirspaceLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.markers.BasicMarker;
import gov.nasa.worldwind.render.markers.BasicMarkerAttributes;
import gov.nasa.worldwind.render.markers.Marker;
import gov.nasa.worldwind.render.markers.MarkerAttributes;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.EyePositionIterator;
import gov.nasa.worldwind.view.FlyToOrbitViewStateIterator;
import gov.nasa.worldwind.view.OrbitView;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StressWWJIterator
implements ActionListener {
    private WorldWindowGLCanvas wwd;
    private ApplicationTemplate.AppFrame frame;
    private int viewIterations = 0;
    private long totIterations = 0L;
    private int markerIterations = 0;
    private int numRounds = 0;
    private int airspaceIterations = 0;
    private static ArrayList<Marker> markers = new ArrayList();
    private static StressAirspace airspace;
    private int wmsIterations = 0;
    private int wmsLayerCount = 0;
    private StressWMS stressWMS = null;
    private ArrayList<Layer> addedLayers = new ArrayList();
    private long maxMemUsed = 0L;
    private long currentMemUsed = 0L;
    private int maxViewIterations = 1;
    private int maxMarkerIterations = 10;
    private int numMarkersPerIteration = 1000;
    private int maxAirspaceIterations = 10;
    private int numAirspacePerIteration = 500;
    private int timePerIteration = 45000;
    private int maxWMSIterations = 2;
    private final long maxCacheCap = 220000000L;
    private final long minCacheCap = 180000000L;
    private final long maxCacheLowCap = 180000000L;
    private final long minCacheLowCap = 10000000L;
    private boolean minimizeWindow = false;
    private String externalWMSURL = "http://neowms.sci.gsfc.nasa.gov/wms/wms";
    public static String PROPERTIES_FILE;
    public static String VIEW_ITERATIONS_KEY;
    public static String TIME_PER_ITERTION_KEY;
    public static String MARKER_ITERATIONS_KEY;
    public static String AIRSPACE_ITERATIONS_KEY;
    public static String MARKERS_PER_ITERATION_KEY;
    public static String AIRSPACES_PER_ITERATION_KEY;
    public static String WMS_ITERATIONS_KEY;
    public static String MINIMIZE_WINDOW_KEY;
    public static String EXTERNAL_WMS_KEY;
    private static final String FREE_MEM_STR = "Free memory: ";
    private static final String TOTAL_MEM_STR = "Total memory: ";
    private static final String TOT_ITERATIONS_STR = "Total iterations: ";
    private static final String NUM_ROUNDS_STR = "Number of completed rounds: ";
    private static final String NUM_ACTIVE_MARKERS_STR = "# Active Markers: ";
    private static final String NUM_VIEW_ITERATIONS_STR = "View iterations: ";
    private static final String NUM_MARKER_ITERATIONS_STR = "Marker iterations: ";
    private JLabel freeMemLbl = new JLabel("Free memory: ");
    private JLabel totalMemLbl = new JLabel("Total memory: ");
    private JLabel iterationsLbl = new JLabel("Total iterations: ");
    private JLabel roundsLbl = new JLabel("Number of completed rounds: ");
    private JLabel viewLbl = new JLabel("View iterations: 0 of " + this.maxViewIterations);
    private JLabel markerLbl = new JLabel("Marker iterations: 0 of " + this.maxMarkerIterations);
    private JLabel airspaceLbl = new JLabel("Airspace iterations: 0 of " + this.maxAirspaceIterations);
    private JLabel numObjectsLbl = new JLabel();
    private JLabel statusLbl = new JLabel("status:");
    private JLabel wmsLbl = new JLabel("WMS Iterations " + this.wmsIterations + " of " + this.maxWMSIterations);
    private static final MarkerAttributes[] attrs;

    public StressWWJIterator(ApplicationTemplate.AppFrame appFrame) {
        this.frame = appFrame;
        this.wwd = this.frame.getWwd();
        this.readPropertiesFile();
        airspace = new StressAirspace();
        try {
            if (this.maxWMSIterations > 0) {
                this.stressWMS = new StressWMS(this.externalWMSURL);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            Logging.logger().severe("Error initializing WMS component: " + uRISyntaxException.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        long l = (long)this.timePerIteration / 2L;
        this.nextViewState(l);
    }

    private void readPropertiesFile() {
        StressTestConfiguration stressTestConfiguration = new StressTestConfiguration(PROPERTIES_FILE);
        this.maxViewIterations = stressTestConfiguration.getIntegerValue(VIEW_ITERATIONS_KEY, this.maxViewIterations);
        this.maxMarkerIterations = stressTestConfiguration.getIntegerValue(MARKER_ITERATIONS_KEY, this.maxMarkerIterations);
        this.timePerIteration = stressTestConfiguration.getIntegerValue(TIME_PER_ITERTION_KEY, this.timePerIteration);
        this.maxAirspaceIterations = stressTestConfiguration.getIntegerValue(AIRSPACE_ITERATIONS_KEY, this.maxAirspaceIterations);
        this.numMarkersPerIteration = stressTestConfiguration.getIntegerValue(MARKERS_PER_ITERATION_KEY, this.numMarkersPerIteration);
        this.numAirspacePerIteration = stressTestConfiguration.getIntegerValue(AIRSPACES_PER_ITERATION_KEY, this.numAirspacePerIteration);
        this.maxWMSIterations = stressTestConfiguration.getIntegerValue(WMS_ITERATIONS_KEY, this.maxWMSIterations);
        String string = stressTestConfiguration.getStringValue(MINIMIZE_WINDOW_KEY);
        if (string != null) {
            this.minimizeWindow = string.startsWith("t") || string.startsWith("T");
        }
    }

    public void runWWJIterator() {
        Timer timer = new Timer(this.timePerIteration, this);
        timer.setInitialDelay(5000);
        Logging.logger().info("Starting Stress Iterator");
        timer.start();
    }

    public ArrayList<Marker> getMarkers() {
        return markers;
    }

    public AirspaceLayer getAirspaceLayer() {
        return airspace.getAirspaceLayer();
    }

    public void updateStressStatsPanel() {
        long l = Runtime.getRuntime().freeMemory() / 0x100000L;
        long l2 = Runtime.getRuntime().totalMemory() / 0x100000L;
        this.currentMemUsed = l2 - l;
        this.maxMemUsed = Math.max(this.currentMemUsed, this.maxMemUsed);
        this.freeMemLbl.setText(FREE_MEM_STR + l + "mb");
        this.totalMemLbl.setText(TOTAL_MEM_STR + l2 + "mb");
        this.iterationsLbl.setText(TOT_ITERATIONS_STR + this.totIterations);
        this.roundsLbl.setText(NUM_ROUNDS_STR + this.numRounds);
        this.viewLbl.setText(NUM_VIEW_ITERATIONS_STR + this.viewIterations + " of " + this.maxViewIterations);
        this.markerLbl.setText(NUM_MARKER_ITERATIONS_STR + this.markerIterations + " of " + this.maxMarkerIterations);
        if (markers.size() > 0) {
            this.numObjectsLbl.setText(NUM_ACTIVE_MARKERS_STR + markers.size());
        } else if (airspace.size() > 0) {
            this.numObjectsLbl.setText("Airspace objects: " + airspace.size());
        } else {
            this.numObjectsLbl.setText("no surface objects");
        }
        this.airspaceLbl.setText("Airspace iterations: " + this.airspaceIterations + " of " + this.maxAirspaceIterations);
        this.wmsLbl.setText("WMS iterations: " + this.wmsIterations + " of " + this.maxWMSIterations);
    }

    private void nextViewState(long l) {
        if (this.wwd != null && this.wwd.getView() != null && this.wwd.getView() instanceof OrbitView && this.wwd.getModel() != null && this.wwd.getModel().getGlobe() != null) {
            String string;
            Globe globe = this.wwd.getModel().getGlobe();
            if (this.viewIterations < this.maxViewIterations) {
                ++this.viewIterations;
                ++this.totIterations;
                string = "Round: " + this.numRounds + " | Total Iterations: " + this.totIterations + " | View Iterations: " + this.viewIterations;
                Position position = StressWWJIterator.randomPosition(globe);
                double d = position.getElevation() + 2000.0 + 2000.0 * Math.random();
                Position position2 = new Position(position, d);
                this.moveToandAlter(l, position2, this.viewIterations);
            } else if (this.markerIterations < this.maxMarkerIterations) {
                ++this.markerIterations;
                ++this.totIterations;
                string = "Round: " + this.numRounds + " | Total Iterations: " + this.totIterations + " | Marker Iterations: " + this.markerIterations;
                Position position = null;
                this.statusLbl.setText("status:  Adding Markers");
                final ArrayList<BasicMarker> arrayList = new ArrayList<BasicMarker>();
                for (int i = 0; i < this.numMarkersPerIteration; ++i) {
                    position = StressWWJIterator.randomPosition(globe);
                    double d = position.getLatitude().getDegrees();
                    double d2 = position.getLongitude().getDegrees();
                    BasicMarker basicMarker = new BasicMarker(Position.fromDegrees(d, d2, 0.0), attrs[(int)(Math.abs(d) + Math.abs(d2)) % attrs.length]);
                    basicMarker.setPosition(Position.fromDegrees(d, d2, 0.0));
                    basicMarker.setHeading(Angle.fromDegrees(d * 5.0));
                    arrayList.add(basicMarker);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        markers.addAll(arrayList);
                    }
                });
                Position position3 = new Position(position, 50000.0);
                this.moveToandAlter(l, position3, this.markerIterations);
            } else if (this.airspaceIterations < this.maxAirspaceIterations) {
                this.statusLbl.setText("status:  Adding Airspace objects");
                if (this.airspaceIterations == 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (markers.size() > 0) {
                                markers.clear();
                            }
                        }
                    });
                }
                System.gc();
                ++this.airspaceIterations;
                ++this.totIterations;
                string = "Round: " + this.numRounds + " | Total Iterations: " + this.totIterations + " | Airspace Iterations: " + this.airspaceIterations;
                Position position = null;
                for (int i = 0; i < this.numAirspacePerIteration; ++i) {
                    position = StressWWJIterator.randomPosition(globe);
                    airspace.addAirspace(position);
                }
                this.statusLbl.setText("status: Moving to new location");
                Position position4 = new Position(position, 1000000.0);
                this.moveToandAlter(l, position4, this.airspaceIterations);
            } else if (this.wmsIterations < this.maxWMSIterations) {
                if (this.wmsIterations == 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (markers.size() > 0) {
                                markers.clear();
                            }
                            if (airspace.size() > 0) {
                                airspace.clearAirspace();
                            }
                        }
                    });
                }
                System.gc();
                ++this.wmsIterations;
                ++this.totIterations;
                string = "Round: " + this.numRounds + " | Total Iterations: " + this.totIterations + " | WMS Iterations: " + this.wmsIterations;
                if (this.wmsLayerCount <= this.stressWMS.size() - 1 && this.wmsIterations % 3 == 1) {
                    this.statusLbl.setText("status:  Adding WMS Layer");
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StressWWJIterator.this.statusLbl.setText("status:  Adding WMS Layer");
                            Layer layer = StressWWJIterator.this.stressWMS.getLayer(StressWWJIterator.this.wmsLayerCount);
                            StressWWJIterator.this.addedLayers.add(layer);
                            StressWWJIterator.this.wmsLayerCount++;
                            ApplicationTemplate.insertBeforePlacenames(StressWWJIterator.this.wwd, layer);
                            StressWWJIterator.this.frame.getLayerPanel().update(StressWWJIterator.this.wwd);
                        }
                    });
                    this.moveToDefaut(l);
                } else {
                    Position position = StressWWJIterator.randomPosition(globe);
                    double d = position.getElevation() + 1000000.0;
                    Position position5 = new Position(position, d);
                    this.moveToandAlter(l, position5, 1);
                }
            } else {
                this.statusLbl.setText("status: Reseting for next round");
                this.moveToDefaut(l);
                this.viewIterations = 0;
                ++this.numRounds;
                this.markerIterations = 0;
                this.airspaceIterations = 0;
                this.wmsIterations = 0;
                this.wmsLayerCount = 0;
                string = "Round: " + this.numRounds + " | Total Iterations: " + this.totIterations;
                if (markers.size() > 0) {
                    markers.clear();
                }
                if (airspace.size() > 0) {
                    airspace.clearAirspace();
                }
                if (this.addedLayers.size() > 0) {
                    this.wwd.getModel().getLayers().removeAll(this.addedLayers);
                    this.addedLayers.clear();
                }
                System.gc();
                this.wwd.redraw();
                this.frame.getLayerPanel().update(this.wwd);
                long l2 = new Double((double)this.wwd.getTextureCache().getCapacity() * 0.95).longValue();
                if (l2 < 180000000L) {
                    this.wwd.getTextureCache().setCapacity(220000000L);
                } else {
                    this.wwd.getTextureCache().setCapacity(l2);
                }
                l2 = new Double((double)this.wwd.getTextureCache().getLowWater() * 0.95).longValue();
                if (l2 < 10000000L) {
                    this.wwd.getTextureCache().setLowWater(180000000L);
                } else {
                    this.wwd.getTextureCache().setLowWater(l2);
                }
                if (this.minimizeWindow) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            for (int i = 0; i < 5; ++i) {
                                try {
                                    Thread.sleep(500L);
                                    StressWWJIterator.this.frame.setVisible(false);
                                    Thread.sleep(500L);
                                    StressWWJIterator.this.frame.setVisible(true);
                                    continue;
                                }
                                catch (InterruptedException interruptedException) {
                                    Logging.logger().severe("Error minimizing/maximizing WWJ window: " + interruptedException.getMessage());
                                    StressWWJIterator.this.frame.setVisible(true);
                                    break;
                                }
                            }
                        }
                    });
                }
            }
            Logging.logger().info(string + " | Current Memory Used: " + this.currentMemUsed + "mb | Max Memory Used: " + this.maxMemUsed + "mb");
        }
    }

    private void moveToDefaut(long l) {
        Position position = new Position(Angle.fromDegreesLatitude(22.0), Angle.fromDegreesLongitude(-47.0), 1.5E7);
        OrbitView orbitView = (OrbitView)this.wwd.getView();
        orbitView.applyStateIterator(this.nextVSI(l, position, 1));
    }

    private void moveToandAlter(long l, Position position, int n) {
        OrbitView orbitView = (OrbitView)this.wwd.getView();
        this.statusLbl.setText("status: Moving to new location");
        orbitView.applyStateIterator(this.nextVSI(l, position, n));
    }

    private ViewStateIterator nextVSI(long l, Position position, int n) {
        ViewStateIterator viewStateIterator;
        OrbitView orbitView = (OrbitView)this.wwd.getView();
        switch (n % 10) {
            case 0: {
                viewStateIterator = new EyePositionIterator(l, orbitView.getCenterPosition(), position);
                break;
            }
            case 2: {
                viewStateIterator = FlyToOrbitViewStateIterator.createPanToIterator(this.wwd.getModel().getGlobe(), orbitView.getCenterPosition(), position, orbitView.getHeading(), Angle.fromDegrees(360.0 * Math.random()), orbitView.getPitch(), Angle.fromDegrees(0.0), orbitView.getZoom(), position.getElevation(), l, true);
                break;
            }
            case 4: {
                viewStateIterator = FlyToOrbitViewStateIterator.createPanToIterator(this.wwd.getModel().getGlobe(), orbitView.getCenterPosition(), position, orbitView.getHeading(), Angle.fromDegrees(0.0), orbitView.getPitch(), Angle.fromDegrees(70.0 * Math.random()), orbitView.getZoom(), position.getElevation(), l, true);
                break;
            }
            case 6: {
                viewStateIterator = FlyToOrbitViewStateIterator.createPanToIterator(this.wwd.getModel().getGlobe(), orbitView.getCenterPosition(), position, orbitView.getHeading(), Angle.fromDegrees(360.0 * Math.random()), orbitView.getPitch(), Angle.fromDegrees(70.0 * Math.random()), orbitView.getZoom(), position.getElevation(), l, true);
                break;
            }
            default: {
                viewStateIterator = FlyToOrbitViewStateIterator.createPanToIterator(this.wwd.getModel().getGlobe(), orbitView.getCenterPosition(), position, orbitView.getHeading(), Angle.fromDegrees(0.0), orbitView.getPitch(), Angle.fromDegrees(0.0), orbitView.getZoom(), position.getElevation(), l, true);
            }
        }
        return viewStateIterator;
    }

    private ViewStateIterator alterVSI(long l) {
        OrbitView orbitView = (OrbitView)this.wwd.getView();
        Globe globe = this.wwd.getModel().getGlobe();
        double d = 360.0 * Math.random();
        double d2 = 80.0 * Math.random();
        return FlyToOrbitViewStateIterator.createPanToIterator(globe, orbitView.getCenterPosition(), orbitView.getCenterPosition(), orbitView.getHeading(), Angle.fromDegrees(d), Angle.fromDegrees(0.0), Angle.fromDegrees(d2), orbitView.getZoom(), orbitView.getZoom(), l, true);
    }

    private static Position randomPosition(Globe globe) {
        double d;
        double d2;
        double d3;
        do {
            double d4 = Math.random();
            d2 = 140.0 * d4 - 70.0;
            d4 = Math.random();
            d = 360.0 * d4 - 180.0;
        } while ((d3 = globe.getElevation(Angle.fromDegreesLatitude(d2), Angle.fromDegreesLongitude(d))) < 1.0);
        return Position.fromDegrees(d2, d, d3);
    }

    public JPanel makeControlPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 5, 5));
        jPanel.add(new JLabel("Started: " + new Date().toString()));
        jPanel.add(this.totalMemLbl);
        jPanel.add(this.freeMemLbl);
        jPanel.add(new JSeparator(0));
        jPanel.add(this.viewLbl);
        jPanel.add(this.markerLbl);
        jPanel.add(this.airspaceLbl);
        jPanel.add(this.wmsLbl);
        jPanel.add(this.numObjectsLbl);
        jPanel.add(new JSeparator(0));
        jPanel.add(this.roundsLbl);
        jPanel.add(this.iterationsLbl);
        this.statusLbl.setForeground(Color.BLUE);
        jPanel.add(this.statusLbl);
        jPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Stress Test Statistics")));
        return jPanel;
    }

    static {
        PROPERTIES_FILE = "config/stresswwj.properties";
        VIEW_ITERATIONS_KEY = "gov.nasa.worldwind.avkey.ViewIterations";
        TIME_PER_ITERTION_KEY = "gov.nasa.worldwind.avkey.TimePerIteration";
        MARKER_ITERATIONS_KEY = "gov.nasa.worldwind.avkey.MarkerIterations";
        AIRSPACE_ITERATIONS_KEY = "gov.nasa.worldwind.avkey.AirspaceIterations";
        MARKERS_PER_ITERATION_KEY = "gov.nasa.worldwind.avkey.MarkersPerIteration";
        AIRSPACES_PER_ITERATION_KEY = "gov.nasa.worldwind.avkey.AirspacesPerIteration";
        WMS_ITERATIONS_KEY = "gov.nasa.worldwind.avkey.WMSIterations";
        MINIMIZE_WINDOW_KEY = "gov.nasa.worldwind.avkey.MinimizeWindow";
        EXTERNAL_WMS_KEY = "gov.nasa.worldwind.avkey.ExternalWMS";
        attrs = new BasicMarkerAttributes[]{new BasicMarkerAttributes(Material.DARK_GRAY, "gov.nasa.worldwind.render.markers.Sphere", 1.0, 10.0, 5.0), new BasicMarkerAttributes(Material.RED, "gov.nasa.worldwind.render.markers.Cone", 0.7), new BasicMarkerAttributes(Material.YELLOW, "gov.nasa.worldwind.render.markers.Cylinder", 0.9), new BasicMarkerAttributes(Material.CYAN, "gov.nasa.worldwind.render.markers.Sphere", 0.7), new BasicMarkerAttributes(Material.GREEN, "gov.nasa.worldwind.render.markers.Cone", 1.0), new BasicMarkerAttributes(Material.PINK, "gov.nasa.worldwind.render.markers.DirectionalSphere", 0.8), new BasicMarkerAttributes(Material.BLUE, "gov.nasa.worldwind.render.markers.Cone", 0.6)};
    }

    private class StressTestConfiguration {
        private static final String DEFAULT_LOGGER_NAME = "gov.nasa.worldwind";
        private Properties properties = new Properties();

        public StressTestConfiguration(String string) {
            this.readProperties(string);
        }

        private void readProperties(String string) {
            try {
                InputStream inputStream = null;
                File file = new File(string);
                if (file.exists()) {
                    try {
                        inputStream = new FileInputStream(file);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        String string2 = Logging.getMessage("Configuration.LocalConfigFileNotFound", string);
                        Logging.logger().finest(string2);
                    }
                }
                if (inputStream == null) {
                    inputStream = this.getClass().getResourceAsStream("/" + string);
                }
                if (inputStream == null) {
                    Logging.logger().log(Level.WARNING, "Configuration.UnavailablePropsFile", string);
                }
                if (inputStream != null) {
                    this.properties.load(inputStream);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                Logging.logger(DEFAULT_LOGGER_NAME).log(Level.WARNING, "Configuration.UnavailablePropsFile", string);
            }
            catch (IOException iOException) {
                Logging.logger(DEFAULT_LOGGER_NAME).log(Level.SEVERE, "Configuration.ExceptionReadingPropsFile", iOException);
            }
            catch (Exception exception) {
                Logging.logger(DEFAULT_LOGGER_NAME).log(Level.SEVERE, "Configuration.ExceptionReadingPropsFile", exception);
            }
        }

        public synchronized Integer getIntegerValue(String string, Integer n) {
            Integer n2 = this.getIntegerValue(string);
            return n2 != null ? n2 : n;
        }

        public synchronized Integer getIntegerValue(String string) {
            String string2 = this.getStringValue(string);
            if (string2 == null) {
                return null;
            }
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Logging.logger().log(Level.SEVERE, "Configuration.ConversionError", string2);
                return null;
            }
        }

        public String getStringValue(String string, String string2) {
            String string3 = this.getStringValue(string);
            return string3 != null ? string3 : string2;
        }

        public synchronized String getStringValue(String string) {
            return this.properties.getProperty(string);
        }
    }
}

