/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.layers.SurfaceImageLayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SurfaceImageViewer
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Surface Images", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private JFileChooser fileChooser = new JFileChooser();
        private JSlider opacitySlider;
        private SurfaceImageLayer layer;
        private JLabel statusLabel = new JLabel("status: ready");
        Action openElevationsAction = new AbstractAction("Open Elevation File..."){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                    }
                });
                thread.setPriority(1);
                thread.start();
            }
        };
        Action openImageAction = new AbstractAction("Open Image File..."){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = AppFrame.this.fileChooser.showOpenDialog(AppFrame.this);
                if (n != 0) {
                    return;
                }
                final File file = AppFrame.this.fileChooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        try {
                            AppFrame.this.statusLabel.setText("status: Loading image");
                            AppFrame.this.layer.addImage(file.getAbsolutePath());
                            AppFrame.this.getWwd().repaint();
                            AppFrame.this.statusLabel.setText("status: ready");
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                });
                thread.setPriority(1);
                thread.start();
            }
        };

        public AppFrame() {
            super(true, true, false);
            try {
                this.layer = new SurfaceImageLayer();
                this.layer.setOpacity(1.0);
                this.layer.setPickEnabled(false);
                this.layer.setName("Surface Images");
                ApplicationTemplate.insertBeforeCompass(this.getWwd(), this.layer);
                this.getLayerPanel().add((Component)this.makeControlPanel(), "South");
                this.getLayerPanel().update(this.getWwd());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private JPanel makeControlPanel() {
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 5, 5));
            JButton jButton = new JButton(this.openImageAction);
            jPanel.add(jButton);
            this.opacitySlider = new JSlider();
            this.opacitySlider.setMaximum(100);
            this.opacitySlider.setValue((int)(this.layer.getOpacity() * 100.0));
            this.opacitySlider.setEnabled(true);
            this.opacitySlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    int n = AppFrame.this.opacitySlider.getValue();
                    AppFrame.this.layer.setOpacity((double)n / 100.0);
                    AppFrame.this.getWwd().repaint();
                }
            });
            JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
            jPanel2.setBorder(new EmptyBorder(0, 10, 0, 0));
            jPanel2.add((Component)new JLabel("Opacity"), "West");
            jPanel2.add((Component)this.opacitySlider, "Center");
            jPanel.add(jPanel2);
            JButton jButton2 = new JButton(this.openElevationsAction);
            jPanel.add(jButton2);
            jPanel.add(this.statusLabel);
            jPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
            return jPanel;
        }
    }
}

