/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.event.PositionEvent;
import gov.nasa.worldwind.event.PositionListener;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.MarkerLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.markers.BasicMarker;
import gov.nasa.worldwind.render.markers.BasicMarkerAttributes;
import gov.nasa.worldwind.render.markers.Marker;
import gov.nasa.worldwind.util.SpatialTree;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class TreeFiltering
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Filtering by Region", AppFrame.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyMarkerLayer
    extends MarkerLayer {
        private static final double[] REGION_SIZES = new double[]{5.0, 2.0};
        private static final long TIME_LIMIT = 5L;
        private SpatialTree.MarkerTree database;
        private Position position;
        private Iterable<Marker> markers;

        public MyMarkerLayer(SpatialTree.MarkerTree markerTree) {
            this.database = markerTree;
            this.setOverrideMarkerElevation(true);
            this.setKeepSeparated(false);
        }

        public void setCursorLocation(Position position) {
            this.position = position;
        }

        @Override
        protected void draw(DrawContext drawContext, Point point) {
            if (this.position == null) {
                return;
            }
            if (!this.isPickEnabled() || drawContext.isPickingMode() || this.markers == null) {
                this.markers = this.getVisibleMarkers(drawContext);
            }
            this.setMarkers(this.markers);
            super.draw(drawContext, point);
        }

        private Iterable<Marker> getVisibleMarkers(DrawContext drawContext) {
            ArrayList<Marker> arrayList = new ArrayList<Marker>();
            for (Sector sector : drawContext.getVisibleSectors(REGION_SIZES, 5L, this.computeSector())) {
                this.database.getItems(sector, arrayList);
            }
            return arrayList;
        }

        private Sector computeSector() {
            double d = 5.0;
            double d2 = this.position.getLatitude().degrees;
            double d3 = this.position.getLongitude().degrees;
            double d4 = Math.max(d2 - d, -90.0);
            double d5 = Math.min(d2 + d, 90.0);
            double d6 = Math.max(d3 - d, -180.0);
            double d7 = Math.min(d3 + d, 180.0);
            return Sector.fromDegrees(d4, d5, d6, d7);
        }
    }

    private static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() throws IOException, ParserConfigurationException, SAXException {
            super(true, true, false);
            final MyMarkerLayer myMarkerLayer = new MyMarkerLayer(this.makeDatabase());
            myMarkerLayer.setKeepSeparated(false);
            myMarkerLayer.setPickEnabled(true);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), myMarkerLayer);
            this.getLayerPanel().update(this.getWwd());
            this.getWwd().addPositionListener(new PositionListener(){

                public void moved(PositionEvent positionEvent) {
                    myMarkerLayer.setCursorLocation(positionEvent.getPosition());
                }
            });
        }

        private SpatialTree.MarkerTree makeDatabase() {
            int n = 5;
            int n2 = 23;
            int n3 = 50;
            int n4 = 1;
            int n5 = -130;
            int n6 = -70;
            int n7 = 1;
            SpatialTree.MarkerTree markerTree = new SpatialTree.MarkerTree(n);
            BasicMarkerAttributes basicMarkerAttributes = new BasicMarkerAttributes();
            for (int i = n2; i <= n3; i += n4) {
                for (int j = n5; j <= n6; j += n7) {
                    markerTree.add(new BasicMarker(Position.fromDegrees(i, j, 0.0), basicMarkerAttributes));
                }
            }
            return markerTree;
        }
    }
}

