/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.wms.Capabilities;
import gov.nasa.worldwind.wms.WMSTiledImageLayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMSLayersPanel
extends JPanel {
    private final WorldWindow wwd;
    private final URI serverURI;
    private final Dimension size;
    private final Thread loadingThread;
    private final TreeSet<LayerInfo> layerInfos = new TreeSet<LayerInfo>(new Comparator<LayerInfo>(){

        @Override
        public int compare(LayerInfo layerInfo, LayerInfo layerInfo2) {
            String string = layerInfo.getTitle();
            String string2 = layerInfo2.getTitle();
            return string.compareTo(string2);
        }
    });

    public WMSLayersPanel(WorldWindow worldWindow, String string, Dimension dimension) throws URISyntaxException {
        super(new BorderLayout());
        this.serverURI = new URI(string.trim());
        this.wwd = worldWindow;
        this.size = dimension;
        this.setPreferredSize(this.size);
        this.makeProgressPanel();
        this.loadingThread = new Thread(new Runnable(){

            public void run() {
                WMSLayersPanel.this.load();
            }
        });
        this.loadingThread.setPriority(1);
        this.loadingThread.start();
    }

    private void load() {
        Capabilities capabilities;
        try {
            capabilities = Capabilities.retrieve(this.serverURI, "WMS");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        Element[] elementArray = capabilities.getNamedLayers();
        if (elementArray == null) {
            return;
        }
        try {
            for (Element element : elementArray) {
                Element[] elementArray2 = capabilities.getLayerStyles(element);
                if (elementArray2 == null) {
                    LayerInfo layerInfo = this.createLayerInfo(capabilities, element, null);
                    this.layerInfos.add(layerInfo);
                    continue;
                }
                for (Element element2 : elementArray2) {
                    LayerInfo layerInfo = this.createLayerInfo(capabilities, element, element2);
                    this.layerInfos.add(layerInfo);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                WMSLayersPanel.this.removeAll();
                WMSLayersPanel.this.makeLayerInfosPanel(WMSLayersPanel.this.layerInfos);
            }
        });
    }

    public String getServerDisplayString() {
        return this.serverURI.getHost();
    }

    private LayerInfo createLayerInfo(Capabilities capabilities, Element element, Element element2) {
        LayerInfo layerInfo = new LayerInfo();
        layerInfo.caps = capabilities;
        layerInfo.params = new AVListImpl();
        layerInfo.params.setValue("gov.nasa.worldwind.avkey.LayerNames", capabilities.getLayerName(element));
        if (element2 != null) {
            layerInfo.params.setValue("gov.nasa.worldwind.avkey.StyleNames", capabilities.getStyleName(element, element2));
        }
        layerInfo.params.setValue("gov.nasa.worldwind.avkey.Title", WMSLayersPanel.makeTitle(layerInfo));
        return layerInfo;
    }

    private void makeLayerInfosPanel(Collection<LayerInfo> collection) {
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 15));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        for (LayerInfo object2 : collection) {
            this.addLayerInfoPanel(jPanel, this.wwd, object2);
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jScrollPane.setPreferredSize(this.size);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 10));
        jPanel2.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Layers")));
        jPanel2.add(jScrollPane);
        this.add((Component)jPanel2, "Center");
        this.revalidate();
    }

    private void addLayerInfoPanel(JPanel jPanel, WorldWindow worldWindow, LayerInfo layerInfo) {
        LayerInfoAction layerInfoAction = new LayerInfoAction(layerInfo, worldWindow);
        JCheckBox jCheckBox = new JCheckBox(layerInfoAction);
        jCheckBox.setSelected(false);
        jPanel.add(jCheckBox);
    }

    private static String makeTitle(LayerInfo layerInfo) {
        String string = layerInfo.params.getStringValue("gov.nasa.worldwind.avkey.LayerNames");
        String string2 = layerInfo.params.getStringValue("gov.nasa.worldwind.avkey.StyleNames");
        String[] stringArray = string.split(",");
        String[] stringArray2 = string2 != null ? string2.split(",") : null;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            String string3 = stringArray[i];
            Element element = layerInfo.caps.getLayerByName(string3);
            String string4 = layerInfo.caps.getLayerTitle(element);
            stringBuilder.append(string4 != null ? string4 : string3);
            if (stringArray2 == null || stringArray2.length <= i) continue;
            String string5 = stringArray2[i];
            Element element2 = layerInfo.caps.getLayerStyleByName(element, string5);
            if (element2 == null) continue;
            stringBuilder.append(" : ");
            String string6 = layerInfo.caps.getStyleTitle(element, element2);
            stringBuilder.append(string6 != null ? string6 : string5);
        }
        return stringBuilder.toString();
    }

    private void makeProgressPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setPreferredSize(this.size);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setIndeterminate(true);
        jPanel2.add((Component)jProgressBar, "Center");
        JButton jButton = new JButton("Cancel");
        jPanel2.add((Component)jButton, "East");
        jButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (WMSLayersPanel.this.loadingThread.isAlive()) {
                    WMSLayersPanel.this.loadingThread.interrupt();
                }
                Container container = WMSLayersPanel.this.getParent();
                container.remove(WMSLayersPanel.this);
            }
        });
        jPanel.add((Component)jPanel2, "North");
        this.add((Component)jPanel, "Center");
        this.revalidate();
    }

    private class LayerInfoAction
    extends AbstractAction {
        private WorldWindow wwd;
        private LayerInfo layerInfo;
        private Layer layer;
        private String restorableState;

        public LayerInfoAction(LayerInfo layerInfo, WorldWindow worldWindow) {
            super(layerInfo.getTitle());
            this.wwd = worldWindow;
            this.layerInfo = layerInfo;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                if (this.restorableState == null) {
                    this.layer = new WMSTiledImageLayer(this.layerInfo.caps, this.layerInfo.params);
                    this.layer.setEnabled(false);
                    this.layer.setEnabled(true);
                    this.layer.setValue("gov.nasa.worldwind.avkey.URLConnectTimeout", 30000);
                    this.layer.setValue("gov.nasa.worldwind.avkey.URLReadTimeout", 30000);
                    this.layer.setValue("gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit", 60000);
                    ApplicationTemplate.insertBeforePlacenames(this.wwd, this.layer);
                    WMSLayersPanel.this.firePropertyChange("LayersPanelUpdated", null, this.layer);
                    this.restorableState = this.layer.getRestorableState();
                } else {
                    this.layer = WMSTiledImageLayer.fromRestorableState(this.restorableState);
                    ApplicationTemplate.insertBeforePlacenames(this.wwd, this.layer);
                    WMSLayersPanel.this.firePropertyChange("LayersPanelUpdated", null, this.layer);
                }
            } else {
                this.layer.setEnabled(false);
                this.wwd.getModel().getLayers().remove(this.layer);
                WMSLayersPanel.this.firePropertyChange("LayersPanelUpdated", this.layer, null);
            }
            this.wwd.redraw();
        }
    }

    private static class LayerInfo {
        private Capabilities caps;
        private AVListImpl params = new AVListImpl();

        private LayerInfo() {
        }

        private String getTitle() {
            return this.params.getStringValue("gov.nasa.worldwind.avkey.Title");
        }
    }
}

