/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples.sunlight;

import gov.nasa.worldwind.geom.Vec4;
import java.awt.Color;

public class AtmosphericScatteringComputer {
    private float fInnerRadius;
    private float fOuterRadius;
    private float fScale;
    private int nSamples = 4;
    private float Kr = 0.001f;
    private float Kr4PI = this.Kr * 4.0f * (float)Math.PI;
    private float Km = 0.0015f;
    private float Km4PI = this.Km * 4.0f * (float)Math.PI;
    private float ESun = 15.0f;
    private float g = -0.85f;
    private float fRayleighScaleDepth = 0.25f;
    private float fMieScaleDepth = 0.1f;
    private float[] fWavelength = new float[]{0.65f, 0.57f, 0.475f};
    private float[] fWavelength4 = new float[3];
    private float[] fCameraDepth = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private float[] fLightDepth = new float[4];
    private float[] fSampleDepth = new float[4];
    private float[] fRayleighSum = new float[]{0.0f, 0.0f, 0.0f};
    private float[] fMieSum = new float[]{0.0f, 0.0f, 0.0f};
    private float[] fAttenuation = new float[3];
    private float[] opticalDepthBuffer;
    private float DELTA = 1.0E-6f;
    private int nChannels = 4;
    private int nBufferWidth = 128;
    private int nBufferHeight = 128;
    private Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);

    public AtmosphericScatteringComputer(double d, double d2) {
        this.fWavelength4[0] = (float)Math.pow(this.fWavelength[0], 4.0);
        this.fWavelength4[1] = (float)Math.pow(this.fWavelength[1], 4.0);
        this.fWavelength4[2] = (float)Math.pow(this.fWavelength[2], 4.0);
        this.fInnerRadius = (float)d;
        this.fOuterRadius = (float)(d + d2);
        this.fScale = 1.0f / (this.fOuterRadius - this.fInnerRadius);
        this.computeOpticalDepthBuffer();
    }

    public Color getAtmosphereColor(Vec4 vec4, Vec4 vec42, Vec4 vec43) {
        Vec4 vec44 = vec4.subtract3(vec42);
        vec44 = vec44.normalize3();
        float f = 2.0f * (float)vec42.dot3(vec44);
        float f2 = (float)(vec42.dotSelf3() - (double)(this.fOuterRadius * this.fOuterRadius));
        float f3 = f * f - 4.0f * f2;
        Color color = this.TRANSPARENT_COLOR;
        if (f3 >= 0.0f) {
            float f4 = 0.5f * (-f - (float)Math.sqrt(f3));
            float f5 = 0.5f * (-f + (float)Math.sqrt(f3));
            if (f4 >= 0.0f || f5 >= 0.0f) {
                float f6 = Math.max(f4, f5);
                Vec4 vec45 = vec42.add3(vec44.multiply3(f6));
                color = this.getColorForVertex(vec45, vec42, vec43);
            }
        }
        return color;
    }

    private Color getColorForVertex(Vec4 vec4, Vec4 vec42, Vec4 vec43) {
        float f;
        float f2;
        float f3;
        int n;
        float f4;
        int n2;
        Vec4 vec44 = vec4.subtract3(vec42);
        float f5 = (float)vec44.getLength3();
        vec44 = vec44.normalize3();
        float f6 = 2.0f * (float)vec42.dot3(vec44);
        float f7 = (float)(vec42.dotSelf3() - (double)(this.fOuterRadius * this.fOuterRadius));
        float f8 = Math.max(0.0f, f6 * f6 - 4.0f * f7);
        float f9 = 0.5f * (-f6 - (float)Math.sqrt(f8));
        boolean bl = true;
        for (n2 = 0; n2 < this.fCameraDepth.length; ++n2) {
            this.fCameraDepth[n2] = 0.0f;
        }
        for (n2 = 0; n2 < this.fLightDepth.length; ++n2) {
            this.fLightDepth[n2] = 0.0f;
        }
        for (n2 = 0; n2 < this.fSampleDepth.length; ++n2) {
            this.fSampleDepth[n2] = 0.0f;
        }
        if (f9 <= 0.0f) {
            f9 = 0.0f;
            float f10 = (float)vec42.getLength3();
            f4 = (f10 - this.fInnerRadius) * this.fScale;
            bl = (double)f10 >= vec4.getLength3();
            float f11 = (float)(bl ? vec44.getNegative3().dot3(vec42) : vec44.dot3(vec44)) / f10;
            this.interpolate(this.fCameraDepth, f4, 0.5f - f11 * 0.5f);
        } else {
            vec42 = vec42.add3(vec44.multiply3(f9));
            f5 -= f9;
            f9 = 0.0f;
        }
        if (f5 <= this.DELTA) {
            return this.TRANSPARENT_COLOR;
        }
        for (n = 0; n < this.fRayleighSum.length; ++n) {
            this.fRayleighSum[n] = 0.0f;
        }
        for (n = 0; n < this.fMieSum.length; ++n) {
            this.fMieSum[n] = 0.0f;
        }
        float f12 = f5 / (float)this.nSamples;
        f4 = f12 * this.fScale;
        Vec4 vec45 = vec44.multiply3(f12);
        vec4 = vec42.add3(vec45.multiply3(0.5));
        for (int i = 0; i < this.nSamples; ++i) {
            float f13 = (float)vec4.getLength3();
            f3 = (float)vec43.dot3(vec4) / f13;
            f2 = (f13 - this.fInnerRadius) * this.fScale;
            this.interpolate(this.fLightDepth, f2, 0.5f - f3 * 0.5f);
            if (this.fLightDepth[0] > this.DELTA) {
                float f14;
                float f15 = f4 * this.fLightDepth[0];
                f = this.fLightDepth[1];
                float f16 = f4 * this.fLightDepth[2];
                float f17 = this.fLightDepth[3];
                if (bl) {
                    f14 = (float)vec44.getNegative3().dot3(vec4) / f13;
                    this.interpolate(this.fSampleDepth, f2, 0.5f - f14 * 0.5f);
                    f += this.fSampleDepth[1] - this.fCameraDepth[1];
                    f17 += this.fSampleDepth[3] - this.fCameraDepth[3];
                } else {
                    f14 = (float)vec44.dot3(vec4) / f13;
                    this.interpolate(this.fSampleDepth, f2, 0.5f - f14 * 0.5f);
                    f += this.fCameraDepth[1] - this.fSampleDepth[1];
                    f17 += this.fCameraDepth[3] - this.fSampleDepth[3];
                }
                this.fAttenuation[0] = (float)Math.exp(-(f *= this.Kr4PI) / this.fWavelength4[0] - (f17 *= this.Km4PI));
                this.fAttenuation[1] = (float)Math.exp(-f / this.fWavelength4[1] - f17);
                this.fAttenuation[2] = (float)Math.exp(-f / this.fWavelength4[2] - f17);
                this.fRayleighSum[0] = this.fRayleighSum[0] + f15 * this.fAttenuation[0];
                this.fRayleighSum[1] = this.fRayleighSum[1] + f15 * this.fAttenuation[1];
                this.fRayleighSum[2] = this.fRayleighSum[2] + f15 * this.fAttenuation[2];
                this.fMieSum[0] = this.fMieSum[0] + f16 * this.fAttenuation[0];
                this.fMieSum[1] = this.fMieSum[1] + f16 * this.fAttenuation[1];
                this.fMieSum[2] = this.fMieSum[2] + f16 * this.fAttenuation[2];
            }
            vec4 = vec4.add3(vec45);
        }
        float f18 = (float)vec44.getNegative3().dot3(vec43);
        float[] fArray = new float[2];
        f3 = f18 * f18;
        f2 = this.g * this.g;
        fArray[0] = 0.75f * (1.0f + f3);
        fArray[1] = 1.5f * ((1.0f - f2) / (2.0f + f2)) * (1.0f + f3) / (float)Math.pow(1.0f + f2 - 2.0f * this.g * f18, 1.5);
        fArray[0] = fArray[0] * (this.Kr * this.ESun);
        fArray[1] = fArray[1] * (this.Km * this.ESun);
        float[] fArray2 = new float[]{0.0f, 0.0f, 0.0f};
        fArray2[0] = this.fRayleighSum[0] * fArray[0] / this.fWavelength4[0] + this.fMieSum[0] * fArray[1];
        fArray2[1] = this.fRayleighSum[1] * fArray[0] / this.fWavelength4[1] + this.fMieSum[1] * fArray[1];
        fArray2[2] = this.fRayleighSum[2] * fArray[0] / this.fWavelength4[2] + this.fMieSum[2] * fArray[1];
        fArray2[0] = Math.min(fArray2[0], 1.0f);
        fArray2[1] = Math.min(fArray2[1], 1.0f);
        fArray2[2] = Math.min(fArray2[2], 1.0f);
        f = (fArray2[0] + fArray2[1] + fArray2[2]) / 3.0f;
        f = (float)Math.min((double)f + 0.5, 1.0);
        return new Color(fArray2[0], fArray2[1], fArray2[2], f);
    }

    private void interpolate(float[] fArray, float f, float f2) {
        float f3 = f * (float)(this.nBufferWidth - 1);
        float f4 = f2 * (float)(this.nBufferHeight - 1);
        int n = Math.min(this.nBufferWidth - 2, Math.max(0, (int)f3));
        int n2 = Math.min(this.nBufferHeight - 2, Math.max(0, (int)f4));
        float f5 = f3 - (float)n;
        float f6 = f4 - (float)n2;
        int n3 = (this.nBufferWidth * n2 + n) * 4;
        for (int i = 0; i < this.nChannels; ++i) {
            fArray[i] = this.opticalDepthBuffer[n3] * (1.0f - f5) * (1.0f - f6) + this.opticalDepthBuffer[n3 + this.nChannels] * f5 * (1.0f - f6) + this.opticalDepthBuffer[n3 + this.nChannels * this.nBufferWidth] * (1.0f - f5) * f6 + this.opticalDepthBuffer[n3 + this.nChannels * (this.nBufferWidth + 1)] * f5 * f6;
            ++n3;
        }
    }

    private void computeOpticalDepthBuffer() {
        int n = 128;
        int n2 = 50;
        if (this.opticalDepthBuffer == null) {
            this.opticalDepthBuffer = new float[n * n * 4];
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            float f = 1.0f - (float)(i + i) / (float)n;
            float f2 = (float)Math.acos(f);
            Vec4 vec4 = new Vec4((float)Math.sin(f2), (float)Math.cos(f2), 0.0);
            for (int j = 0; j < n; ++j) {
                float f3;
                float f4;
                boolean bl;
                float f5;
                float f6;
                float f7 = this.DELTA + this.fInnerRadius + (this.fOuterRadius - this.fInnerRadius) * (float)j / (float)n;
                Vec4 vec42 = new Vec4(0.0, f7, 0.0);
                float f8 = 2.0f * (float)vec42.dot3(vec4);
                float f9 = f8 * f8;
                float f10 = f9 - 4.0f * (f6 = (f5 = (float)vec42.dotSelf3()) - this.fInnerRadius * this.fInnerRadius);
                boolean bl2 = bl = f10 < 0.0f || 0.5f * (-f8 - (float)Math.sqrt(f10)) <= 0.0f && 0.5f * (-f8 + (float)Math.sqrt(f10)) <= 0.0f;
                if (bl) {
                    f4 = (float)Math.exp(-(f7 - this.fInnerRadius) * this.fScale / this.fRayleighScaleDepth);
                    f3 = (float)Math.exp(-(f7 - this.fInnerRadius) * this.fScale / this.fMieScaleDepth);
                } else {
                    f4 = this.opticalDepthBuffer[n3 - n * this.nChannels] * 0.75f;
                    f3 = this.opticalDepthBuffer[n3 + 2 - n * this.nChannels] * 0.75f;
                }
                f6 = f5 - this.fOuterRadius * this.fOuterRadius;
                f10 = f9 - 4.0f * f6;
                float f11 = 0.5f * (-f8 + (float)Math.sqrt(f10));
                float f12 = f11 / (float)n2;
                float f13 = f12 * this.fScale;
                Vec4 vec43 = vec4.multiply3(f12);
                vec42 = vec42.add3(vec43.multiply3(0.5));
                float f14 = 0.0f;
                float f15 = 0.0f;
                for (int k = 0; k < n2; ++k) {
                    f7 = (float)vec42.getLength3();
                    float f16 = (f7 - this.fInnerRadius) * this.fScale;
                    f16 = Math.max(f16, 0.0f);
                    f14 += (float)Math.exp(-f16 / this.fRayleighScaleDepth);
                    f15 += (float)Math.exp(-f16 / this.fMieScaleDepth);
                    vec42 = vec42.add3(vec43);
                }
                this.opticalDepthBuffer[n3++] = f4;
                this.opticalDepthBuffer[n3++] = f14 *= f13;
                this.opticalDepthBuffer[n3++] = f3;
                this.opticalDepthBuffer[n3++] = f15 *= f13;
            }
        }
    }
}

