/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioPlayer {
    public static final String STATUS_STOP = "AudioPlayer.StatusStop";
    public static final String STATUS_PLAY = "AudioPlayer.StatusPlay";
    public static final String STATUS_PAUSE = "AudioPlayer.StatusPause";
    private URL audioURL;
    private Clip clip;
    private String status = "AudioPlayer.StatusStop";

    public AudioPlayer() {
    }

    public AudioPlayer(File file) throws IOException, UnsupportedAudioFileException, LineUnavailableException {
        this.setAudioURL(file.toURL());
    }

    public AudioPlayer(URL uRL) throws IOException, UnsupportedAudioFileException, LineUnavailableException {
        this.setAudioURL(uRL);
    }

    public URL getAudioURL() {
        return this.audioURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAudioURL(URL uRL) throws IOException, UnsupportedAudioFileException, LineUnavailableException {
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(uRL);
        try {
            DataLine.Info info = new DataLine.Info(Clip.class, audioInputStream.getFormat());
            this.clip = (Clip)AudioSystem.getLine(info);
            this.clip.open(audioInputStream);
        }
        finally {
            audioInputStream.close();
        }
        this.audioURL = uRL;
        this.clip.addLineListener(new LineListener(){

            public void update(LineEvent lineEvent) {
                if (lineEvent.getType().equals(LineEvent.Type.STOP) && (AudioPlayer.this.getMillisecondPosition() == 0L || AudioPlayer.this.getMillisecondPosition() == AudioPlayer.this.getMillisecondLength())) {
                    AudioPlayer.this.stop();
                }
            }
        });
    }

    public String getStatus() {
        return this.status;
    }

    public long getMillisecondLength() {
        if (this.audioURL == null || this.clip == null) {
            return 0L;
        }
        return this.clip.getMicrosecondLength() / 1000L;
    }

    public long getMillisecondPosition() {
        if (this.audioURL == null || this.clip == null) {
            return 0L;
        }
        return this.clip.getMicrosecondPosition() / 1000L;
    }

    public void setMillisecondPosition(long l) {
        if (this.audioURL == null || this.clip == null) {
            return;
        }
        if (l < 0L || l > this.getMillisecondLength()) {
            return;
        }
        this.clip.setMicrosecondPosition(l * 1000L);
    }

    public void play() {
        if (this.audioURL == null || this.clip == null) {
            return;
        }
        if (!this.getStatus().equals(STATUS_PLAY)) {
            this.clip.start();
            this.status = STATUS_PLAY;
        }
    }

    public void pause() {
        if (this.audioURL == null || this.clip == null) {
            return;
        }
        if (this.getStatus().equals(STATUS_PLAY)) {
            this.clip.stop();
            this.status = STATUS_PAUSE;
        }
    }

    public void stop() {
        if (this.audioURL == null || this.clip == null) {
            return;
        }
        this.clip.stop();
        this.clip.setMicrosecondPosition(0L);
        this.status = STATUS_STOP;
    }
}

