/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples.util;

import gov.nasa.worldwind.examples.util.AudioPlayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AudioPlayerDialog
extends JFrame {
    protected final String TITLE_TEXT = "Audio Player";
    protected final String STOP_TEXT = "Stop";
    protected final String PLAY_TEXT = "Play";
    protected final String PAUSE_TEXT = "Pause";
    private final AudioPlayerPanel panel;

    public AudioPlayerDialog() {
        this.setTitle("Audio Player");
        this.setLayout(new BorderLayout());
        this.panel = new AudioPlayerPanel();
        this.add((Component)this.panel, "Center");
        this.pack();
    }

    public AudioPlayer getAudioPlayer() {
        return this.panel.getAudioPlayer();
    }

    public void setAudioPlayer(AudioPlayer audioPlayer) {
        this.panel.setAudioPlayer(audioPlayer);
    }

    public class AudioPlayerPanel
    extends JPanel {
        private AudioPlayer player;
        private JButton playButton;
        private JButton stopButton;
        private JSlider positionSlider;
        private JLabel timeLabel;
        private boolean suspendEvents = false;

        public AudioPlayerPanel() {
            this.initComponents();
            Timer timer = new Timer(100, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AudioPlayerPanel.this.update();
                }
            });
            timer.start();
        }

        public AudioPlayer getAudioPlayer() {
            return this.player;
        }

        public void setAudioPlayer(AudioPlayer audioPlayer) {
            if (this.player != null) {
                this.player.stop();
            }
            this.player = audioPlayer;
            this.update();
        }

        private void initComponents() {
            this.setLayout(new BoxLayout(this, 3));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 2));
            this.stopButton = new JButton("Stop");
            this.stopButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AudioPlayerPanel.this.player != null) {
                        AudioPlayerPanel.this.player.stop();
                    }
                    AudioPlayerPanel.this.update();
                }
            });
            jPanel.add(this.stopButton);
            this.playButton = new JButton("Play");
            this.playButton.setPreferredSize(new Dimension(80, 20));
            this.playButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AudioPlayerPanel.this.player != null) {
                        System.out.println("Audio player status: " + AudioPlayerPanel.this.player.getStatus() + ", pos: " + AudioPlayerPanel.this.player.getMillisecondPosition() + " / " + AudioPlayerPanel.this.player.getMillisecondLength());
                        if (AudioPlayerPanel.this.player.getStatus().equals("AudioPlayer.StatusPlay")) {
                            AudioPlayerPanel.this.player.pause();
                        } else {
                            AudioPlayerPanel.this.player.play();
                        }
                        AudioPlayerPanel.this.update();
                    }
                }
            });
            jPanel.add(this.playButton);
            jPanel.add(Box.createHorizontalStrut(10));
            this.positionSlider = new JSlider(0, 1000, 0);
            this.positionSlider.setPreferredSize(new Dimension(100, 20));
            this.positionSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (AudioPlayerPanel.this.player != null && !AudioPlayerPanel.this.suspendEvents) {
                        long l = (long)((float)AudioPlayerPanel.this.positionSlider.getValue() / 1000.0f * (float)AudioPlayerPanel.this.player.getMillisecondLength());
                        AudioPlayerPanel.this.player.setMillisecondPosition(l);
                        AudioPlayerPanel.this.updateTimeLabel();
                    }
                }
            });
            jPanel.add(this.positionSlider);
            jPanel.add(Box.createHorizontalStrut(4));
            this.timeLabel = new JLabel("00:00");
            jPanel.add(this.timeLabel);
            jPanel.add(Box.createHorizontalStrut(10));
            this.add(jPanel);
        }

        private void update() {
            if (this.suspendEvents) {
                return;
            }
            this.suspendEvents = true;
            if (this.player != null) {
                if (this.player.getStatus().equals("AudioPlayer.StatusStop")) {
                    this.stopButton.setEnabled(false);
                } else {
                    this.stopButton.setEnabled(true);
                }
                this.playButton.setEnabled(true);
                if (this.player.getStatus().equals("AudioPlayer.StatusPlay")) {
                    this.playButton.setText("Pause");
                } else {
                    this.playButton.setText("Play");
                }
                this.positionSlider.setEnabled(true);
                int n = (int)((float)this.player.getMillisecondPosition() / (float)this.player.getMillisecondLength() * 1000.0f);
                this.positionSlider.setValue(n);
                this.updateTimeLabel();
            } else {
                this.stopButton.setEnabled(false);
                this.playButton.setEnabled(false);
                this.positionSlider.setEnabled(false);
                this.updateTimeLabel();
            }
            this.suspendEvents = false;
        }

        private void updateTimeLabel() {
            if (this.player != null) {
                int n = (int)(this.player.getMillisecondPosition() > 0L ? this.player.getMillisecondPosition() : this.player.getMillisecondLength()) / 1000;
                int n2 = n / 60;
                int n3 = n % 60;
                this.timeLabel.setText(String.format("%1$02d:%2$02d", n2, n3));
            } else {
                this.timeLabel.setText("00:00");
            }
        }
    }
}

