/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples.util;

import gov.nasa.worldwind.examples.util.ImageViewerDialog;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.TransferHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlideShowPlayer
extends ImageViewerDialog {
    private SlideShowPanel controlPanel = new SlideShowPanel();
    private ArrayList<Slide> slides;
    private int slideNumber = 0;

    public SlideShowPlayer() {
        this.add((Component)this.controlPanel, "South");
    }

    public ArrayList<Slide> getSlides() {
        return this.slides;
    }

    public void setSlides(ArrayList<Slide> arrayList) {
        this.clear();
        this.slides = arrayList;
        if (arrayList != null && arrayList.size() > 0) {
            this.setSlideNumber(1);
        }
        this.controlPanel.update();
    }

    public void addSlide(Slide slide) {
        if (this.slides == null) {
            this.slides = new ArrayList();
        }
        this.slides.add(slide);
        if (this.slideNumber == 0) {
            this.setSlideNumber(1);
        }
        this.controlPanel.update();
    }

    public void clear() {
        this.slides = null;
        this.slideNumber = 0;
        this.controlPanel.update();
    }

    public int getSlideNumber() {
        return this.slideNumber;
    }

    public void setSlideNumber(int n) {
        Slide slide;
        if (this.slides != null && this.slideNumber != 0 && this.slideNumber <= this.slides.size() && (slide = this.slides.get(this.slideNumber - 1)).image == null) {
            slide.image = this.getImageViewer().getImage();
        }
        if (this.slides != null && n > 0 && n <= this.slides.size()) {
            this.slideNumber = n;
            slide = this.slides.get(this.slideNumber - 1);
            if (slide.image != null) {
                this.getImageViewer().setImage(slide.image);
            } else {
                this.getImageViewer().setImageURL(slide.imageURL);
            }
            this.setCaption(slide.caption);
            this.controlPanel.update();
        }
    }

    @Override
    protected void setupDropSupport() {
        this.setTransferHandler(new TransferHandler(){

            public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                if (!SlideShowPlayer.this.isDropEnabled()) {
                    return false;
                }
                for (DataFlavor dataFlavor : dataFlavorArray) {
                    if (!dataFlavor.equals(DataFlavor.javaFileListFlavor)) continue;
                    return true;
                }
                return false;
            }

            public boolean importData(JComponent jComponent, Transferable transferable) {
                List list;
                try {
                    list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                }
                catch (Exception exception) {
                    return false;
                }
                for (Object e : list) {
                    File file = (File)e;
                    try {
                        SlideShowPlayer.this.addSlide(new Slide(file.toURL(), file.getName()));
                    }
                    catch (Exception exception) {}
                }
                return true;
            }
        });
    }

    public class SlideShowPanel
    extends JPanel {
        private JButton previousButton;
        private JButton nextButton;
        private JLabel positionLabel;

        public SlideShowPanel() {
            this.initComponents();
        }

        private void previousButtonActionPerformed(ActionEvent actionEvent) {
            SlideShowPlayer.this.setSlideNumber(SlideShowPlayer.this.slideNumber - 1);
        }

        private void nextButtonActionPerformed(ActionEvent actionEvent) {
            SlideShowPlayer.this.setSlideNumber(SlideShowPlayer.this.slideNumber + 1);
        }

        private void initComponents() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(1, 3, 0, 0));
            this.previousButton = new JButton("<");
            this.previousButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SlideShowPanel.this.previousButtonActionPerformed(actionEvent);
                }
            });
            jPanel.add(this.previousButton);
            this.positionLabel = new JLabel("0 / 0", 0);
            jPanel.add(this.positionLabel);
            this.nextButton = new JButton(">");
            this.nextButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SlideShowPanel.this.nextButtonActionPerformed(actionEvent);
                }
            });
            jPanel.add(this.nextButton);
            this.add(jPanel);
        }

        public void update() {
            if (SlideShowPlayer.this.slides != null) {
                this.positionLabel.setText(SlideShowPlayer.this.slideNumber + " / " + SlideShowPlayer.this.slides.size());
                this.previousButton.setEnabled(SlideShowPlayer.this.slideNumber > 1);
                this.nextButton.setEnabled(SlideShowPlayer.this.slideNumber < SlideShowPlayer.this.slides.size());
            } else {
                this.positionLabel.setText("0 / 0");
                this.previousButton.setEnabled(false);
                this.nextButton.setEnabled(false);
            }
        }
    }

    public static class Slide {
        private final URL imageURL;
        private final String caption;
        private BufferedImage image;

        public Slide(URL uRL, String string) {
            this.imageURL = uRL;
            this.caption = string;
        }
    }
}

