/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples.util.cachecleaner;

import gov.nasa.worldwind.cache.FileStoreDataSet;
import java.awt.Color;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheTable
extends JTable {
    private CacheModel model = (CacheModel)this.getModel();

    public CacheTable() {
        super(new CacheModel());
        this.setShowGrid(true);
        this.setGridColor(Color.BLACK);
        this.setShowHorizontalLines(true);
        this.setShowVerticalLines(true);
        this.setIntercellSpacing(new Dimension(5, 5));
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(2);
    }

    public void setDataSets(String string, List<FileStoreDataSet> list) {
        this.model.setDataSets(string, list);
        this.setPreferredColumnWidths();
    }

    public void deleteDataSet(FileStoreDataSet fileStoreDataSet) {
        this.model.datasets.remove(fileStoreDataSet);
        this.resizeAndRepaint();
    }

    public List<FileStoreDataSet> getSelectedDataSets() {
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<FileStoreDataSet> arrayList = new ArrayList<FileStoreDataSet>();
        for (int n : nArray) {
            if (n >= this.model.datasets.size()) continue;
            arrayList.add((FileStoreDataSet)this.model.datasets.get(n));
        }
        return arrayList;
    }

    private void setPreferredColumnWidths() {
        for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            JLabel jLabel = new JLabel(this.getColumnName(i));
            int n = jLabel.getPreferredSize().width;
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            for (int j = 0; j < this.model.getRowCount(); ++j) {
                jLabel = new JLabel(this.getValueAt(j, i).toString());
                if (jLabel.getPreferredSize().width <= n) continue;
                n = jLabel.getPreferredSize().width;
            }
            tableColumn.setPreferredWidth(n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheModel
    extends AbstractTableModel {
        private static final String[] columnTitles = new String[]{"Dataset", "Last Used", "Size (MB)", "Day Old", "Week Old", "Month Old", "Year Old"};
        private static final Class[] columnTypes = new Class[]{String.class, String.class, Long.class, Long.class, Long.class, Long.class, Long.class};
        private ArrayList<FileStoreDataSet> datasets = new ArrayList();
        private String rootName;

        private CacheModel() {
        }

        public void setDataSets(String string, List<FileStoreDataSet> list) {
            this.datasets.clear();
            this.rootName = string;
            this.datasets.addAll(list);
        }

        @Override
        public int getRowCount() {
            return this.datasets.size() + 1;
        }

        @Override
        public int getColumnCount() {
            return columnTitles.length;
        }

        @Override
        public String getColumnName(int n) {
            return columnTitles[n];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return columnTypes[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n == this.datasets.size()) {
                if (n2 == 0) {
                    return "Total Size";
                }
                if (n2 == 1) {
                    return "";
                }
                Formatter formatter = new Formatter();
                return formatter.format("%5.1f", (double)this.computeColumnSum(n2) / 1000000.0);
            }
            FileStoreDataSet fileStoreDataSet = this.datasets.get(n);
            switch (n2) {
                case 0: {
                    return fileStoreDataSet.getPath().replace(this.rootName.subSequence(0, this.rootName.length()), "".subSequence(0, 0));
                }
                case 1: {
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTimeInMillis(fileStoreDataSet.getLastModified());
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM d, yyyy, hh:mm a");
                    return simpleDateFormat.format(gregorianCalendar.getTime());
                }
                case 2: {
                    Formatter formatter = new Formatter();
                    return formatter.format("%5.1f", (double)fileStoreDataSet.getSize() / 1000000.0);
                }
                case 3: {
                    Formatter formatter = new Formatter();
                    return formatter.format("%5.1f", (double)fileStoreDataSet.getOutOfScopeSize("gov.nasa.worldwind.examples.util.cachecleaner.DAY", 1) / 1000000.0);
                }
                case 4: {
                    Formatter formatter = new Formatter();
                    return formatter.format("%5.1f", (double)fileStoreDataSet.getOutOfScopeSize("gov.nasa.worldwind.examples.util.cachecleaner.WEEK", 1) / 1000000.0);
                }
                case 5: {
                    Formatter formatter = new Formatter();
                    return formatter.format("%5.1f", (double)fileStoreDataSet.getOutOfScopeSize("gov.nasa.worldwind.examples.util.cachecleaner.MONTH", 1) / 1000000.0);
                }
                case 6: {
                    Formatter formatter = new Formatter();
                    return formatter.format("%5.1f", (double)fileStoreDataSet.getOutOfScopeSize("gov.nasa.worldwind.examples.util.cachecleaner.YEAR", 1) / 1000000.0);
                }
            }
            return null;
        }

        private long computeColumnSum(int n) {
            long l = 0L;
            for (int i = 0; i < this.datasets.size(); ++i) {
                String string = this.getValueAt(i, n).toString();
                long l2 = (long)(Double.parseDouble(string) * 1000000.0);
                l += l2;
            }
            return l;
        }
    }
}

