/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.dds;

import gov.nasa.worldwind.formats.dds.DDSPixelFormat;
import gov.nasa.worldwind.util.Logging;

public class DDSHeader {
    private final int size;
    private int flags;
    private int width;
    private int height;
    private int linearSize;
    private int depth;
    private int mipMapCount;
    private DDSPixelFormat pixelFormat = new DDSPixelFormat();
    private int caps;
    private int caps2;
    private int caps3;
    private int caps4;

    public DDSHeader() {
        this.size = 124;
    }

    public final int getSize() {
        return this.size;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getLinearSize() {
        return this.linearSize;
    }

    public void setLinearSize(int n) {
        this.linearSize = n;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int n) {
        this.depth = n;
    }

    public int getMipMapCount() {
        return this.mipMapCount;
    }

    public void setMipMapCount(int n) {
        this.mipMapCount = n;
    }

    public DDSPixelFormat getPixelFormat() {
        return this.pixelFormat;
    }

    public void setPixelFormat(DDSPixelFormat dDSPixelFormat) {
        if (dDSPixelFormat == null) {
            String string = Logging.getMessage("nullValue.PixelFormatIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pixelFormat = dDSPixelFormat;
    }

    public int getCaps() {
        return this.caps;
    }

    public void setCaps(int n) {
        this.caps = n;
    }

    public int getCaps2() {
        return this.caps2;
    }

    public void setCaps2(int n) {
        this.caps2 = n;
    }

    public int getCaps3() {
        return this.caps3;
    }

    public void setCaps3(int n) {
        this.caps3 = n;
    }

    public int getCaps4() {
        return this.caps4;
    }

    public void setCaps4(int n) {
        this.caps4 = n;
    }
}

