/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.nitfs;

import gov.nasa.worldwind.formats.dds.DDSConverter;
import gov.nasa.worldwind.formats.nitfs.AbstractRPF2DDSCompress;
import gov.nasa.worldwind.formats.nitfs.DDSBlock4x4;
import gov.nasa.worldwind.formats.nitfs.NITFSImageBand;

class CADRG2DDSCompress
extends AbstractRPF2DDSCompress {
    CADRG2DDSCompress() {
    }

    public DDSBlock4x4 compressDxt1Block4x4(NITFSImageBand nITFSImageBand, byte[] byArray, boolean bl) {
        int[] nArray = new int[16];
        DDSConverter.Color[] colorArray = new DDSConverter.Color[16];
        for (int i = 0; i < byArray.length; ++i) {
            nArray[i] = nITFSImageBand.lookupR5G6B5(0xFF & byArray[i]);
            colorArray[i] = DDSConverter.getColor565(nArray[i]);
        }
        int[] nArray2 = CADRG2DDSCompress.determineExtremeColors(colorArray);
        if (nArray[nArray2[0]] < nArray[nArray2[1]]) {
            int n = nArray2[0];
            nArray2[0] = nArray2[1];
            nArray2[1] = n;
        }
        return new DDSBlock4x4((short)nArray[nArray2[0]], (short)nArray[nArray2[1]], (int)DDSConverter.computeBitMask(colorArray, nArray2));
    }
}

