/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RPFZone {
    ZONE_1('1'),
    ZONE_2('2'),
    ZONE_3('3'),
    ZONE_4('4'),
    ZONE_5('5'),
    ZONE_6('6'),
    ZONE_7('7'),
    ZONE_8('8'),
    ZONE_9('9'),
    ZONE_A('A'),
    ZONE_B('B'),
    ZONE_C('C'),
    ZONE_D('D'),
    ZONE_E('E'),
    ZONE_F('F'),
    ZONE_G('G'),
    ZONE_H('H'),
    ZONE_J('J');

    public final char zoneCode;
    private static RPFZone[] enumConstantAlphabet;

    private RPFZone(char c) {
        this.zoneCode = c;
    }

    public static boolean isZoneCode(char c) {
        char c2 = Character.toUpperCase(c);
        return c2 >= '1' && c2 <= '9' || c2 >= 'A' && c2 <= 'H' || c2 == 'J';
    }

    static int indexFor(char c) {
        int n = -1;
        char c2 = Character.toUpperCase(c);
        if (c2 >= '1' && c2 <= '9') {
            n = '\u0000' + c2 - 49;
        } else if (c2 >= 'A' && c2 <= 'H') {
            n = 9 + c2 - 65;
        } else if (c2 == 'J') {
            n = 9 + c2 - 65 - 1;
        }
        return n;
    }

    static boolean isZoneInUpperHemisphere(char c) {
        char c2 = Character.toUpperCase(c);
        return c2 >= '1' && c2 <= '9';
    }

    static boolean isPolarZone(char c) {
        char c2 = Character.toUpperCase(c);
        return c2 == '9' || c2 == 'J';
    }

    public static RPFZone zoneFor(char c) {
        RPFZone[] rPFZoneArray = RPFZone.enumConstantAlphabet();
        int n = RPFZone.indexFor(c);
        if (n < 0 || n >= rPFZoneArray.length) {
            String string = Logging.getMessage("generic.EnumNotFound", Character.valueOf(c));
            Logging.logger().fine(string);
            throw new EnumConstantNotPresentException(RPFZone.class, string);
        }
        RPFZone rPFZone = rPFZoneArray[n];
        if (rPFZone == null) {
            String string = Logging.getMessage("generic.EnumNotFound", Character.valueOf(c));
            Logging.logger().fine(string);
            throw new EnumConstantNotPresentException(RPFZone.class, string);
        }
        return rPFZone;
    }

    private static synchronized RPFZone[] enumConstantAlphabet() {
        if (enumConstantAlphabet == null) {
            RPFZone[] rPFZoneArray = (RPFZone[])RPFZone.class.getEnumConstants();
            enumConstantAlphabet = new RPFZone[rPFZoneArray.length];
            RPFZone[] rPFZoneArray2 = rPFZoneArray;
            int n = rPFZoneArray2.length;
            for (int i = 0; i < n; ++i) {
                RPFZone rPFZone;
                RPFZone.enumConstantAlphabet[RPFZone.indexFor((char)rPFZone.zoneCode)] = rPFZone = rPFZoneArray2[i];
            }
        }
        return enumConstantAlphabet;
    }

    static {
        enumConstantAlphabet = null;
    }
}

