/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.geom.BarycentricTriangle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Vec4;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;

public class BarycentricQuadrilateral
extends BarycentricTriangle {
    protected Vec4 p11;
    private double[] w11;
    private static Vec4 g0 = new Vec4(-180.0, -90.0, 0.0);
    private static Vec4 g1 = new Vec4(180.0, -90.0, 0.0);
    private static Vec4 g2 = new Vec4(180.0, 90.0, 0.0);
    private static Vec4 g3 = new Vec4(-180.0, 90.0, 0.0);
    private static Vec4 i0 = new Vec4(0.0, 0.0, 0.0);
    private static Vec4 i1 = new Vec4(1.0, 0.0, 0.0);
    private static Vec4 i2 = new Vec4(2.0, 2.0, 0.0);
    private static Vec4 i3 = new Vec4(0.0, 1.0, 0.0);
    private static ArrayList<Vec4> testPoints = new ArrayList<Vec4>(Arrays.asList(g0, g1, g2, g3, i0, i1, i2, i3, new Vec4(-17.0, 0.0, 0.0)));

    public BarycentricQuadrilateral(Vec4 vec4, Vec4 vec42, Vec4 vec43, Vec4 vec44) {
        super(vec4, vec42, vec44);
        this.p11 = vec43;
        this.w11 = this.getBarycentricCoords(this.p11);
    }

    public BarycentricQuadrilateral(LatLon latLon, LatLon latLon2, LatLon latLon3, LatLon latLon4) {
        super(latLon, latLon2, latLon4);
        this.p11 = new Vec4(latLon3.getLongitude().getRadians(), latLon3.getLatitude().getRadians(), 0.0);
        this.w11 = this.getBarycentricCoords(this.p11);
    }

    public BarycentricQuadrilateral(Point point, Point point2, Point point3, Point point4) {
        super(point, point2, point4);
        this.p11 = new Vec4(point3.x, point3.y, 0.0);
        this.w11 = this.getBarycentricCoords(this.p11);
    }

    public Vec4 getP11() {
        return this.p11;
    }

    public boolean contains(Vec4 vec4) {
        return this.invertBilinear(vec4) != null;
    }

    public double[] getBilinearCoords(double d, double d2) {
        double d3;
        double d4;
        double d5 = 1.0E-9;
        double d6 = this.w11[1];
        double d7 = this.w11[2];
        if (Math.abs(d6 - 1.0) < d5) {
            d4 = d;
            d3 = Math.abs(d7 - 1.0) < d5 ? d2 : d2 / (d4 * (d7 - 1.0) + 1.0);
        } else if (Math.abs(d7 - 1.0) < d5) {
            d3 = d2;
            d4 = d / (d3 * (d6 - 1.0) + 1.0);
        } else {
            double d8 = 1.0 - d7;
            double d9 = d * (d7 - 1.0) - d2 * (d6 - 1.0) - 1.0;
            double d10 = d;
            double d11 = d9 * d9 - 4.0 * d8 * d10;
            if (d8 == 0.0 || d11 < 0.0) {
                return new double[]{-1.0, -1.0};
            }
            double d12 = -0.5 * (d9 + (d9 != 0.0 ? Math.signum(d9) : 1.0) * Math.sqrt(d11));
            d4 = d12 / d8;
            double d13 = d10 / d12;
            double d14 = d4 = Math.abs(d4) <= Math.abs(d13) ? d4 : d13;
            if (d4 < 0.0 || d4 > 1.0) {
                d4 = d10 / d12;
            }
            d3 = Math.abs(d3 = d4 * (d7 - 1.0) + 1.0) >= d5 ? d2 / d3 : -1.0;
        }
        return new double[]{d4, d3};
    }

    public double[] getBilinearCoords(Vec4 vec4) {
        double[] dArray = this.getBarycentricCoords(vec4);
        return this.getBilinearCoords(dArray[1], dArray[2]);
    }

    public double[] invertBilinear(Vec4 vec4) {
        return BarycentricQuadrilateral.invertBilinear(vec4, this.p00, this.p10, this.p11, this.p01);
    }

    public static double[] invertBilinear(Vec4 vec4, Vec4 vec42, Vec4 vec43, Vec4 vec44, Vec4 vec45) {
        double d;
        Vec4 vec46 = vec45.subtract3(vec42);
        Vec4 vec47 = vec44.subtract3(vec43);
        Vec4 vec48 = vec4.subtract3(vec42);
        Vec4 vec49 = vec4.subtract3(vec43);
        Vec4 vec410 = vec44.subtract3(vec42).cross3(vec45.subtract3(vec43));
        double d2 = vec46.cross3(vec47).dot3(vec410);
        double d3 = vec47.cross3(vec48).dot3(vec410) - vec46.cross3(vec49).dot3(vec410);
        double d4 = d3 * d3 - 4.0 * d2 * (d = vec48.cross3(vec49).dot3(vec410));
        if (d4 < 0.0) {
            return null;
        }
        d4 = Math.sqrt(d4);
        double d5 = d3 > 0.0 ? (-d3 - d4) / (2.0 * d2) : 2.0 * d / (-d3 + d4);
        Vec4 vec411 = Vec4.mix3(d5, vec42, vec45);
        Vec4 vec412 = Vec4.mix3(d5, vec43, vec44);
        double d6 = vec4.subtract3(vec411).dot3(vec412.subtract3(vec411)) / vec412.subtract3(vec411).dotSelf3();
        return new double[]{d6, d5};
    }

    public static void main(String[] stringArray) {
        BarycentricQuadrilateral barycentricQuadrilateral = new BarycentricQuadrilateral(i0, i1, i2, i3);
        for (Vec4 vec4 : testPoints) {
            double[] dArray = barycentricQuadrilateral.getBarycentricCoords(vec4);
            Vec4 vec42 = barycentricQuadrilateral.getPoint(dArray);
            double[] dArray2 = barycentricQuadrilateral.getBilinearCoords(dArray[1], dArray[2]);
            System.out.printf("%s, %s: ( %f, %f, %f) : ( %f, %f), %s\n", vec4, vec42, dArray[0], dArray[1], dArray[2], dArray2[0], dArray2[1], vec42.equals(vec4) ? "true" : "false");
        }
    }
}

