/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.geom.BarycentricPlanarShape;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Vec4;
import java.awt.Point;

public class BarycentricTriangle
implements BarycentricPlanarShape {
    protected Vec4 p00;
    protected Vec4 p10;
    protected Vec4 p01;
    protected Vec4 q1;
    protected Vec4 q3;

    public BarycentricTriangle(Vec4 vec4, Vec4 vec42, Vec4 vec43) {
        this.p00 = vec4;
        this.p10 = vec42;
        this.p01 = vec43;
        this.q1 = vec42.subtract3(vec4);
        this.q3 = vec43.subtract3(vec4);
    }

    public BarycentricTriangle(LatLon latLon, LatLon latLon2, LatLon latLon3) {
        this.p00 = new Vec4(latLon.getLongitude().getRadians(), latLon.getLatitude().getRadians(), 0.0);
        this.p10 = new Vec4(latLon3.getLongitude().getRadians(), latLon3.getLatitude().getRadians(), 0.0);
        this.p01 = new Vec4(latLon2.getLongitude().getRadians(), latLon2.getLatitude().getRadians(), 0.0);
        this.q1 = this.p10.subtract3(this.p00);
        this.q3 = this.p01.subtract3(this.p00);
    }

    public BarycentricTriangle(Point point, Point point2, Point point3) {
        this.p00 = new Vec4(point.x, point.y, 0.0);
        this.p10 = new Vec4(point3.x, point3.y, 0.0);
        this.p01 = new Vec4(point2.x, point2.y, 0.0);
        this.q1 = this.p10.subtract3(this.p00);
        this.q3 = this.p01.subtract3(this.p00);
    }

    public Vec4 getP00() {
        return this.p00;
    }

    public Vec4 getP10() {
        return this.p10;
    }

    public Vec4 getP01() {
        return this.p01;
    }

    public double[] getBarycentricCoords(Vec4 vec4) {
        double d;
        double d2;
        Vec4 vec42 = this.q1.cross3(this.q3);
        Vec4 vec43 = vec42.getAbs3();
        Vec4 vec44 = vec4.subtract3(this.p00);
        if (vec43.x >= vec43.y && vec43.x >= vec43.z) {
            d2 = (vec44.y * this.q3.z - vec44.z * this.q3.y) / vec42.x;
            d = (this.q1.y * vec44.z - this.q1.z * vec44.y) / vec42.y;
        } else if (vec43.y >= vec43.x && vec43.y >= vec43.z) {
            d2 = (vec44.z * this.q3.x - vec44.x * this.q3.z) / vec42.y;
            d = (this.q1.z * vec44.x - this.q1.x * vec44.z) / vec42.y;
        } else {
            d2 = (vec44.x * this.q3.y - vec44.y * this.q3.x) / vec42.z;
            d = (this.q1.x * vec44.y - this.q1.y * vec44.x) / vec42.z;
        }
        return new double[]{1.0 - d2 - d, d2, d};
    }

    public double[] getBarycentricCoords(LatLon latLon) {
        return this.getBarycentricCoords(new Vec4(latLon.getLongitude().radians, latLon.getLatitude().radians, 0.0));
    }

    public boolean contains(Vec4 vec4) {
        return this.getBarycentricCoords(vec4)[0] >= 0.0;
    }

    public Vec4 getPoint(double[] dArray) {
        Vec4 vec4 = this.p00.multiply3(dArray[0]);
        Vec4 vec42 = this.p10.multiply3(dArray[1]);
        Vec4 vec43 = this.p01.multiply3(dArray[2]);
        return vec4.add3(vec42).add3(vec43);
    }

    public LatLon getLocation(double[] dArray) {
        Vec4 vec4 = this.getPoint(dArray);
        return LatLon.fromRadians(vec4.y, vec4.x);
    }

    public double[] getBilinearCoords(double d, double d2) {
        return new double[]{d, d2};
    }
}

