/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.Logging;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLUquadric;

public class Cylinder
implements Extent,
Renderable {
    private final Vec4 bottomCenter;
    private final Vec4 topCenter;
    private final Vec4 axisUnitDirection;
    private final double cylinderRadius;
    private final double cylinderHeight;

    public Cylinder(Vec4 vec4, Vec4 vec42, double d) {
        if (vec4 == null || vec42 == null) {
            String string = Logging.getMessage("nullValue.EndPointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0) {
            String string = Logging.getMessage("Geom.Cylinder.RadiusIsZeroOrNegative", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.bottomCenter = vec4;
        this.topCenter = vec42;
        this.cylinderHeight = this.bottomCenter.distanceTo3(this.topCenter);
        this.cylinderRadius = d;
        this.axisUnitDirection = this.topCenter.subtract3(this.bottomCenter).normalize3();
    }

    public Vec4 getAxisUnitDirection() {
        return this.axisUnitDirection;
    }

    public Vec4 getBottomCenter() {
        return this.bottomCenter;
    }

    public Vec4 getTopCenter() {
        return this.topCenter;
    }

    public double getCylinderRadius() {
        return this.cylinderRadius;
    }

    public double getCylinderHeight() {
        return this.cylinderHeight;
    }

    public String toString() {
        return this.cylinderRadius + ", " + this.bottomCenter.toString() + ", " + this.topCenter.toString() + ", " + this.axisUnitDirection.toString();
    }

    public Intersection[] intersect(Line line) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[2];
        if (!this.intcyl(line.getOrigin(), line.getDirection(), this.bottomCenter, this.axisUnitDirection, this.cylinderRadius, dArray)) {
            return null;
        }
        if (!this.clipcyl(line.getOrigin(), line.getDirection(), this.bottomCenter, this.topCenter, this.axisUnitDirection, dArray)) {
            return null;
        }
        if (!Double.isInfinite(dArray[0]) && !Double.isInfinite(dArray[1]) && dArray[0] >= 0.0 && dArray[1] >= 0.0) {
            return new Intersection[]{new Intersection(line.getPointAt(dArray[0]), false), new Intersection(line.getPointAt(dArray[1]), false)};
        }
        if (!Double.isInfinite(dArray[0]) && dArray[0] >= 0.0) {
            return new Intersection[]{new Intersection(line.getPointAt(dArray[0]), false)};
        }
        if (!Double.isInfinite(dArray[1]) && dArray[1] >= 0.0) {
            return new Intersection[]{new Intersection(line.getPointAt(dArray[1]), false)};
        }
        return null;
    }

    public boolean intersects(Line line) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.intersect(line) != null;
    }

    private boolean intcyl(Vec4 vec4, Vec4 vec42, Vec4 vec43, Vec4 vec44, double d, double[] dArray) {
        boolean bl;
        Vec4 vec45 = vec4.subtract3(vec43);
        Vec4 vec46 = vec42.cross3(vec44);
        double d2 = vec46.getLength3();
        if (d2 == 0.0) {
            double d3 = vec45.dot3(vec44);
            Vec4 vec47 = vec45.subtract3(vec44.multiply3(d3));
            d3 = vec47.getLength3();
            dArray[0] = Double.NEGATIVE_INFINITY;
            dArray[1] = Double.POSITIVE_INFINITY;
            return d3 <= d;
        }
        double d4 = Math.abs(vec45.dot3(vec46 = vec46.normalize3()));
        boolean bl2 = bl = d4 <= d;
        if (bl) {
            Vec4 vec48 = vec45.cross3(vec44);
            double d5 = -vec48.dot3(vec46) / d2;
            vec48 = vec46.cross3(vec44);
            vec48 = vec48.normalize3();
            double d6 = Math.abs(Math.sqrt(d * d - d4 * d4) / vec42.dot3(vec48));
            dArray[0] = d5 - d6;
            dArray[1] = d5 + d6;
        }
        return bl;
    }

    private boolean clipcyl(Vec4 vec4, Vec4 vec42, Vec4 vec43, Vec4 vec44, Vec4 vec45, double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = vec45.dot3(vec42);
        double d4 = vec45.dot3(vec4) - vec45.dot3(vec43);
        double d5 = vec45.dot3(vec4) - vec45.dot3(vec44);
        if (d3 == 0.0) {
            if (d4 <= 0.0) {
                return false;
            }
            if (d5 >= 0.0) {
                return false;
            }
        } else {
            double d6 = -d4 / d3;
            double d7 = -d5 / d3;
            if (d3 >= 0.0) {
                if (d6 > d2) {
                    return false;
                }
                if (d7 < d) {
                    return false;
                }
                if (d6 > d && d6 < d2) {
                    d = d6;
                }
                if (d7 > d && d7 < d2) {
                    d2 = d7;
                }
            } else {
                if (d6 < d) {
                    return false;
                }
                if (d7 > d2) {
                    return false;
                }
                if (d6 > d && d6 < d2) {
                    d2 = d6;
                }
                if (d7 > d && d7 < d2) {
                    d = d7;
                }
            }
        }
        dArray[0] = d;
        dArray[1] = d2;
        return d < d2;
    }

    private double intersectsAt(Plane plane, double d, double d2) {
        boolean bl;
        double d3 = plane.dot(this.bottomCenter);
        boolean bl2 = d3 <= -d;
        Vec4 vec4 = d2 < 1.0 ? this.bottomCenter.add3(this.topCenter.subtract3(this.bottomCenter).multiply3(d2)) : this.topCenter;
        double d4 = plane.dot(vec4);
        boolean bl3 = bl = d4 <= -d;
        if (bl2 && bl) {
            return -1.0;
        }
        if (bl2 == bl) {
            return d2;
        }
        return d + plane.dot(this.bottomCenter) / plane.getNormal().dot3(this.bottomCenter.subtract3(vec4));
    }

    private double getEffectiveRadius(Plane plane) {
        double d = plane.getNormal().dot3(this.axisUnitDirection);
        double d2 = 1.0 - d * d;
        if (d2 <= 0.0) {
            return 0.0;
        }
        return this.cylinderRadius * Math.sqrt(d2);
    }

    public boolean intersects(Plane plane) {
        if (plane == null) {
            String string = Logging.getMessage("nullValue.PlaneIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = this.getEffectiveRadius(plane);
        double d2 = this.intersectsAt(plane, d, 1.0);
        return d2 >= 0.0;
    }

    public boolean intersects(Frustum frustum) {
        if (frustum == null) {
            String string = Logging.getMessage("nullValue.FrustumIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = this.getEffectiveRadius(frustum.getNear());
        double d2 = this.intersectsAt(frustum.getNear(), d, 1.0);
        if (d2 < 0.0) {
            return false;
        }
        d2 = this.intersectsAt(frustum.getFar(), d, d2);
        if (d2 < 0.0) {
            return false;
        }
        d = this.getEffectiveRadius(frustum.getLeft());
        d2 = this.intersectsAt(frustum.getLeft(), d, d2);
        if (d2 < 0.0) {
            return false;
        }
        d = this.getEffectiveRadius(frustum.getRight());
        d2 = this.intersectsAt(frustum.getRight(), d, d2);
        if (d2 < 0.0) {
            return false;
        }
        d = this.getEffectiveRadius(frustum.getTop());
        d2 = this.intersectsAt(frustum.getTop(), d, d2);
        if (d2 < 0.0) {
            return false;
        }
        d = this.getEffectiveRadius(frustum.getBottom());
        d2 = this.intersectsAt(frustum.getBottom(), d, d2);
        return d2 >= 0.0;
    }

    public Vec4 getCenter() {
        Vec4 vec4 = this.bottomCenter;
        Vec4 vec42 = this.topCenter;
        return new Vec4((vec4.x + vec42.x) / 2.0, (vec4.y + vec42.y) / 2.0, (vec4.z + vec42.z) / 2.0);
    }

    public double getDiameter() {
        return 2.0 * this.getRadius();
    }

    public double getRadius() {
        double d = this.bottomCenter.distanceTo3(this.topCenter) / 2.0;
        return Math.sqrt(d * d + this.cylinderRadius * this.cylinderRadius);
    }

    public final double getHeight() {
        return this.cylinderHeight;
    }

    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = 1.0E-6;
        Vec4 vec4 = this.axisUnitDirection.cross3(Vec4.UNIT_Y).getLength3() <= d ? Vec4.UNIT_NEGATIVE_Z : Vec4.UNIT_Y;
        Matrix matrix = Matrix.fromModelLookAt(this.bottomCenter, this.topCenter, vec4);
        double[] dArray = new double[16];
        matrix.toArray(dArray, 0, false);
        GL gL = drawContext.getGL();
        gL.glPushAttrib(12288);
        gL.glBegin(1);
        gL.glVertex3d(this.bottomCenter.x, this.bottomCenter.y, this.bottomCenter.z);
        gL.glVertex3d(this.topCenter.x, this.topCenter.y, this.topCenter.z);
        gL.glEnd();
        gL.glEnable(2929);
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glMultMatrixd(dArray, 0);
        GLUquadric gLUquadric = drawContext.getGLU().gluNewQuadric();
        drawContext.getGLU().gluQuadricDrawStyle(gLUquadric, 100011);
        drawContext.getGLU().gluCylinder(gLUquadric, this.cylinderRadius, this.cylinderRadius, this.cylinderHeight, 30, 30);
        drawContext.getGLU().gluDeleteQuadric(gLUquadric);
        gL.glPopMatrix();
        gL.glPopAttrib();
    }
}

