/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.Logging;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoQuad {
    public static final int NORTH = 1;
    public static final int SOUTH = 2;
    public static final int EAST = 4;
    public static final int WEST = 8;
    public static final int NORTHWEST = 9;
    public static final int NORTHEAST = 5;
    public static final int SOUTHWEST = 10;
    public static final int SOUTHEAST = 6;
    private final LatLon sw;
    private final LatLon se;
    private final LatLon ne;
    private final LatLon nw;
    private final Line northEdge;
    private final Line southEdge;
    private final Line eastEdge;
    private final Line westEdge;

    public GeoQuad(List<? extends LatLon> list) {
        if (list == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Iterator<? extends LatLon> iterator = list.iterator();
        int n = 0;
        for (LatLon latLon : list) {
            if (latLon == null) {
                String string = Logging.getMessage("nullValue.LocationInListIsNull");
                Logging.logger().log(Level.SEVERE, string);
                throw new IllegalArgumentException(string);
            }
            if (++n <= 3) continue;
            break;
        }
        if (n < 4) {
            String string = Logging.getMessage("nullValue.LocationInListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sw = iterator.next();
        this.se = iterator.next();
        this.ne = iterator.next();
        this.nw = iterator.next();
        this.northEdge = Line.fromSegment(new Vec4(this.nw.getLongitude().degrees, this.nw.getLatitude().degrees, 0.0), new Vec4(this.ne.getLongitude().degrees, this.ne.getLatitude().degrees, 0.0));
        this.southEdge = Line.fromSegment(new Vec4(this.sw.getLongitude().degrees, this.sw.getLatitude().degrees, 0.0), new Vec4(this.se.getLongitude().degrees, this.se.getLatitude().degrees, 0.0));
        this.eastEdge = Line.fromSegment(new Vec4(this.se.getLongitude().degrees, this.se.getLatitude().degrees, 0.0), new Vec4(this.ne.getLongitude().degrees, this.ne.getLatitude().degrees, 0.0));
        this.westEdge = Line.fromSegment(new Vec4(this.sw.getLongitude().degrees, this.sw.getLatitude().degrees, 0.0), new Vec4(this.nw.getLongitude().degrees, this.nw.getLatitude().degrees, 0.0));
    }

    public LatLon getSw() {
        return this.sw;
    }

    public LatLon getSe() {
        return this.se;
    }

    public LatLon getNe() {
        return this.ne;
    }

    public LatLon getNw() {
        return this.nw;
    }

    public Angle distanceToNW(LatLon latLon) {
        return LatLon.rhumbDistance(this.nw, latLon);
    }

    public Angle distanceToNE(LatLon latLon) {
        return LatLon.rhumbDistance(this.ne, latLon);
    }

    public Angle distanceToSW(LatLon latLon) {
        return LatLon.rhumbDistance(this.sw, latLon);
    }

    public Angle distanceToSE(LatLon latLon) {
        return LatLon.rhumbDistance(this.se, latLon);
    }

    public Angle distanceToNorthEdge(LatLon latLon) {
        return Angle.fromDegrees(this.northEdge.distanceTo(new Vec4(latLon.getLongitude().degrees, latLon.getLatitude().degrees, 0.0)));
    }

    public Angle distanceToSouthEdge(LatLon latLon) {
        return Angle.fromDegrees(this.southEdge.distanceTo(new Vec4(latLon.getLongitude().degrees, latLon.getLatitude().degrees, 0.0)));
    }

    public Angle distanceToEastEdge(LatLon latLon) {
        return Angle.fromDegrees(this.eastEdge.distanceTo(new Vec4(latLon.getLongitude().degrees, latLon.getLatitude().degrees, 0.0)));
    }

    public Angle distanceToWestEdge(LatLon latLon) {
        return Angle.fromDegrees(this.westEdge.distanceTo(new Vec4(latLon.getLongitude().degrees, latLon.getLatitude().degrees, 0.0)));
    }

    public LatLon interpolate(double d, double d2) {
        Vec4 vec4 = this.northEdge.getPointAt(d2);
        Vec4 vec42 = this.southEdge.getPointAt(d2);
        Line line = Line.fromSegment(vec42, vec4);
        Vec4 vec43 = line.getPointAt(d);
        return LatLon.fromDegrees(vec43.y, vec43.x);
    }
}

