/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Position
extends LatLon {
    public static final Position ZERO = new Position(Angle.ZERO, Angle.ZERO, 0.0);
    public final double elevation;

    public static Position fromRadians(double d, double d2, double d3) {
        return new Position(Angle.fromRadians(d), Angle.fromRadians(d2), d3);
    }

    public static Position fromDegrees(double d, double d2, double d3) {
        return new Position(Angle.fromDegrees(d), Angle.fromDegrees(d2), d3);
    }

    public Position(Angle angle, Angle angle2, double d) {
        super(angle, angle2);
        this.elevation = d;
    }

    public Position(LatLon latLon, double d) {
        super(latLon);
        this.elevation = d;
    }

    public final double getElevation() {
        return this.elevation;
    }

    public final LatLon getLatLon() {
        return new LatLon(this);
    }

    @Override
    public Position add(Position position) {
        Angle angle = Angle.normalizedLatitude(this.latitude.add(position.latitude));
        Angle angle2 = Angle.normalizedLongitude(this.longitude.add(position.longitude));
        return new Position(angle, angle2, this.elevation + position.elevation);
    }

    @Override
    public Position subtract(Position position) {
        Angle angle = Angle.normalizedLatitude(this.latitude.subtract(position.latitude));
        Angle angle2 = Angle.normalizedLongitude(this.longitude.subtract(position.longitude));
        return new Position(angle, angle2, this.elevation - position.elevation);
    }

    public static Position interpolate(double d, Position position, Position position2) {
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            return position;
        }
        if (d > 1.0) {
            return position2;
        }
        LatLon latLon = LatLon.interpolate(d, position, position2);
        return new Position(latLon, d * position2.getElevation() + (1.0 - d) * position.getElevation());
    }

    public static boolean positionsCrossDateLine(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LatLon latLon = null;
        for (Position position : iterable) {
            double d;
            if (latLon != null && Math.signum(latLon.getLongitude().degrees) != Math.signum(position.getLongitude().degrees) && (d = Math.abs(latLon.getLongitude().degrees - position.getLongitude().degrees)) > 180.0 && d < 360.0) {
                return true;
            }
            latLon = position;
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Position position = (Position)object;
        return Double.compare(position.elevation, this.elevation) == 0;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        long l = this.elevation != 0.0 ? Double.doubleToLongBits(this.elevation) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    @Override
    public String toString() {
        return "(" + this.latitude.toString() + ", " + this.longitude.toString() + ", " + this.elevation + ")";
    }
}

