/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sphere;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.tracks.TrackPoint;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sector
implements Cacheable,
Comparable<Sector>,
Iterable<LatLon> {
    public static final Sector FULL_SPHERE = new Sector(Angle.NEG90, Angle.POS90, Angle.NEG180, Angle.POS180);
    public static final Sector EMPTY_SECTOR = new Sector(Angle.ZERO, Angle.ZERO, Angle.ZERO, Angle.ZERO);
    private final Angle minLatitude;
    private final Angle maxLatitude;
    private final Angle minLongitude;
    private final Angle maxLongitude;
    private final Angle deltaLat;
    private final Angle deltaLon;

    public static Sector fromDegrees(double d, double d2, double d3, double d4) {
        return new Sector(Angle.fromDegrees(d), Angle.fromDegrees(d2), Angle.fromDegrees(d3), Angle.fromDegrees(d4));
    }

    public static Sector fromRadians(double d, double d2, double d3, double d4) {
        return new Sector(Angle.fromRadians(d), Angle.fromRadians(d2), Angle.fromRadians(d3), Angle.fromRadians(d4));
    }

    public static Sector boundingSector(Iterator<TrackPoint> iterator) {
        if (iterator == null) {
            String string = Logging.getMessage("nullValue.TracksPointsIteratorNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!iterator.hasNext()) {
            return EMPTY_SECTOR;
        }
        TrackPoint trackPoint = iterator.next();
        double d = trackPoint.getLatitude();
        double d2 = trackPoint.getLongitude();
        double d3 = d;
        double d4 = d2;
        while (iterator.hasNext()) {
            TrackPoint trackPoint2 = iterator.next();
            double d5 = trackPoint2.getLatitude();
            if (d5 < d) {
                d = d5;
            } else if (d5 > d3) {
                d3 = d5;
            }
            double d6 = trackPoint2.getLongitude();
            if (d6 < d2) {
                d2 = d6;
                continue;
            }
            if (!(d6 > d4)) continue;
            d4 = d6;
        }
        return Sector.fromDegrees(d, d3, d2, d4);
    }

    public static Sector boundingSector(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = Angle.POS90.getDegrees();
        double d2 = Angle.POS180.getDegrees();
        double d3 = Angle.NEG90.getDegrees();
        double d4 = Angle.NEG180.getDegrees();
        for (LatLon latLon : iterable) {
            double d5;
            double d6 = latLon.getLatitude().getDegrees();
            if (d6 < d) {
                d = d6;
            }
            if (d6 > d3) {
                d3 = d6;
            }
            if ((d5 = latLon.getLongitude().getDegrees()) < d2) {
                d2 = d5;
            }
            if (!(d5 > d4)) continue;
            d4 = d5;
        }
        if (d == d3 && d2 == d4) {
            return EMPTY_SECTOR;
        }
        return Sector.fromDegrees(d, d3, d2, d4);
    }

    public static Iterable<? extends Sector> splitBoundingSectors(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.LocationInListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = Angle.POS90.getDegrees();
        double d2 = Angle.POS180.getDegrees();
        double d3 = Angle.NEG90.getDegrees();
        double d4 = Angle.NEG180.getDegrees();
        LatLon latLon = null;
        for (LatLon latLon2 : iterable) {
            double d5;
            double d6 = latLon2.getLatitude().getDegrees();
            if (d6 < d) {
                d = d6;
            }
            if (d6 > d3) {
                d3 = d6;
            }
            if ((d5 = latLon2.getLongitude().getDegrees()) >= 0.0 && d5 < d2) {
                d2 = d5;
            }
            if (d5 <= 0.0 && d5 > d4) {
                d4 = d5;
            }
            if (latLon != null) {
                double d7 = latLon.getLongitude().getDegrees();
                if (Math.signum(d5) != Math.signum(d7) && Math.abs(d5 - d7) < 180.0) {
                    d4 = 0.0;
                    d2 = 0.0;
                }
            }
            latLon = latLon2;
        }
        return Arrays.asList(Sector.fromDegrees(d, d3, d2, 180.0), Sector.fromDegrees(d, d3, -180.0, d4));
    }

    public static Sector boundingSector(LatLon latLon, LatLon latLon2) {
        if (latLon == null || latLon2 == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = latLon.getLatitude().degrees;
        double d2 = latLon.getLongitude().degrees;
        double d3 = latLon.getLatitude().degrees;
        double d4 = latLon.getLongitude().degrees;
        if (latLon2.getLatitude().degrees < d) {
            d = latLon2.getLatitude().degrees;
        } else if (latLon2.getLatitude().degrees > d3) {
            d3 = latLon2.getLatitude().degrees;
        }
        if (latLon2.getLongitude().degrees < d2) {
            d2 = latLon2.getLongitude().degrees;
        } else if (latLon2.getLongitude().degrees > d4) {
            d4 = latLon2.getLongitude().degrees;
        }
        if (d == d3 && d2 == d4) {
            return EMPTY_SECTOR;
        }
        return Sector.fromDegrees(d, d3, d2, d4);
    }

    public static Sector boundingSector(Globe globe, LatLon latLon, double d) {
        double d2 = d / globe.getRadiusAt(latLon);
        double d3 = Math.PI * 2;
        if (latLon.getLatitude().cos() > 0.0) {
            d3 = d2 / latLon.getLatitude().cos();
        }
        return new Sector(Angle.fromRadiansLatitude(latLon.getLatitude().radians - d2), Angle.fromRadiansLatitude(latLon.getLatitude().radians + d2), Angle.fromRadiansLongitude(latLon.getLongitude().radians - d3), Angle.fromRadiansLongitude(latLon.getLongitude().radians + d3));
    }

    public static Iterable<? extends Sector> splitBoundingSectors(Globe globe, LatLon latLon, double d) {
        double d2 = d / globe.getRadiusAt(latLon);
        double d3 = Math.PI * 2;
        if (latLon.getLatitude().cos() > 0.0) {
            d3 = d2 / latLon.getLatitude().cos();
        }
        LatLon latLon2 = new LatLon(Angle.fromRadiansLatitude(latLon.getLatitude().radians - d2), Angle.normalizedLongitude(Angle.fromRadians(latLon.getLongitude().radians - d3)));
        LatLon latLon3 = new LatLon(Angle.fromRadiansLatitude(latLon.getLatitude().radians + d2), Angle.normalizedLongitude(Angle.fromRadians(latLon.getLongitude().radians + d3)));
        List<LatLon> list = Arrays.asList(latLon2, latLon3);
        if (LatLon.positionsCrossDateLine(list)) {
            return Sector.splitBoundingSectors(list);
        }
        return Arrays.asList(Sector.boundingSector(list));
    }

    public Sector(Angle angle, Angle angle2, Angle angle3, Angle angle4) {
        if (angle == null || angle2 == null || angle3 == null || angle4 == null) {
            String string = Logging.getMessage("nullValue.InputAnglesNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.minLatitude = angle;
        this.maxLatitude = angle2;
        this.minLongitude = angle3;
        this.maxLongitude = angle4;
        this.deltaLat = Angle.fromDegrees(this.maxLatitude.degrees - this.minLatitude.degrees);
        this.deltaLon = Angle.fromDegrees(this.maxLongitude.degrees - this.minLongitude.degrees);
    }

    public Sector(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.minLatitude = new Angle(sector.getMinLatitude());
        this.maxLatitude = new Angle(sector.getMaxLatitude());
        this.minLongitude = new Angle(sector.getMinLongitude());
        this.maxLongitude = new Angle(sector.getMaxLongitude());
        this.deltaLat = Angle.fromDegrees(this.maxLatitude.degrees - this.minLatitude.degrees);
        this.deltaLon = Angle.fromDegrees(this.maxLongitude.degrees - this.minLongitude.degrees);
    }

    public final Angle getMinLatitude() {
        return this.minLatitude;
    }

    public final Angle getMinLongitude() {
        return this.minLongitude;
    }

    public final Angle getMaxLatitude() {
        return this.maxLatitude;
    }

    public final Angle getMaxLongitude() {
        return this.maxLongitude;
    }

    public final Angle getDeltaLat() {
        return this.deltaLat;
    }

    public final double getDeltaLatDegrees() {
        return this.deltaLat.degrees;
    }

    public final double getDeltaLatRadians() {
        return this.deltaLat.radians;
    }

    public final Angle getDeltaLon() {
        return this.deltaLon;
    }

    public final double getDeltaLonDegrees() {
        return this.deltaLon.degrees;
    }

    public final double getDeltaLonRadians() {
        return this.deltaLon.radians;
    }

    public boolean isWithinLatLonLimits() {
        return this.minLatitude.degrees >= -90.0 && this.maxLatitude.degrees <= 90.0 && this.minLongitude.degrees >= -180.0 && this.maxLongitude.degrees <= 180.0;
    }

    public boolean isSameSector(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!Sector.isSector(iterable)) {
            return false;
        }
        Sector sector = Sector.boundingSector(iterable);
        return sector.equals(this);
    }

    public static boolean isSector(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LatLon[] latLonArray = new LatLon[5];
        int n = 0;
        for (LatLon latLon : iterable) {
            if (n > 4 || latLon == null) {
                return false;
            }
            latLonArray[n++] = latLon;
        }
        if (!latLonArray[0].getLatitude().equals(latLonArray[1].getLatitude())) {
            return false;
        }
        if (!latLonArray[2].getLatitude().equals(latLonArray[3].getLatitude())) {
            return false;
        }
        if (!latLonArray[0].getLongitude().equals(latLonArray[3].getLongitude())) {
            return false;
        }
        if (!latLonArray[1].getLongitude().equals(latLonArray[2].getLongitude())) {
            return false;
        }
        return n != 5 || latLonArray[4].equals(latLonArray[0]);
    }

    public LatLon getCentroid() {
        Angle angle = Angle.fromDegrees(0.5 * (this.getMaxLatitude().degrees + this.getMinLatitude().degrees));
        Angle angle2 = Angle.fromDegrees(0.5 * (this.getMaxLongitude().degrees + this.getMinLongitude().degrees));
        return new LatLon(angle, angle2);
    }

    public Vec4 computeCenterPoint(Globe globe, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = 0.5 * (this.minLatitude.degrees + this.maxLatitude.degrees);
        double d3 = 0.5 * (this.minLongitude.degrees + this.maxLongitude.degrees);
        Angle angle = Angle.fromDegrees(d2);
        Angle angle2 = Angle.fromDegrees(d3);
        return globe.computePointFromPosition(angle, angle2, d * globe.getElevation(angle, angle2));
    }

    public Vec4[] computeCornerPoints(Globe globe, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4[] vec4Array = new Vec4[4];
        Angle angle = this.minLatitude;
        Angle angle2 = this.maxLatitude;
        Angle angle3 = this.minLongitude;
        Angle angle4 = this.maxLongitude;
        vec4Array[0] = globe.computePointFromPosition(angle, angle3, d * globe.getElevation(angle, angle3));
        vec4Array[1] = globe.computePointFromPosition(angle, angle4, d * globe.getElevation(angle, angle4));
        vec4Array[2] = globe.computePointFromPosition(angle2, angle4, d * globe.getElevation(angle2, angle4));
        vec4Array[3] = globe.computePointFromPosition(angle2, angle3, d * globe.getElevation(angle2, angle3));
        return vec4Array;
    }

    public static Extent computeBoundingSphere(Globe globe, double d, Sector sector) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LatLon latLon = sector.getCentroid();
        double[] dArray = globe.getMinAndMaxElevations(sector);
        double d2 = dArray[0] * d;
        double d3 = dArray[1] * d;
        Vec4[] vec4Array = new Vec4[]{globe.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), d3), globe.computePointFromPosition(sector.getMaxLatitude(), sector.getMinLongitude(), d3), globe.computePointFromPosition(sector.getMinLatitude(), sector.getMaxLongitude(), d3), globe.computePointFromPosition(sector.getMinLatitude(), sector.getMinLongitude(), d3), globe.computePointFromPosition(sector.getMaxLatitude(), sector.getMaxLongitude(), d3), globe.computePointFromPosition(sector.getMaxLatitude(), sector.getMinLongitude(), d2), globe.computePointFromPosition(sector.getMinLatitude(), sector.getMaxLongitude(), d2), globe.computePointFromPosition(sector.getMinLatitude(), sector.getMinLongitude(), d2), globe.computePointFromPosition(sector.getMaxLatitude(), sector.getMaxLongitude(), d2)};
        return Sphere.createBoundingSphere(vec4Array);
    }

    public final boolean contains(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.containsDegrees(angle.degrees, angle2.degrees);
    }

    public final boolean contains(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.contains(latLon.getLatitude(), latLon.getLongitude());
    }

    public boolean containsRadians(double d, double d2) {
        return d >= this.minLatitude.radians && d <= this.maxLatitude.radians && d2 >= this.minLongitude.radians && d2 <= this.maxLongitude.radians;
    }

    public boolean containsDegrees(double d, double d2) {
        return d >= this.minLatitude.degrees && d <= this.maxLatitude.degrees && d2 >= this.minLongitude.degrees && d2 <= this.maxLongitude.degrees;
    }

    public boolean contains(Sector sector) {
        if (sector == null) {
            return false;
        }
        if (sector.minLongitude.degrees < this.minLongitude.degrees) {
            return false;
        }
        if (sector.maxLongitude.degrees > this.maxLongitude.degrees) {
            return false;
        }
        if (sector.minLatitude.degrees < this.minLatitude.degrees) {
            return false;
        }
        return !(sector.maxLatitude.degrees > this.maxLatitude.degrees);
    }

    public boolean intersects(Sector sector) {
        if (sector == null) {
            return false;
        }
        if (sector.maxLongitude.degrees < this.minLongitude.degrees) {
            return false;
        }
        if (sector.minLongitude.degrees > this.maxLongitude.degrees) {
            return false;
        }
        if (sector.maxLatitude.degrees < this.minLatitude.degrees) {
            return false;
        }
        return !(sector.minLatitude.degrees > this.maxLatitude.degrees);
    }

    public final Sector union(Sector sector) {
        if (sector == null) {
            return this;
        }
        Angle angle = this.minLatitude;
        Angle angle2 = this.maxLatitude;
        Angle angle3 = this.minLongitude;
        Angle angle4 = this.maxLongitude;
        if (sector.minLatitude.degrees < this.minLatitude.degrees) {
            angle = sector.minLatitude;
        }
        if (sector.maxLatitude.degrees > this.maxLatitude.degrees) {
            angle2 = sector.maxLatitude;
        }
        if (sector.minLongitude.degrees < this.minLongitude.degrees) {
            angle3 = sector.minLongitude;
        }
        if (sector.maxLongitude.degrees > this.maxLongitude.degrees) {
            angle4 = sector.maxLongitude;
        }
        return new Sector(angle, angle2, angle3, angle4);
    }

    public final Sector union(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            return this;
        }
        Angle angle3 = this.minLatitude;
        Angle angle4 = this.maxLatitude;
        Angle angle5 = this.minLongitude;
        Angle angle6 = this.maxLongitude;
        if (angle.degrees < this.minLatitude.degrees) {
            angle3 = angle;
        }
        if (angle.degrees > this.maxLatitude.degrees) {
            angle4 = angle;
        }
        if (angle2.degrees < this.minLongitude.degrees) {
            angle5 = angle2;
        }
        if (angle2.degrees > this.maxLongitude.degrees) {
            angle6 = angle2;
        }
        return new Sector(angle3, angle4, angle5, angle6);
    }

    public static Sector union(Sector sector, Sector sector2) {
        if (sector == null || sector2 == null) {
            if (sector == sector2) {
                return sector;
            }
            return sector2 == null ? sector : sector2;
        }
        return sector.union(sector2);
    }

    public static Sector union(Iterable<? extends Sector> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.SectorListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Angle angle = Angle.POS90;
        Angle angle2 = Angle.NEG90;
        Angle angle3 = Angle.POS180;
        Angle angle4 = Angle.NEG180;
        for (Sector sector : iterable) {
            if (sector == null) continue;
            for (LatLon latLon : sector) {
                if (latLon.getLatitude().degrees < angle.degrees) {
                    angle = latLon.getLatitude();
                }
                if (latLon.getLatitude().degrees > angle2.degrees) {
                    angle2 = latLon.getLatitude();
                }
                if (latLon.getLongitude().degrees < angle3.degrees) {
                    angle3 = latLon.getLongitude();
                }
                if (!(latLon.getLongitude().degrees > angle4.degrees)) continue;
                angle4 = latLon.getLongitude();
            }
        }
        return new Sector(angle, angle2, angle3, angle4);
    }

    public final Sector intersection(Sector sector) {
        Angle angle;
        Angle angle2;
        if (sector == null) {
            return this;
        }
        Angle angle3 = this.minLatitude.degrees > sector.minLatitude.degrees ? this.minLatitude : sector.minLatitude;
        Angle angle4 = angle2 = this.maxLatitude.degrees < sector.maxLatitude.degrees ? this.maxLatitude : sector.maxLatitude;
        if (angle3.degrees > angle2.degrees) {
            return null;
        }
        Angle angle5 = this.minLongitude.degrees > sector.minLongitude.degrees ? this.minLongitude : sector.minLongitude;
        Angle angle6 = angle = this.maxLongitude.degrees < sector.maxLongitude.degrees ? this.maxLongitude : sector.maxLongitude;
        if (angle5.degrees > angle.degrees) {
            return null;
        }
        return new Sector(angle3, angle2, angle5, angle);
    }

    public final Sector intersection(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            return this;
        }
        if (!this.contains(angle, angle2)) {
            return null;
        }
        return new Sector(angle, angle, angle2, angle2);
    }

    public Sector[] subdivide() {
        Angle angle = Angle.average(this.minLatitude, this.maxLatitude);
        Angle angle2 = Angle.average(this.minLongitude, this.maxLongitude);
        Sector[] sectorArray = new Sector[]{new Sector(this.minLatitude, angle, this.minLongitude, angle2), new Sector(this.minLatitude, angle, angle2, this.maxLongitude), new Sector(angle, this.maxLatitude, this.minLongitude, angle2), new Sector(angle, this.maxLatitude, angle2, this.maxLongitude)};
        return sectorArray;
    }

    public Sector[] subdivide(int n) {
        double d = this.deltaLat.degrees / (double)n;
        double d2 = this.deltaLon.degrees / (double)n;
        Sector[] sectorArray = new Sector[n * n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                sectorArray[n2++] = Sector.fromDegrees(this.minLatitude.degrees + d * (double)i, this.minLatitude.degrees + d * (double)i + d, this.minLongitude.degrees + d2 * (double)j, this.minLongitude.degrees + d2 * (double)j + d2);
            }
        }
        return sectorArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(this.minLatitude.toString());
        stringBuffer.append(", ");
        stringBuffer.append(this.minLongitude.toString());
        stringBuffer.append(")");
        stringBuffer.append(", ");
        stringBuffer.append("(");
        stringBuffer.append(this.maxLatitude.toString());
        stringBuffer.append(", ");
        stringBuffer.append(this.maxLongitude.toString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public long getSizeInBytes() {
        return 4L * this.minLatitude.getSizeInBytes();
    }

    @Override
    public int compareTo(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.getMinLatitude().compareTo(sector.getMinLatitude()) < 0) {
            return -1;
        }
        if (this.getMinLatitude().compareTo(sector.getMinLatitude()) > 0) {
            return 1;
        }
        if (this.getMinLongitude().compareTo(sector.getMinLongitude()) < 0) {
            return -1;
        }
        if (this.getMinLongitude().compareTo(sector.getMinLongitude()) > 0) {
            return 1;
        }
        if (this.getMaxLatitude().compareTo(sector.getMaxLatitude()) < 0) {
            return -1;
        }
        if (this.getMaxLatitude().compareTo(sector.getMaxLatitude()) > 0) {
            return 1;
        }
        if (this.getMaxLongitude().compareTo(sector.getMaxLongitude()) < 0) {
            return -1;
        }
        if (this.getMaxLongitude().compareTo(sector.getMaxLongitude()) > 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public Iterator<LatLon> iterator() {
        return new Iterator<LatLon>(){
            private int position = 0;

            @Override
            public boolean hasNext() {
                return this.position < 4;
            }

            @Override
            public LatLon next() {
                LatLon latLon;
                if (this.position > 3) {
                    throw new NoSuchElementException();
                }
                switch (this.position) {
                    case 0: {
                        latLon = new LatLon(Sector.this.getMinLatitude(), Sector.this.getMinLongitude());
                        break;
                    }
                    case 1: {
                        latLon = new LatLon(Sector.this.getMinLatitude(), Sector.this.getMaxLongitude());
                        break;
                    }
                    case 2: {
                        latLon = new LatLon(Sector.this.getMaxLatitude(), Sector.this.getMaxLongitude());
                        break;
                    }
                    default: {
                        latLon = new LatLon(Sector.this.getMaxLatitude(), Sector.this.getMinLongitude());
                    }
                }
                ++this.position;
                return latLon;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public List<LatLon> asList() {
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(4);
        for (LatLon latLon : this) {
            arrayList.add(latLon);
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Sector sector = (Sector)object;
        if (!this.maxLatitude.equals(sector.maxLatitude)) {
            return false;
        }
        if (!this.maxLongitude.equals(sector.maxLongitude)) {
            return false;
        }
        if (!this.minLatitude.equals(sector.minLatitude)) {
            return false;
        }
        return this.minLongitude.equals(sector.minLongitude);
    }

    public int hashCode() {
        int n = this.minLatitude.hashCode();
        n = 29 * n + this.maxLatitude.hashCode();
        n = 29 * n + this.minLongitude.hashCode();
        n = 29 * n + this.maxLongitude.hashCode();
        return n;
    }
}

