/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.Logging;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLUquadric;

public final class Sphere
implements Extent,
Renderable {
    public static final Sphere UNIT_SPHERE = new Sphere(Vec4.ZERO, 1.0);
    private final Vec4 center;
    private final double radius;

    public static Sphere createBoundingSphere(Vec4[] vec4Array) {
        if (vec4Array == null) {
            String string = Logging.getMessage("nullValue.PointsArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4Array.length < 1) {
            String string = Logging.getMessage("Geom.Sphere.NoPointsSpecified");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4[] vec4Array2 = Sphere.composeExtrema(vec4Array);
        Vec4 vec4 = new Vec4((vec4Array2[0].x + vec4Array2[1].x) / 2.0, (vec4Array2[0].y + vec4Array2[1].y) / 2.0, (vec4Array2[0].z + vec4Array2[1].z) / 2.0);
        double d = vec4Array2[0].distanceTo3(vec4Array2[1]) / 2.0;
        return new Sphere(vec4, d);
    }

    public Sphere(Vec4 vec4, double d) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.CenterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0) {
            String string = Logging.getMessage("Geom.Sphere.RadiusIsZeroOrNegative", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.center = vec4;
        this.radius = d;
    }

    public static Vec4[] composeExtrema(Vec4[] vec4Array) {
        if (vec4Array == null) {
            String string = Logging.getMessage("nullValue.PointsArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4Array.length == 0) {
            return null;
        }
        double d = vec4Array[0].x;
        double d2 = vec4Array[0].y;
        double d3 = vec4Array[0].z;
        double d4 = d;
        double d5 = d2;
        double d6 = d3;
        for (int i = 1; i < vec4Array.length; ++i) {
            double d7 = vec4Array[i].x;
            if (d7 > d4) {
                d4 = d7;
            } else if (d7 < d) {
                d = d7;
            }
            double d8 = vec4Array[i].y;
            if (d8 > d5) {
                d5 = d8;
            } else if (d8 < d2) {
                d2 = d8;
            }
            double d9 = vec4Array[i].z;
            if (d9 > d6) {
                d6 = d9;
                continue;
            }
            if (!(d9 < d3)) continue;
            d3 = d9;
        }
        return new Vec4[]{new Vec4(d, d2, d3), new Vec4(d4, d5, d6)};
    }

    public final double getRadius() {
        return this.radius;
    }

    public final double getDiameter() {
        return 2.0 * this.radius;
    }

    public final Vec4 getCenter() {
        return this.center;
    }

    public final Intersection[] intersect(Line line) {
        double d;
        double d2;
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d3 = line.getDirection().getLengthSquared3();
        double d4 = Sphere.discriminant(d3, d2 = 2.0 * line.selfDot(), d = line.getOrigin().getLengthSquared3() - this.radius * this.radius);
        if (d4 < 0.0) {
            return null;
        }
        double d5 = Math.sqrt(d4);
        if (d4 == 0.0) {
            Vec4 vec4 = line.getPointAt((-d2 - d5) / (2.0 * d3));
            return new Intersection[]{new Intersection(vec4, true)};
        }
        Vec4 vec4 = line.getPointAt((-d2 - d5) / (2.0 * d3));
        Vec4 vec42 = line.getPointAt((-d2 + d5) / (2.0 * d3));
        return new Intersection[]{new Intersection(vec4, false), new Intersection(vec42, false)};
    }

    private static double discriminant(double d, double d2, double d3) {
        return d2 * d2 - 4.0 * d * d3;
    }

    public boolean intersects(Frustum frustum) {
        if (frustum == null) {
            String string = Logging.getMessage("nullValue.FrustumIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return frustum.intersects(this);
    }

    public boolean intersects(Line line) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return line.distanceTo(this.center) <= this.radius;
    }

    public boolean intersects(Plane plane) {
        if (plane == null) {
            String string = Logging.getMessage("nullValue.PlaneIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = plane.dot(this.center);
        return d <= this.radius;
    }

    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL gL = drawContext.getGL();
        gL.glPushAttrib(270337);
        gL.glDisable(3553);
        gL.glColor3d(1.0, 1.0, 0.0);
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glTranslated(this.center.x, this.center.y, this.center.z);
        GLUquadric gLUquadric = drawContext.getGLU().gluNewQuadric();
        drawContext.getGLU().gluQuadricDrawStyle(gLUquadric, 100011);
        drawContext.getGLU().gluSphere(gLUquadric, this.radius, 10, 10);
        gL.glPopMatrix();
        drawContext.getGLU().gluDeleteQuadric(gLUquadric);
        gL.glPopAttrib();
    }

    public String toString() {
        return "Sphere: center = " + this.center.toString() + " radius = " + Double.toString(this.radius);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Sphere sphere = (Sphere)object;
        if (Double.compare(sphere.radius, this.radius) != 0) {
            return false;
        }
        return this.center.equals(sphere.center);
    }

    public int hashCode() {
        int n = this.center.hashCode();
        long l = this.radius != 0.0 ? Double.doubleToLongBits(this.radius) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        return n;
    }
}

