/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.Logging;

public class Triangle {
    private static final double EPSILON = 1.0E-7;
    private final Vec4 a;
    private final Vec4 b;
    private final Vec4 c;

    public Triangle(Vec4 vec4, Vec4 vec42, Vec4 vec43) {
        if (vec4 == null || vec42 == null || vec43 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.a = vec4;
        this.b = vec42;
        this.c = vec43;
    }

    public Vec4 getA() {
        return this.a;
    }

    public Vec4 getB() {
        return this.b;
    }

    public Vec4 getC() {
        return this.c;
    }

    public Vec4 intersect(Line line) {
        Vec4 vec4;
        Vec4 vec42;
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec43 = line.getOrigin();
        Vec4 vec44 = line.getDirection();
        Vec4 vec45 = this.b.subtract3(this.a);
        double d = vec45.dot3(vec42 = vec44.cross3(vec4 = this.c.subtract3(this.a)));
        if (d > -1.0E-7 && d < 1.0E-7) {
            return null;
        }
        double d2 = 1.0 / d;
        Vec4 vec46 = vec43.subtract3(this.a);
        double d3 = vec46.dot3(vec42) * d2;
        if (d3 < 0.0 || d3 > 1.0) {
            return null;
        }
        Vec4 vec47 = vec46.cross3(vec45);
        double d4 = vec44.dot3(vec47) * d2;
        if (d4 < 0.0 || d3 + d4 > 1.0) {
            return null;
        }
        double d5 = vec4.dot3(vec47) * d2;
        if (d5 < 0.0) {
            return null;
        }
        return line.getPointAt(d5);
    }

    public String toString() {
        return "Triangle (" + this.a + ", " + this.b + ", " + this.c + ")";
    }
}

